/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* mousehk.h  -  header file for mouse routines */

#ifndef MOUSEHK_HEADER
#define MOUSEHK_HEADER  1

#include <howard.h>

#define MOUSEINT        0x33    /* mouse INTerrupt */

#define MOUSE_INSTALLED -1      /* mouse hardware/driver installed */
#define NO_MOUSE        0       /* mouse hardware/driver not installed */

#define TWOBUTTONS      -1      /* 2 buttons */
#define XBUTTONS        0       /* other than 2 buttons */
#define MSYSMOUSE       3       /* Mouse Systems mouse (PC Mouse) */

#define LEFTBUTTON      0
#define RIGHTBUTTON     1
#define MIDDLEBUTTON    2

#define LBPRESSED       0x01    /* Left button pressed */
#define RBPRESSED       0x02    /* Right button pressed */
#define MBPRESSED       0x04    /* Middle button pressed */

/* mouse info */
boolean ismouse(void);          /* is mouse driver installed */
int MButtonPress(int button);   /* mouse button press data */
int MButtonRelease(int button); /* mouse button release data */
int MButtonStatus(void);        /* mouse button status */
int MMickeysMovedx(void);       /* numbers of mickeys mouse moved horizontally */
int MMickeysMovedy(void);       /* numbers of mickeys mouse moved vertically */

/* cursor control */
void MCursorOff(void);          /* mouse cursor off (nestable) */
void MCursorOn(void);           /* mouse cursor on (nestable) */
void MCursorRangex(int left, int right);    /* mouse cursor horizontal range */
void MCursorRangey(int top, int bottom);    /* mouse cursor vertical range */
void MCursorGraphic(int hotx, int hoty, char *bitmap);          /* define graphics cursor */
void MCursorText(boolean usehardware, int parm1, int parm2);    /* define text cursor */
void MGotoxy(int x, int y);     /* position mouse cursor */

/* mouse driver */
unsigned int MDriverSize(void); /* size of buffer needed to store driver state */
void MGetDriver(char far *savebuffer);      /* save mouse driver state */
void MPutDriver(char far *savebuffer);      /* restore mouse driver state */
boolean MouseReset(void);                   /* Reset mouse software only */
unsigned int MGetVerType(void);             /* Get software version and mouse type */

/* mouse screen interaction */
unsigned MGetDisplayPage(void);             /* Get display page number */
void MSetDisplayPage(unsigned page);        /* Set display page number */
void MUpdateScreen(int left, int top, int right, int bottom);   /* update screen region */

/* mouse settings */
void MEmulateLightpenOn(void);  /* mouse emulate light pen on */
void MEmulateLightpenOff(void); /* mouse emulate light pen off */
void MSetRatio(int mickeyx, int mickeyy);   /* set mickey to pixel ratio */
void MSetThreshold(int speed);  /* set the double speed threshold */
unsigned MGetSensitivity(void);             /* Get mouse sensitivity */
void MSetSensitivity(int horiz, int vert, int dspeedthresh);    /* Set mouse sensitivity */

#endif              /* MOUSEHK_HEADER */
