{ Copyright (C) 1998 by Cristi Streng }

{$A+,B-,D-,E+,F-,G+,I+,L+,N+,O-,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 65520,0,655360}
program Example_1_PChar;
uses
   crt,dos70p,strings;
var
   VI:TVolInfo;
   Data:TFindData;
   SwapInfo:TSwapInfo;
   OldDir,ss:pchar;
   s:string;
   c,CurDrive:char;
   x:integer;
   i,d,rd:word;
   f:LFNFile;
   buf:string;
   p1, p2, p3:pchar;
   major,minor:byte;
begin
  ClrScr;
  GetMem (p1, MAX_PATH); { GetMem allocates memory for the pchar variables }
  GetMem (p2, MAX_PATH);
  GetMem (p3, MAX_PATH);
  GetMem (VI.FSName, MAX_PATH);
  GetMem (SwapInfo.FileName, MAX_PATH);
  GetMem (Data.Name, MAX_PATH);
  GetMem (Data.ShortName, MAX_PATH);
  TextColor (LightGray);
  if not IsDOS70 then
  begin
    Writeln ('Sorry, you must run DOS 7.x (Windows 95).');
    FreeMem (p1, MAX_PATH);
    FreeMem (p2, MAX_PATH);
    FreeMem (p3, MAX_PATH);
    FreeMem (VI.FSName, MAX_PATH);
    FreeMem (SwapInfo.FileName, MAX_PATH);
    FreeMem (Data.Name, MAX_PATH);
    FreeMem (Data.ShortName, MAX_PATH);
    Halt
  end;
  GetVer (major, minor);
  Writeln ('DOS Version: ', major, '.', minor);
  GetWinVer (major, minor);
  Writeln ('Windows Version: ', major, '.', minor);
  GetShell (p1);
  GetShellComLine (p2);
  Writeln ('Primary shell (with command line): ', p1, ' ', p2);
  GetRegistryPath (p1);
  Writeln ('SYSTEM.DAT registry file path: ', p1);
  Writeln ('WIN.COM nesting level: ', GetWinNesting);
  Writeln;
  Writeln ('Press any key to continue...');
  ReadKey;
  GetDir (0,s); { Get Current Dir }
  CurDrive:=s[1];
  StrPCopy (p1, Copy (s, 1, 3));
  GetVolumeInformation (p1, VI); { if this doesn't work, then you are in MS-DOS mode }
  if StrComp (VI.FSName, '') = 0 then
  begin
    Writeln ('Sorry, you are in MS-DOS mode. Type ''EXIT'' or ''WIN'' to restart');
    Writeln ('Windows 95');
    FreeMem (p1, MAX_PATH);
    FreeMem (p2, MAX_PATH);
    FreeMem (p3, MAX_PATH);
    FreeMem (VI.FSName, MAX_PATH);
    FreeMem (SwapInfo.FileName, MAX_PATH);
    FreeMem (Data.Name, MAX_PATH);
    FreeMem (Data.ShortName, MAX_PATH);
    Halt
  end;
  repeat
    ClrScr;
    if Length (s)<3 then
      s:=s[1]+':\';
    StrPCopy (p1, Copy (s, 1, 3));
    GetVolumeInformation (p1, VI);
    if DOS7Error<>0 then
      Writeln ('Dos reported error ',DOS7Error)
    else
    begin
      TextColor (Yellow);
      Writeln ('Volume Info : ',Copy (s,1,2));
      TextColor (LightGray);
      Writeln;
      Writeln ('   File System              : ',VI.FSName);
      Writeln ('   Maximum File Name Length : ',VI.MaxFileName);
      Writeln ('   Maximum Path Length      : ',VI.MaxPath);
      Writeln ('   Flags : ');
      if (VI.Flags and FS_COMPRESSED)<>0 then
        Writeln ('   - Is compressed');
      if (VI.Flags and FS_LFN_APIS)<>0 then
        Writeln ('   - Supports long filename functions');
      if (VI.Flags and FS_UNICODE_USED)<>0 then
        Writeln ('   - Uses UNICODE characters in file names');
      if (VI.Flags and FS_CASE_PRESERVED)<>0 then
        Writeln ('   - Case is preserved in directory entries');
      if (VI.Flags and FS_CASE_SENSITIVE)<>0 then
        Writeln ('   - Searches are case sensitive');
      Writeln
    end;
    Writeln;
    TextColor (LightCyan);
    Write ('Other volume ? Enter a path or <ENTER> to continue : ');
    Readln (s)
  until s='';

  Writeln;
  TextColor (Yellow);
  Writeln ('Swap File Info:');
  TextColor (LightGray);
  GetSwapFileInfo (SwapInfo);
  Writeln;
  Writeln ('File Name  : ', SwapInfo.FileName);
  Writeln ('Size       : ', SwapInfo.FileSize:1:0, ' bytes');
  Write ('Pager Type : ');
  case SwapInfo.Pager of
    SW_NOPAGER: Writeln ('No Pager');
    SW_DOSPAGER: Writeln ('Paging through MS-DOS');
    SW_IOSPAGER: Writeln ('Paging through Protected-Mode I/O Supervisor');
    else Writeln ('Unknown')
  end;
  Writeln;
  TextColor (LightCyan);
  Writeln ('Press any key to continue...');
  Writeln;
  Readkey;

  ClrScr;
  TextColor (Yellow);
  Writeln ('Directory Info:');
  Writeln;
  TextColor (LightGray);
  LFNGetDir (p1, 0);
  GetLongPathName (p2, p1, NO_SUBST_EXPAND);
  Writeln ('Your current directory is :', p2);
  GetFullPathName (p2, p1, NO_SUBST_EXPAND);
  Writeln ('                 DOS Name :', p2);
  if p1[StrLen(p1)-1]<>'\' then { not in root dir }
  begin
    GetLongPathName (p2, '..', NO_SUBST_EXPAND);
    Writeln ('Your parent directory is :', p2);
    GetFullPathName (p2, '..', NO_SUBST_EXPAND);
    Writeln ('                DOS Name :', p2)
  end;
  Writeln;
  TextColor (LightCyan);
  Writeln ('Press any key to continue...');
  Writeln;
  Readkey;

  TextColor (Yellow);
  Writeln ('Executable files in current directory:');
  TextColor (LightGray);
  Writeln;
  x:=LFNFindFirst ('*.exe', FA_NORMAL, FA_ANY, Data);
  while DOS7Error=0 do { found }
  begin
    Writeln ('   ',Data.Name);
    LFNFindNext (x, Data)
  end;
  LFNFindClose (x);
  Writeln;
  TextColor (LightCyan);
  Writeln ('Press any key to continue...');
  ReadKey;

  ClrScr;
  TextColor (Yellow);
  Writeln ('Directory Operations:');
  TextColor (LightGray);
  Writeln;

  LFNGetDir (OldDir, 0);
  Write ('Create Directory (absolute or relative path) (<ENTER> to skip) : ');
  Readln (s);
  StrPCopy (p1, s);
  if s<>'' then
  begin
    LFNMkDir (p1);
    if DOS7Error<>0 then
      Writeln ('    --- Error: Could not create the specified directory ---')
  end;

  LFNGetDir (p2, 0);
  GetLongPathName (p3, p2, NO_SUBST_EXPAND);
  Writeln ('Current Directory : ', p3);
  Writeln ('Changing to ',s);
  LFNChDir (p1);
  d:=DOS7Error;
  if d<>0 then
    Writeln ('    --- Error: Could not change directory ---');
  LFNGetDir (p2, 0);
  GetLongPathName (p3, p2, NO_SUBST_EXPAND);
  Writeln ('Current Directory : ', p3);

  if d=0 then
  begin
    Writeln ('Changing to ..');
    LFNChDir ('..');
    if DOS7Error<>0 then
      Writeln ('    --- Error: Could not change directory ---');
    LFNGetDir (p2, 0);
    GetLongPathName (p3, p2, NO_SUBST_EXPAND);
    Writeln ('Current Directory : ', p3)
  end;
  Write ('Remove Directory (<ENTER> to skip) : ');
  Readln (s);
  StrPCopy (p1, s);
  if s<>'' then
  begin
    LFNRmDir (p1);
    if DOS7Error<>0 then
      Writeln ('    --- Error: Could not remove directory ---')
  end;
  Writeln;
  TextColor (LightCyan);
  Writeln ('Press any key to continue...');
  ReadKey;

  ClrScr;
  TextColor (Yellow);
  Writeln ('File operations and info:');
  LFNChDir (OldDir);
  Writeln;
  TextColor (LightGray);
  Write ('Does the test file exist ? ');
  f:=LFNOpenFile ('Test file for Example 1.txt', 0, OPEN_RDONLY, 0);
  if DOS7Error<>0 then { no }
  begin
    Writeln ('No.');
    Write ('Creating the test file ... ');
    f:=LFNCreateFile ('Test file for Example 1.txt', FA_ARC, OPEN_WRONLY, 0);
    if DOS7Error<>0 then
      Writeln (' * Error *')
    else
    begin
      Writeln ('Done.');
      Write ('Writing something in the file ... ');
      s:='Line 1'#13#10'Line 2'#13#10'Line 3';
      LFNBlockWrite (f, s[1], Length (s));
      if DOS7Error<>0 then
        Writeln (' * Error * ')
      else
        Writeln ('Done.');
      Write ('Closing the file ... ');
      LFNCloseFile (f);
      if DOS7Error<>0 then
        Writeln (' * Error * ')
      else
        Writeln ('Done.');
    end;
    Write ('Opening file for Read ... ');
    f:=LFNOpenFile ('Test file for Example 1.txt', 0, OPEN_RDONLY, 0);
    if DOS7Error=0 then
      Writeln ('Done.')
  end
  else
    Writeln ('Yes.');
  if DOS7Error<>0 then
  begin
    Writeln ('* Error *');
    FreeMem (p1, MAX_PATH);
    FreeMem (p2, MAX_PATH);
    FreeMem (p3, MAX_PATH);
    FreeMem (VI.FSName, MAX_PATH);
    FreeMem (SwapInfo.FileName, MAX_PATH);
    FreeMem (Data.Name, MAX_PATH);
    FreeMem (Data.ShortName, MAX_PATH);
    Halt
  end;
  Write ('Reading file ... ');
  rd:=LFNBlockRead (f, buf[1], 100); { rd = bytes read }
  buf[0]:=chr (rd);
  if DOS7Error<>0 then
    Writeln (' * Error * ')
  else
    Writeln ('Done.');
  Writeln ('The test file contains the following text:');
  TextColor (LightRed);
  Writeln (buf);
  TextColor (LightGray);
  Write ('Closing file ... ');
  LFNCloseFile (f);
  if DOS7Error<>0 then
    Writeln (' * Error * ')
  else
    Writeln ('Done.');
  Write ('Delete test file ? ');
  Readln (c);
  if (c='Y') or (c='y') then
    LFNErase ('Test file for Example 1.txt', FA_NORMAL, FA_ANY, NO_WILDCARDS);
  Writeln;
  Writeln;
  TextColor (LightCyan);
  Writeln ('Press any key to exit.');

  ReadKey;
  FreeMem (p1, MAX_PATH);
  FreeMem (p2, MAX_PATH);
  FreeMem (p3, MAX_PATH);
  FreeMem (VI.FSName, MAX_PATH);
  FreeMem (SwapInfo.FileName, MAX_PATH);
  FreeMem (Data.Name, MAX_PATH);
  FreeMem (Data.ShortName, MAX_PATH);
end.