{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Elements/Linkage3.pas   [x] Protected mode

  Some ADT's use a special packaging for their elements, for example
  lists and trees. These ADT require links between their elements,
  these links are implemented in the packaging - the container
  class. This is a demonstration of tLinkage, the packaging of
  linked lists, that is, descendants of tList.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL, EFLIST, EFTEST;


var Start, Capture : pLinkage;
    StartMem : longint;


begin
     MemPush; { EFTEST }

     { Create a chain of two nodes: }
     New (Start, Initialize (NIL, { Attach before: }
       New (pLinkage, Initialize (NIL, NIL))));

     { Detach the successor node }
     Capture := pLinkage(Start^.Predecessor);
     Capture^.Detach;

     if not Capture^.IsAttached
        then WriteLn ('We have a non-attached node (1).');

     if not Start^.IsAttached
        then WriteLn ('We have a non-attached node (2).');

     { Attach it in the front }
     Start^.AttachBefore (Capture);

     if Start^.IsIntact
        then WriteLn ('Node is intact: links are all right.');

     Start^.First^.FreeAll; { This releases the entire chain }

     MemPop; { EFTEST }
end.