{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/List2.pas         [x] Protected mode

  Example of the doubly linked list ADT. This example demonstrates
  features such as capacity estimating and iterator walking.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFLIST, EFELEM, EFSTRING, EFTEST;


var List      : tList;
    Node      : pLinkage;
    iA, iB    : pNodeIterator;
    Data      : string[40];
    Index     : word;
    Memory    : longint;

begin
     Memory := MemAvail;

     with List do begin

          Initialize ( SizeOf(Data) );

          Randomize;

          { Generate a structure containing randomly generated data }
          for Index := 1 to 2000 do begin
              with CreateRandomString (Pred(SizeOf(Data)))^ do begin
                   Data := Pascal;
                   Free;
              end;
              Store (Data);
          end;

          { Type-cast tIterator to tNodeIterator (they are really
            tNodeIterator, so for tList, this is valid). }
          iA := pNodeIterator (CreateIterator);
          iB := pNodeIterator (CreateIterator);

          iA^.WalkTo (1); { iA is not at element no. 1 (no change) }
          iB^.WalkUsing (iA, 1998); { iB is now on element no. 1999. }

          { Capture the current iB node. }
          Node := iB^.Node;
          iA^.Free; iB^.Free; { Free iterators }

          WriteLn ('We have ', Elements, ' elements in our list.');
          WriteLn ('Potential capacity for ', Capacity, ' elements in our list (estimate).');
          Write ('We walked with iterators: ended up at node no. ');
          WriteLn (NodeIndex(Node)); { Find index for the node }

          if IsIntact
             then WriteLn ('Link integrity OK.');

          Intercept;
     end;

     if Memory <> MemAvail then WriteLn ('Error in structure disposal.');
     WriteLn  ('Testing completed.');
end.