{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/Olist1.pas        [x] Protected mode

  Example of tOrderList - the ordered list. An ordered list
  maintains its element in sorted order.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFLIST;

var Collection : tOrderedList;
    Text       : string;
    Index      : word;

begin
     with Collection do begin

          { Initialize a ordered list of text strings. }
          Initialize (SizeOf(Text));

          { Add something to the collection }
          Text := 'Kenneth ';   Store (Text);
          Text := 'Jenny   ';   Store (Text);
          Text := 'Jonathan';   Store (Text);
          Text := 'Clark   ';   Store (Text);
          Text := 'Eve     ';   Store (Text);
          Text := 'Adam    ';   Store (Text);
          Text := 'Lucas   ';   Store (Text);

          { Display the elements in the collection
            in the order they are stored. }

          for Index := 1 to Elements do begin

              Retrieve (Text, Index);
              WriteLn (Text);

          end;

          if IsSorted (AscendingOrder)
             then WriteLn ('Structure is SORTED.')
             else WriteLn ('Structure is NOT SORTED.');

          WriteLn;
          WriteLn ('Let us check how an ordered list behave:');

          { The following discussion is a bit advanced,
            unexperienced user may want to skip it. }

          { It can be dangerous to swap and update
            elements by their index values, since
            the ordered list might trigger a fatal
            error, or at least behave odd, if elements
            are not sorted. Let us try it: }

          Swap (1, Elements);

          if not IsSorted (AscendingOrder)
             then WriteLn ('We swap places of two nodes. The ordered list is no longer ordered!!');

          { This ordered list is no longer sorted. We should
            (i) sort it before using it again or (ii) intercept
            or clear it. }

          if not IsIntact
             then WriteLn ('The sorted list is no longer intact. It is damaged.');

          Sort (AscendingOrder);

          if IsIntact
             then WriteLn ('Now it is intact because we sorted it.');

          Intercept;

     end;
end.