{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Queues/Priority.pas     [x] Protected mode

  This is an example on an priority queue. A priority queue is
  an ADT that dequeues in priority order. tPriorityQueue descend
  from tCompositeADT and is an ordered ADT. By default, tPriorityQueue
  uses an ordered linked list for its internal organization.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFADT, EFDATA;


const NumberOfElements = 10;

type tPriority = record Key : word; Data : string; end;
var PriorityQueue : tPriorityQueue;
    Element       : tPriority;
    Index         : byte;


begin
     Randomize;

     WriteLn ('* Priority queue example');

     with PriorityQueue do begin

          Initialize (SizeOf(tPriority));
          InstallPlug (New (pBoundedKeyPlug, Initialize (NIL, 0, 3)));

          { Priority queue operations:

            Enqueue (Data) - add an element to the queue.
            Dequeue (Data) - retrieve element with highest priority.
            Skip (Data) - erase the last inserted element. }

          for Index := 1 to NumberOfElements do begin

              { Create an element and give it
                a key (priority number). Lowest
                priority = retrieved last). }
              Element.Key := Index;

              { The data field is not of importance
                for the insertion order: }
              Str (Index, Element.Data);
              Element.Data := '[' + Element.Data + ']';

              { Insert this element into the queue }
              Enqueue (Element);
          end;


          { When elements are retrieved from a priority queue, the biggest
            element is always the first to be retrieved.

            How to change the priority:

            (1) Use an existing tKeyPlug (see above for tBoundedKey) to
                specify where your priority key is stored inside the
                ADT - optionally create a tKeyPlug descendant class
                yourself.
            (2) Create a new tPriorityQueue descenant class and override
                the method Compare (A, B : pElement) : boolean;
            (3) Create a new element that knows its priority.

            We recommend alternative (1) in most cases, since it
            is very simple to use (see above). }

          WriteLn ('  Highest priority first!');
          Write ( '  ' );

          while not IsEmpty do begin

                Dequeue (Element);
                Write (Element.Key, ':', Element.Data, ' ');

          end;

          WriteLn;

          Intercept;
     end;
end.