{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Tables/Hashclst.pas     [x] Protected mode

  Hash table clustering test. This is a test of the algorithm
  efficiency. Randomly located elements indicate that the algorithm
  is efficient.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;


uses EFTABLE, EFTEST;

const CapacityOfElements = 200; { Maximum capacity }
      NumberOfElements   = CapacityOfElements div 2; { Number of elements to add }
      SizeOfElement      = 100;

var Table : pOpenHashTable; Index : word;


begin
     MemPush; { EFTEST }

     Randomize;
     Table := New (pDoubleHashTable, Initialize (CapacityOfElements, SizeOfElement));


     with Table^ do begin

          { Install a good hash function. }
          InstallPlug ( New (pTextHashPlug, Initialize(NIL)) );

          { Store some random elements in the
            hash table. }

          for Index := 1 to NumberOfElements do
              Put (CreateRandomElement (SizeOfElement));

          { Show used elements }
          for Index := 1 to Capacity do
              if IsUsed (Index) then Write ('[x] ') else Write ('[ ] ');

          if Elements <> NumberOfElements
             then WriteLn ('Not all elements could be inserted - duplicate elements generated.');

          { EFLIB provides a very efficient hash code algorithm
            for text strings. }

          for Index := 1 to Capacity do
              if IsUsed (Index) and not IsInside (fComposite^.Get(Index))
                 then WriteLn ('Errors in this hash table!!');

          Free;

     end;

     MemPop; { EFTEST }
end.