{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Math/Integer.pas                 [x] Protected mode

  This is an example on integer arithmetics and type-casting.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTREAM, EFMATH;


var N, M : tInteger;
    Z : pComplex;

begin

     N.Initialize (5);  { N = 5 }
     M.Initialize (12); { M = 12 }

     { The type-cast friendly mathematical interface
       is flexible when you require a mixture of different
       mathematical objects - and want them to be compatible. }

     { Some simple integer arithemics }
     N.Add (@M);
     N.Subtract (@M);
     N.Multiply (@M);
     N.Multiply (@N); { Square }

     WriteLn ( 'N = ', N.Value:0:0, ' and M = ', M.Value:0:0, '.' );

     { And now advanced type-casting with complex numbers. }
     Z := New (pComplex, Initialize (2, 2));

     with Z^ do begin

          Multiply (@N); { Complex arithetmics with integers! }
          Divide (@M);
          Write ( 'Z*N/M = ');
          StreamWrite (StdIO);
          WriteLn;

          Free; { pComplex }

     end;

     N.Intercept; M.Intercept;

end.