{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Location/Matrix3.pas             [x] Protected mode

  Matrix algebra demonstration: back-substitution of a square matrix
  that is triangulated.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTREAM, EFMATH;


var Matrix : tMatrix;

begin
     with Matrix do begin

          { Begin with a unitary matrix }
          InitializeUnitary (3);

          { Change some elements }
          SetElement (1, 2, 2);  SetElement (1, 3, 3);
          SetElement (2, 3, -2); { Still triangulated }

          StreamWrite (StdIO); { Display it on standard output }

          { Back-substitute and display again }
          BackSubstitute ( NIL ); { Throw away results }
          StreamWrite (StdIO);

          Intercept;

     end;
end.