{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Math/Newton.pas                  [x] Protected mode

  Newton-Raphsons method; the efficient and accurate method of
  solving an equation of the type f(x) = 0 given a starting value
  (close to the root).

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFMATH;


var Solver : tSolver;

function ExternalF (X : tBaseReal) : tBaseReal; far;
begin
     ExternalF := Power (X, 3) +  X  -  3;
end;

begin
     with Solver do begin

          { Initialize the solver }
          Initialize ( 1.0, { Start with x = 0 }
                       1e-10, { Stop when ten decimals accuracy is reached }
                       100000, { Stop after 100000 iterations (if not earlier) }
                       @ExternalF, { Use an external function f (x) }
                       NIL, { Use no other function g (x) }
                       NIL  { And no function h (x, y): only for Eulers method }
                     );

          if Newton
             then WriteLn ('f(x) = 0 when x = ', Result:0:10)
             else WriteLn ('No solution found.');

          Intercept;

     end;
end.