{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Compress.pas             [x] Protected mode

  How to use the compression filter to crunch files to smaller sizes.
  This compression filter uses a splay-tree based compression algorithm
  that crunches data to at least 50-85% of its original size.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFKERNEL, EFSTREAM, EFFILE, EFFILTER, EFSTRING;


const Buffer = 16000; { Buffer size: larger buffer increases
                       the performance (64K = maximum). }

var Stream, Filter : pStream;
    StreamFilename, FilterFilename : string;
    Decompress : boolean;

{ Syntax: [x] <file1> <file2>
  Compresses or decompresses the first file and stores the result
  in the second file. }

begin
     if ParamStr (1) = ''
        then begin
             WriteLn ('Syntax: Compress |x| <source> <target>');
             WriteLn ('  Compresses <source> and stores the compressed file in');
             WriteLn ('  <target>. Decompression is done if X is specified before');
             WriteLn ('  the filenames.');
             Halt (1);
             end;

     { Check if the X parameter was passed to the program (X = extract). }
     Decompress := (ParamStr(1) = 'X') or (ParamStr(1) = 'x');

     if Decompress then begin
        FilterFilename := ParamStr(2); { Read and decompress }
        StreamFilename := ParamStr(3); { Output resulut }
     end else begin
        StreamFilename := ParamStr(1); { Read data }
        FilterFilename := ParamStr(2); { Write and compress }
     end;

     { Initialize compress filter and streams }

     Stream := New ( pFile,
                     Initialize (StreamFilename, Buffer)      );
                                { Filename } { Buffer size }

     Filter := New ( pCompressFilter,
                     Initialize (New (pFile,
                     { Base stream }
                     Initialize (FilterFilename, Buffer)))    );
                                 { Filename } { Buffer size }


     { If construction succeeded, everything is alright,
       but if one of the instances are not assigned, we
       must abort. Out of memory? }


     if Assigned (Stream) and Assigned (Filter) then begin

        if Decompress then { Decompress }
           Filter^.CopyOut (Stream, High(Longint)) else
           Stream^.CopyOut (Filter, Stream^.Size); { Compress }

        Stream^.Free; Filter^.Free;
        { Dispose filter including base stream }

     end else WriteLn ('Out of memory?');
end.