{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Strings/Caseconv.pas             [x] Protected mode

  Case conversion performance test.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFBASIC, EFSTRING, EFTEST;

const Tests = 1000;

var PascalString : string;
    EFLIBString  : pString;
    Timer      : tTimer;
    Index      : word;


procedure PascalCase (var Data : string);
var Index : byte;
begin
     for Index := 1 to Length(Data) do
         Data[Index] := UpCase(Data[Index]);
end;

begin

     Timer.Initialize;

     WriteLn ('Case translation performance test:');
     WriteLn;

     EFLIBString  := CreateRandomString ( 255 );
     PascalString := EFLIBString^.Pascal;


     WriteLn ('EFLIB case translation is running (', Tests*255, ' characters).');
     WriteLn ('Using national translation tables.');
     Timer.Reset;

       for Index := 1 to Tests do
           EFLIBString^.UpperCase; { LowerCase also available }

     WriteLn ('':2, Timer.ElapsedMS:4:0, ' [ms]');


     WriteLn ('Pascal case translation is running (', Tests*255, ' characters).');
     Timer.Reset;

       for Index := 1 to Tests do
           PascalCase (PascalString);

     WriteLn ('':2, Timer.ElapsedMS:4:0, ' [ms]');

end.