{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Strings/Hello.pas                [x] Protected mode

  Demonstrates the basics of tStrings - the dynamic string solution
  delivered with EFLIB.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTRING, EFSTREAM;


var A, B : pString;

begin
     New ( A, Initialize ('Hello world!') );
     New ( B, Duplicate (A) );

     { Append the end of line tString to the end of A. }
     A^.Append ( Endl );
     A^.Append ( Endl );

     { Assign a new text to B and append some more text. }
     B^.AssignPascal ('Dynamic strings are fast and flexible.');
     B^.Append ( Endl );
     B^.AppendPascal ('You''ll enjoy them.');
     B^.Linefeed; { Same as Endl appending }
     B^.Linefeed;

     { Output A and B to the standard IO stream. }
     A^.StreamWrite ( StdIO );
     B^.StreamWrite ( StdIO );

     A^.Free;
     B^.Free;
end.