program GvLangResDecompiler;

{ This tool is designed to convert your extended Graphics Vision 2.09
  text resources (named GVSTR.REZ) into a GVS script, which is the
  source format for Graphics Vision Language resources.

  Compile this file with GV 2.09 only.

  Copr. 1995 Matthias Kppe
}

uses Objects, GvTexts;

var
  TextStream: PBufStream;
  gvs: Text;
  fromID, toID: Integer;
  i, j, E: Integer;
  s: string;

begin
  If ParamCount <> 5
  then begin
    WriteLn('gvldc REZ-file GVS-file lang-ID from-Index to-Index');
    WriteLn;
    WriteLn('Extracts strings from a GVSTR.REZ file and stores');
    WriteLn('them as GVS script files for GVLC.');
    WriteLn;
    WriteLn('Example:  gvldc gvstr.rez english.gvs 0 1 136');
    WriteLn('  Source file is gvstr.rez, destination file is english.gvs,');
    WriteLn('  language to be extracted is 0 (English), first index is 1,');
    WriteLn('  last index is 136.');
    Halt(1)
  end;
  TextStream := New(PBufStream, Init(ParamStr(1), stOpenRead, 4096));
  SetTexts(New(PStringList, Load(TextStream^)));
  Assign(gvs, ParamStr(2));
  Rewrite(gvs);
  Val(ParamStr(3), Language, E);
  Val(ParamStr(4), fromID, E);
  Val(ParamStr(5), toID, E);

  For i := fromID to toID do
  begin
    s := GetStr(i);
    If s <> ''
    then begin
      j := 1;
      while j <= Length(s) do
      begin
	If s[j] < #32
	then begin
	  Insert(
	    Chr(Ord(s[j]) div 64 + $30) +
	    Chr((Ord(s[j]) div 8) mod 8 + $30) +
	    Chr(Ord(s[j]) mod 8 + $30),
	    s, j + 1);
	  s[j] := '\';
	  Inc(j, 3);
	end;
	Inc(j)
      end;
      WriteLn(gvs, i:4, ':', s)
    end;
  end;
  Close(gvs);
  SetTexts(nil);
  Dispose(TextStream, Done);
end.
