program GVS2RC;

{ Copr. 1996 Matthias K"oppe
}

uses WinRes;

var
  gvs, rc: Text;
  s: string;
  i, j, num: Integer;

procedure Warn(w: string);
begin
  WriteLn('Warning: ', ParamStr(i), '(', num, '): ', w)
end;

begin
  If ParamCount < 2
  then begin
    WriteLn('gvs2rc RC-file GVS-file GVS-file GVS-file...');
    WriteLn;
    WriteLn('Compiles a collection of GVS script files and');
    WriteLn('creates a RC file.');
    WriteLn;
    WriteLn('Example:  gvs2rc english.rc english.gvs englishx.gvs');
    Halt(1)
  end;
  Assign(rc, ParamStr(1));
  Rewrite(rc);
  WriteLn(rc, '/* Graphics Vision Language Resource.');
  WriteLn(rc, '   This file has been created by gvs2rc. */');
  WriteLn(rc);
  WriteLn(rc, 'STRINGTABLE');
  WriteLn(rc, 'BEGIN');
  For i := 2 to ParamCount do
  begin
    Assign(GVS, ParamStr(i));
    Reset(GVS);
    Writeln(rc, '/* File ', ParamStr(i), ' */');
    num := 1;
    while not eof(GVS) do
    begin
      ReadLn(GVS, s); Inc(num);
      If s[1] <> '#'	{ Comment }
      then begin
	AnsiFrom437Str(@s);
	j := Pos(':', s);
	If j = 0
	then Warn('Wrong syntax.')
	else WriteLn(rc, #9, Copy(s, 1, j - 1), ', "', Copy(s, j+1, Length(s) - j), '"');
      end
    end;
    Close(GVS)
  end;
  WriteLn(rc, 'END');
  Close(rc)
end.
