{$F+}

(* This include file is where you will take actions you define when trapped
   keys such as ALT-keys, Function-keys, etc., are pressed.

   You will need to setup your procedures here which in turn may call other
   procedures within your code or you may do all you need to do right here.

   For example, if you wanted to trap for ALT-C being pressed on the local
   keyboard and then call the procedure CHAT:

   Your main block of code might look like this:

   BEGIN  {main}
      ASSIGN(Output,'') ;
      REWRITE(Output) ;
      SysopKey[1] := #0 + #46 ;   {define ALT-C as one of twenty keys }
                                  {to trap                            }
      SysopProc[1] := ALT_C ;     {define procedure as defined here   }
      SysopKey ;                  {setup for far call to this file    }
   END ;

   Now, whenever ALT-C is pressed, the following procedure will be called:

   PROCEDURE ALT_C ;
   BEGIN
      CHAT ;                      {call procedure CHAT which is located }
   END ;                          {within your program's code           }

   *)

(*
   The following procedures are called when up/down arrows are pressed
   provided they are defined using SysopKey[] and SysopProc[] within
   the main program code
*)

PROCEDURE UP_ARROW ;
BEGIN
   {up-arrow key defined as #0 + #72 }
   RaiseTime ;
END ;

PROCEDURE DOWN_ARROW ;
BEGIN
   {down-arrow key defined as #0 + #80 }
   LowerTime ;
END ;

(* PROCEDURE CTRL_R ;
   BEGIN
      ReDraw ;
   END ;
*)

(* PROCEDURE ALT_C ;
   BEGIN
      Chat ;
   END ;
*)
{$F-}
