{ CVTTST.PAS -- Test CvtLib unit

  Title   : CVTTST
  Version : 5.0
  Date    : Nov 09,1996
  Language: Borland Pascal 7.0 (all targets)
  Author  : J.R. Ferguson
  Usage   : Test program
}

program CvtTst;

uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  CvtLib, DefLib, ConLib, ChrLib;

const
  HexDigit : array[0..15] of char = '0123456789ABCDEF';

var
  s     : StpTyp;
  n,g,l : integer;
  m     : longint;

{ -- General routies -- }

procedure PutHexByt(b: byte);
begin
  write(HexDigit[b shr 4]);
  write(HexDigit[b and $0F]);
end;

procedure PutHexWrd(w: word);
begin
  PutHexByt(w shr 8);
  PutHexByt(w and $FF);
  write(' ');
end;

procedure PutHexLWrd(lw: longint);
begin
  PutHexWrd(lw shr 16);
  PutHexWrd(lw and $FFFF);
end;

procedure WrLn2; begin writeln; writeln; end;

procedure RdStp;
begin    write('string   : '); readln(s) end;

procedure RdInt;
begin
  repeat write('integer  : '); {$I-} readln(n) {$I+} until IOresult=0
end;

procedure RdLInt;
begin
  repeat write('longint  : '); {$I-} readln(m) {$I+} until IOresult=0
end;

procedure RdBase;
begin
  repeat write('base     : '); {$I-} readln(g) {$I+} until IOresult=0
end;

procedure RdLen;
begin
  repeat write('length   : '); {$I-} readln(l) {$I+} until IOresult=0
end;

procedure WrStp;
begin writeln('"',s,'"') end;

procedure WrInt;
begin write('n = '); PutHexWrd(word(n)); writeln('h,  ',n,' d'); end;

procedure WrLint;
begin write('n = '); PutHexLWrd(m); writeln('h,  ',m,' d'); end;


{ -- Testroutines -- }

procedure TstAtoI;
begin wrln2; RdStp; n:= AtoI(s); WrInt end;

procedure TstAtoIB;
begin wrln2; RdStp; RdBase; n:= AtoIB(s,g); WrInt end;

procedure TstItoA;
begin wrln2; RdInt; ItoA(n,s); WrStp end;

procedure TstItoAB;
begin wrln2; RdInt; RdBase; ItoAB(n,s,g); WrStp end;

procedure TstItoABL;
begin wrln2; RdInt; RdBase; RdLen; ItoABL(n,s,g,l); WrStp end;

procedure TstItoABLS;
begin wrln2; RdInt; RdBase; RdLen; ItoABLS(n,s,g,l); WrStp end;

procedure TstAtoL;
begin wrln2; RdStp; m:= AtoL(s); WrLint end;

procedure TstAtoLB;
begin wrln2; RdStp; RdBase; m:= AtoLB(s,g); WrLInt end;

procedure TstLtoA;
begin wrln2; RdLInt; LtoA(m,s); WrStp end;

procedure TstLtoAB;
begin wrln2; RdLInt; RdBase; LtoAB(m,s,g); WrStp end;

procedure TstLtoABL;
begin wrln2; RdLInt; RdBase; RdLen; LtoABL(m,s,g,l); WrStp end;

procedure TstLtoABLS;
begin wrln2; RdLInt; RdBase; RdLen; LtoABLS(m,s,g,l); WrStp end;

{ -- Menu -- }

{$I CVTTSTM.PAS}

begin
  cvttstm;
{$IFDEF WINDOWS}
  DoneWinCrt;
{ELSE}
  ClrScr;
{$ENDIF}
end.
