{ NIOTST.PAS : Test NIOLIB Unit

  Title   : NIOTST
  Version : 4.0
  Date    : Nov 11,1996
  Language: Borland Turbo Pascal 4.0 through 7.0 (all targets)
  Author  : J.R. Ferguson
  Usage   : Test program
}

program NioTst;

uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  NioLib, DmpLib, ConLib;


var
  n     : integer;
  w,g,l : integer;
  b     : byte;

procedure rdbase; begin write('Enter base   : '); readln(g) end;
procedure rdlen ; begin write('Enter length : '); readln(l) end;
procedure rdwrd ; begin write('Enter integer: '); readln(w) end;
procedure rdbyt ; begin write('Enter integer: '); readln(n); b:= byte(n) end;
procedure xrdnum; begin write('n : ') end;
procedure xwrnum; begin write('n = ') end;
procedure wrwrd ; begin xwrnum; hxwout(word(w)); writeln('h') end;
procedure wrbyt ; begin xwrnum; hxbout(b); writeln('h') end;

procedure TSTowuns ; begin rdbase; rdlen; rdwrd; xwrnum; owuns(w,g,l) end;
procedure TSTowubin; begin rdwrd; xwrnum; owubin(w) end;
procedure TSTowuoct; begin rdwrd; xwrnum; owuoct(w) end;
procedure TSTowuhex; begin rdwrd; xwrnum; owuhex(w) end;
procedure TSTowudec; begin rdwrd; xwrnum; owudec(w) end;
procedure TSTowsdec; begin rdwrd; xwrnum; owsdec(w) end;

procedure TSTobuns ; begin rdbase; rdlen; rdbyt; xwrnum; obuns(b,g,l) end;
procedure TSTobubin; begin rdbyt; xwrnum; obubin(b) end;
procedure TSTobuoct; begin rdbyt; xwrnum; obuoct(b) end;
procedure TSTobuhex; begin rdbyt; xwrnum; obuhex(b) end;
procedure TSTobudec; begin rdbyt; xwrnum; obudec(b) end;
procedure TSTobsdec; begin rdbyt; xwrnum; obsdec(b) end;

procedure TSTiwuns ; begin rdbase; xrdnum; w:= iwuns(g); wrwrd end;
procedure TSTiwubin; begin xrdnum; w:= iwubin; wrwrd end;
procedure TSTiwuoct; begin xrdnum; w:= iwuoct; wrwrd end;
procedure TSTiwuhex; begin xrdnum; w:= iwuhex; wrwrd end;
procedure TSTiwudec; begin xrdnum; w:= iwudec; wrwrd end;
procedure TSTiwsdec; begin xrdnum; w:= iwsdec; wrwrd end;

procedure TSTibuns ; begin rdbase; xrdnum; b:= ibuns(g); wrbyt end;
procedure TSTibubin; begin xrdnum; b:= ibubin; wrbyt end;
procedure TSTibuoct; begin xrdnum; b:= ibuoct; wrbyt end;
procedure TSTibuhex; begin xrdnum; b:= ibuhex; wrbyt end;
procedure TSTibudec; begin xrdnum; b:= ibudec; wrbyt end;
procedure TSTibsdec; begin xrdnum; b:= ibsdec; wrbyt end;


procedure DoTest;
  var option : char;
  begin
    repeat
      ClrScr;
      writeln('NIOTST -- TEST NIOLIB');
      writeln;
      writeln('A = owuns    G = obuns    M = iwuns    S = ibuns ');
      writeln('B = owubin   H = obubin   N = iwubin   T = ibubin');
      writeln('C = owuoct   I = obuoct   O = iwuoct   U = ibuoct');
      writeln('D = owuhex   J = obuhex   P = iwuhex   V = ibuhex');
      writeln('E = owudec   K = obudec   Q = iwudec   W = ibudec');
      writeln('F = owsdec   L = obsdec   R = iwsdec   X = ibsdec');
      writeln;
      writeln('Z = exit');
      writeln;
      write('Option : ');
      repeat option:= UppKey until option in ['A'..'X','Z'];
      writeln(option); writeln;

      case option of
        'A': TSTowuns ; 'G': TSTobuns ; 'M': TSTiwuns ; 'S': TSTibuns ;
        'B': TSTowubin; 'H': TSTobubin; 'N': TSTiwubin; 'T': TSTibubin;
        'C': TSTowuoct; 'I': TSTobuoct; 'O': TSTiwuoct; 'U': TSTibuoct;
        'D': TSTowuhex; 'J': TSTobuhex; 'P': TSTiwuhex; 'V': TSTibuhex;
        'E': TSTowudec; 'K': TSTobudec; 'Q': TSTiwudec; 'W': TSTibudec;
        'F': TSTowsdec; 'L': TSTobsdec; 'R': TSTiwsdec; 'X': TSTibsdec;
        'Z': {nothing}
      end;

      if option<>'Z' then begin writeln; WaitCR end;
    until option = 'Z'
  end;

begin
  DoTest;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ENDIF}
end.
