{ FDUMP.PAS : Dump file to standard output

  title   : FDUMP
  version : 1.0
  date    : 24 sep 1990
  author  : J R Ferguson
  language: Turbo Pascal v4.0+
  usage   : refer procedure Help
  remarks :
}

{$V-}
{$R+}

program FDUMP;


uses DefLib, ArgLib, StpLib, ChrLib, DmpLib;


const
(*
  { Option defaults: }
  DFL_ZZ_   = false;
  {...}
*)

  MAXFNAME  = 79;
  IOBUFSIZ  = 4096; { must be a multiple of 16 }

  { Error codes and messages: }
  ERROK     = 0;
  ERRARG    = 1;
  ERRINP    = 2;

  ERRMSG    : array[ERRINP..ERRINP] of StpTyp =
 ('File not found : '
 );

type
  IOBufInd  = 0..IOBUFSIZ;
  IOBufTyp  = array[1..IOBUFSIZ] of char;
  IOBufPtr  = ^IOBufTyp;

var
  InpFname  : StpTyp;
  InpFvar   : file;
  InpBuf    : IOBufPtr;
  InpCnt    : IOBufInd;

  ErrCod    : integer;

(*
  Opt_zz_   : boolean;
  {...}
*)

  LineCnt   : integer;
  ByteCnt   : word;
  BufInd    : word;

{
--- Command line parsing routines ---
}


procedure Help;
begin
  writeln('FDUMP v1.0');
  write  ('usage  : FDUMP filespec [>dest]');
(*
  writeln(' [/option[...] [...] ]');
  writeln('options: Z  ');
*)
end;


(*
procedure ReadOpt(arg: StpTyp);
begin
  StpDel(arg,1,1);
  while (ErrCod=ERROK) and not StpEmpty(arg) do case ToUpper(StpcGet(arg)) of
    'Z' : Opt_zz_ := not DFL_ZZ_;
    {...}
    else ErrCod:= ERRARG;
  end;
end;
*)


procedure ReadArgs;
var i,f : ArgInd;
    arg : StpTyp;
begin
  StpCreate(InpFname);
  GetArgs;
  i:= 0; f:= 0;
  while (i < ArgC) and (ErrCod = ERROK) do begin
    Inc(i); StpCpy(arg,ArgV[i]); StpUpp(arg);
(*
    case StpcRet(arg,1) of
      '/' : ReadOpt(arg);
      else
*)
            begin
	      if f=0 then begin StpNCpy(InpFname,arg,MAXFNAME); f:= 1; end
	      else ErrCod:= ERRARG;
	    end;
(*
    end;
*)
  end;
  if f<>1 then ErrCod:= ERRARG;
end;


{
--- I/O routines ---
}


procedure OpenInp;
begin
  Assign(InpFvar,InpFname);
  new(InpBuf); {$I-} reset(InpFvar,1); {$I+}
  if IOresult <> 0 then ErrCod:= ERRINP;
end;


function GetBuf: boolean;
begin
  if eof(InpFvar) then GetBuf:= false
  else begin
    BlockRead(InpFvar,InpBuf^,IOBUFSIZ,InpCnt);
    BufInd:= 0;
    GetBuf:= InpCnt>0;
  end;
end;


procedure PutLine;
begin
  HxWout(ByteCnt); write(': ');
  DmpHex( Seg(InpBuf^[BufInd]), Ofs(InpBuf^[BufInd]) ); write(' ');
  DmpAsc( Seg(InpBuf^[BufInd]), Ofs(InpBuf^[BufInd]) ); writeln;
  Inc(ByteCnt,16); Inc(BufInd,16);
  Inc(LineCnt); if LineCnt mod 8 = 0 then writeln;
end;


procedure PutBuf;
begin
  BufInd:= 1;
  while BufInd <= InpCnt do PutLine;
end;


{
--- Main line ---
}


procedure MainInit;
begin
(*
  Opt_zz_:= DFL_ZZ_;  {...}
*)
  ErrCod:= ERROK;
  ReadArgs;
  if ErrCod = ERROK then OpenInp;
  ByteCnt:= 0; LineCnt:= 0;
end;


procedure MainExit;
begin
  if ErrCod = ERROK then dispose(InpBuf)
  else begin
    if ErrCod=ERRARG then Help
    else begin
      write(ERRMSG[ErrCod]);
      if      ErrCod = ERRINP then write(InpFname);
      writeln;
    end;
  end;
end;


begin { Main program }
  MainInit;
  if ErrCod = ERROK then
    while GetBuf do PutBuf;
  MainExit;
end.
