{ DMPLIB.PAS : Hex/ACII dump routine library

  Title   : DMPLIB
  Version : 4.0
  Language: Turbo Pascal v4.0 through 7.0 (all targets)
  date    : Nov 10,1996
  Author  : J.R. Ferguson
  usage   : Unit

  Remarks : All output is written to the standard output device.
}

UNIT DmpLib;

INTERFACE

procedure BinOut(b:byte);
{ Binary Out: write 8-bit byte binary. }

procedure HxdOut(b: byte);
{ Hex Digit Out: write b mod 16 as a hexadecimal digit ('0'..'F').
  Normally the value of b should be in the range 0..15. }

procedure HxbOut(b: byte);
{ Hex Byte Out: write byte b in 2 hexadecimal digits ('00'..'FF'). }

procedure HxWout(w: word);
{ Hex Word Out: write word w in 4 hexadecimal digits ('0000'..'FFFF'). }

procedure AscOut(b: byte);
{ ASCII Out: If the value of b is in the range 32..127 the character with
  ASCII code b is written. If the value of b is outside of that range, a
  dot character is written. }

procedure DmpHex(segment,offset: word);
{ Dump Hex: write a hex dump of 16 bytes of internal memory,
  starting at the specified segment and offset. }

procedure DmpAsc(segment,offset: word);
{ Dump ASCII: write an ASCII dump of 16 bytes of internal memory,
  starting at the specified segment and offset. }

procedure Dump(segment,offset: word; n: integer);
{ Write a combined hexadecimal and ASCII dump of n bytes of internal
  memory in lines of 16 bytes each, starting at the specified segment
  and offset. No partial lines are written; if needed the value of n
  will be rounded up to the next multiple of 16. }

procedure DumpVar(var MemVar; n:integer);
{ Like Dump, starting at the address of variable MemVar. }

IMPLEMENTATION

procedure BinOut(b:byte);
var m: byte;
begin
  m:=128; while m>0 do begin write(chr(48+(b and m) div m)); m:=m div 2 end
end;

procedure HxdOut(b: byte);
begin b:=b mod 16; if b>9 then b:=b+7; write(chr(48+b)) end;

procedure HxbOut(b: byte);
begin HxdOut(b div 16); HxdOut(b mod 16) end;

procedure HxwOut(w: word);
begin HxbOut(hi(w)); HxbOut(lo(w)) end;

procedure AscOut(b: byte);
var c: char absolute b;
begin if c in [' '..'~'] then write(c) else write('.') end;

procedure DmpHex(segment,offset: word);
var i: integer;
begin for i:=0 to 15 do begin
  HxbOut(Mem[segment:offset+i]); write(' '); if i=7 then write(' ')
end end;

procedure DmpAsc(segment,offset: word);
var i: integer;
begin for i:=0 to 15 do begin
  AscOut(Mem[segment:offset+i]); if i=7 then write(' ')
end end;

procedure Dump(segment,offset: word; n: integer);
begin
  while n>0 do begin
    HxwOut(segment); write(':'); HxwOut(offset); write('  ');
    DmpHex(segment,offset); write(' '); DmpAsc(segment,offset); writeln;
    n:=n-16; offset:=offset+16
  end
end;

procedure DumpVar(var MemVar; n:integer);
begin
  Dump(Seg(MemVar), Ofs(MemVar), n)
end;

END.
