{
        Object-Oriented Archive-viewer, version 3
        
        This Object-Oriented Archive-viewer (OOAV) is copyright (c) by
        Edwin Groothuis, MavEtJu software. You are free to use it
        if you agree with these three rules:

        1. You tell me you're using this unit.

        2. You give me proper credit in the documentation. (Like:
           "This program uses the Object-Oriented Archive-viewer
            (c) Edwin Groothuis, MavEtJu software".

        3. If you make Archive-objects for other archive-types, don't
           hesitate to inform me so I can add them to the unit and
           redistribute it!

        That's all!

        How to use this unit:
        
        (see also the file ArchTest.pas)

        - Declare a variable Arch of the       var Arch:TArchive;
          type TArchive                        begin
        - Call it's constructor                  Arch.Init;
        - Tell the unit which file you           if not Arch.Name('TEST.ZIP')
          want to view. This function            then begin
          returns a boolean. If this               writeln('TEST.ZIP is not
          boolean is false, then the                        a valid archive');
          file couldn't be identified              exit;
          as a valid archive.                    end;
        - Just like the dos-functions            Arch.FindFirst(sr);
          FindFirst and FindNext, you            while sr.Name<>'' do
          can search through the archive.        begin
          The parameter you give with it           writeln(sr.Name);
          is one of the SearchRec-type.            Arch.FindNext(sr);
          If there are no more files in          end;
          this archive, sr.Name will be
          empty. Valid fields are
          sr.Name, sr.Size and sr.Time
        - Call the destructor                    Arch.Done;
                                               end;

        - You can call the function
          IdentifyArchive() to see what
          kind of archive you're dealing
          with.

        What if you want to add more archive-types
        
        - Add the unit name in the second Uses-statement.
        - Find out how to identify it and add that algoritm
          to the IdentifyArchive()-function. Please choose a
          unique and no-nonsens character to return.
        - Add it to the IdentifyArchive()-case in TArchive.Name.
        - Create a FindFirst-method and FindNext-method for this
          object.
        - That's it! Simple, isn't it? (If it isn't, please see the
          files ZipView, ArjView and others for examples ;-)

        Author:
        
        Edwin Groothuis          email:
        Johann Strausslaan 1     edwing@stack.urc.tue.nl (valid until 10-94)
        5583ZA Aalst-Waalre      Edwin_Groothuis@p1.f205.n284.z2.gds.nl
        The Netherlands          2:284/205.1@fidonet
                                 115:3145/102.1@pascal-net


}

unit      OOAV;

interface

uses      Dos;

{
  General Archive, which is the father of all the specific archives. See
  OOAVZip, OOAVArj and others for examples.
}
type      PGeneralArchive=^TGeneralArchive;
          TGeneralArchive=object
                            _FArchive:file;

                            constructor Init;
                            destructor Done;virtual;

                            procedure FindFirst(var sr:SearchRec);virtual;
                            procedure FindNext(var sr:SearchRec);virtual;
                          end;

{
  TArchive is the object you're working with. See the documentation at the
  begin of this file for more information
}
type      PArchive=^TArchive;
          TArchive=object
                     constructor Init;
                     destructor Done;

                     function  Name(const n:string):boolean;

                     procedure FindFirst(var sr:SearchRec);
                     procedure FindNext(var sr:SearchRec);

                   private
                     _Name:string;
                     _Archive:PGeneralArchive;
                   end;


function  IdentifyArchive(const Name:string):char;

implementation

uses      Objects,Strings,
          OOAVZip,OOAVArj,OOAVLzh,OOAVArc,OOAVZoo;


function  IdentifyArchive(const Name:string):char;
{
  returns:
    '?': unknown archive
    'A': Arj-archive;
    'Z': Zip-archive
    'L': Lzh-archive
    'C': Arc-archive
    'O': Zoo-archive
}
var       f:file;
          a:array[0..10] of char;
          bc:word;
          s:string;
          OldFileMode:byte;
begin
  if Name='' then
  begin
    IdentifyArchive:='?';
    exit;
  end;

  OldFileMode:=FileMode;
  FileMode:=0;
  assign(f,Name);
  {$I-}reset(f,1);{$I+}
  FileMode:=OldFileMode;
  if IOresult<>0 then
  begin
    IdentifyArchive:='?';
    exit;
  end;

  blockread(f,a,sizeof(a),bc);
  close(f);
  if bc=0 then
  begin
    IdentifyArchive:='?';
    exit;
  end;

  if (a[0]=#$60) and (a[1]=#$EA) then
  begin
    IdentifyArchive:='A';  { ARJ }
    exit;
  end;

  if (a[0]='P') and (a[1]='K') then
  begin
    IdentifyArchive:='Z';  { ZIP }
    exit;
  end;

  if a[0]=#$1A then
  begin
    IdentifyArchive:='C';  { ARC }
    exit;
  end;

  if (a[0]='Z') and (a[1]='O') and (a[2]='O') then
  begin
    IdentifyArchive:='O';  { ZOO }
    exit;
  end;

  s:=Name;
  for bc:=1 to length(s) do
    s[bc]:=upcase(s[bc]);
  if copy(s,pos('.',s),4)='.LZH' then
  begin
    IdentifyArchive:='L';  { LZH }
    exit;
  end;

  IdentifyArchive:='?';
end;


constructor TGeneralArchive.Init;
begin
  Abstract;
end;


destructor TGeneralArchive.Done;
begin
end;


procedure TGeneralArchive.FindFirst(var sr:SearchRec);
begin
  Abstract;
end;


procedure TGeneralArchive.FindNext(var sr:SearchRec);
begin
  Abstract;
end;


constructor TArchive.Init;
begin
  _Name:='';
  _Archive:=nil;
end;


destructor TArchive.Done;
begin
  if _Archive<>nil then
  begin
    close(_Archive^._FArchive);
    Dispose(_Archive,Done);
  end;
end;


function  TArchive.Name(const n:string):boolean;
var       sr:SearchRec;
          OldFileMode:byte;
begin
  if _Archive<>nil then
  begin
    close(_Archive^._FArchive);
    Dispose(_Archive,Done);
    _Archive:=nil;
  end;

  Name:=false;
  _Name:=n;
  Dos.FindFirst(_Name,anyfile,sr);
  if DosError<>0 then
    exit;

  case IdentifyArchive(_Name) of
    '?': exit;
    'A': _Archive:=New(PArjArchive,Init);
    'Z': _Archive:=New(PZipArchive,Init);
    'L': _Archive:=New(PLzhArchive,Init);
    'C': _Archive:=New(PArcArchive,Init);
    'O': _Archive:=New(PZooArchive,Init);
  end;

  OldFileMode:=FileMode;
  FileMode:=0;
  Assign(_Archive^._FArchive,n);
  {$I-}reset(_Archive^._FArchive,1);{$I+}
  FileMode:=OldFileMode;
  if IOresult<>0 then
  begin
    Dispose(_Archive);
    exit;
  end;

  Name:=true;
end;


procedure TArchive.FindFirst(var sr:SearchRec);
begin
  FillChar(sr,sizeof(sr),0);
  if _Archive=nil then
    exit;
  _Archive^.FindFirst(sr);
end;

procedure TArchive.FindNext(var sr:SearchRec);
begin
  FillChar(sr,sizeof(sr),0);
  if _Archive=nil then
    exit;
  _Archive^.FindNext(sr);
end;

end.
