{.define collections}  { Define this to include collections code }

program test;

{ Test program for Openfiles unit.  Should be compilable in TP/BP 6+, TPW 1.5+ }

uses
{ All these conditional directives are to get this to compile in as many
  TP versions as possible.  You won't need these in your programs. }

{$ifdef windows}
  {$ifdef ver15}
  {$define collections}       { Windows users should have collections }
  wincrt,wobjects,openfiles;
  {$else}
  wincrt,objects,openfiles;
  {$endif}
{$else}
  {$ifdef collections}
  objects,
  {$endif}
  openfiles;
{$endif}

{ This routine uses the callback function "for_each_open_file".  It's the
  only way to get the file open mode. }

procedure doit(prefix:string);
  {$F+}  { Use "far;" modifier in TP 6+ }
  procedure printone(f:string;pspseg,openmode:word);
  begin
    writeln(prefix,f:12,' owner ',pspseg:5,' mode ',openmode);
  end;
  {$F-}
begin
  for_each_open_file(@printone);
end;

{$ifdef collections}

{ This routine builds the collection of strings and prints it }

procedure doit2(prefix:string);
var
  c:Pcollection;

  { Print each filename }
  {$F+}
  procedure printone(f:PString);
  begin
    writeln(prefix,f^);
  end;

  { Release each string }
  procedure disposeone(f:PString);
  begin
    DisposeStr(f);
  end;
  {$F-}
begin
  c:=get_open_files;
  if c <> nil then
  begin
    c^.foreach(@printone);

    { This shows the proper way to dispose of the collection }

    c^.foreach(@disposeone);
    c^.deleteall;
    dispose(c,done);
  end;
end;
{$else}
procedure doit2(prefix:string);
begin
  writeln('Need to use Collections conditional compilation directive to');
  writeln('test get_open_files.');
end;
{$endif}

var
  f:file;
  i : longint;
begin
  assign(f,'test.pas');
  reset(f);
  allfiles := true;
  doit('Open by some process:  ');
  writeln;
  allfiles := false;
  doit2('Open by us:  ');
  writeln;
  { At the end, the exitproc will print one more list (in DOS). }
end.
