(*****************************************************************************

  Check
    Version 1.0

  Purpose:
    This unit holds two simple routines designed to find and flag memory
    leaks.

  Features:
    This unit is intended only as a debugging unit.
    This unit displays the amount of memory that it finds missing.
    This unit is very helpful for finding code that loses clusters
    of memory.

  Limitations:
    The placement of the two routines in the code is critical to it's
    accuracy.

  CopyRight 1990, All rights reserved.
    By Paul Renaud

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2.

*****************************************************************************)

Unit Check;

  Interface

(***********************************************************

  Procedure: Mark memory.
    This is the first procedure.  It takes account of the
    amount of memory the program has to begin with.

***********************************************************)

    Procedure Mark_Memory;

(***********************************************************

  Procedure: Memory gone.
    This is the second procedure.  It is called after the
    first, and should be called when all the memory
    allocated after the first has been deallocated.
    In theory, there should not be any difference between
    the amount of memory before and the amount after.  If
    there is a difference, this procedure flags it out
    and halts the program.

***********************************************************)

    Procedure Memory_Gone;

{----------------------------------------------------------------------------}

  Implementation

    Var
     { This variable holds the amount of memory found by mark memory. }
      Memory: LongInt;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Mark memory.
    As previously defined.

*************************************************)

    Procedure Mark_Memory;
      Begin
        Memory := MemAvail;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Check memory.
    This function returns the difference in the
    amount of memory there was when Mark_Memory
    was called and the amount of memory there was
    when Memory_Gone was called.

*************************************************)

    Function Check_Memory: LongInt;
      Begin
        Check_Memory := ( Memory - MemAvail );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Memory gone.
    As previously defined.

*************************************************)

    Procedure Memory_Gone;
      Begin
        If ( Check_Memory <> 0 )
          then
            Begin
              WriteLn( 'Memory leakage in the program.  Missing ', Check_Memory, ' bytes of memory.' );
              Halt;
            End;
      End;

{----------------------------------------------------------------------------}

  End.

