(*****************************************************************************

  Program:  Multiple window demonstration.

  Purpose:
    This program demonstrates the abilities of the multiple unit.

  Features:
    This program demonstrates how easy it is to use the multiple window unit.
    This program opens up several windows and displays their abilities.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0

  Systems:
    MS-DOS, MDOS

*****************************************************************************)

Program Multiple_Window_Demonstrator( Input, Output );

  Uses
    CRT,
    Multiple;

  Var
    Top,
    Left,
    Right,
    Bottom,
    Count,
    Window_1,
    Window_2,
    Window_3,
    Window_4,
    Window_5,
    Direction: Byte;
    Okay: Boolean;

  Begin
    WriteLn( 'Multiple window demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstates a few of the abilities of the multiple unit.' );
    WriteLn( 'First several windows are going to open up on the screen and seem to update' );
    WriteLn( 'themselves independently.  Then after you press any key, you will be given' );
    WriteLn( 'the opportunity to browse through three of the windows.  To escape from a' );
    WriteLn( 'window, merely press Enter or Escape.' );
    WriteLn;
    WriteLn( 'Please press [enter] to start.' );
    ReadLn;

    DirectVideo := True;

    For Count := 1 to 117 do
      Write( ' Default window. ' );

    Window_1 := Create_Window( Frame_8, Window_Up_Left, 10, 9, 70, 24, Red_Character + White_Background, 0, 0, Visible );

    Window_2 := Create_Window( Frame_3, Window_Down, 8, 6, 45, 21, Yellow_Character + Blue_Background, 0, 0, Visible );

    Window_3 := Create_Window( Frame_1, Window_Right, 30, 8, 50, 18, Black_Character + Green_Background, 11, 21, Invisible );

    Direction := 1;
    Left := 25;
    Top := 19;
    Right := 35;
    Bottom := 23;
    Window_4 := Create_Window( Frame_7, Window_Vertical, Left, Top, Right, Bottom, Blue_Character + Red_Background, 20, 20,
                               Visible );
    Change_Window_Visibility( Window_3, Visible );

    Repeat
      Switch_Active_Window( Window_1 );
      Write( 'Hello out there! ' );
      Switch_Active_Window( Window_2 );
      Write( 'Another window! ' );
      Switch_Active_Window( Window_3 );
      Write( 'Medium-window ' );
      Switch_Active_Window( Window_4 );
      Write( 'Small-window ' );
      Case Direction of
        1: If ( Right < 61 )
             then
               Begin
                 Inc( Left );
                 Inc( Right );
                 Okay := Move_Window_Right( Window_4 );
               End
             else
               Direction := 2;
        2: If ( Top > 3 )
             then
               Begin
                 Dec( Top );
                 Dec( Bottom );
                 Okay := Move_Window_Up( Window_4 );
               End
             else
               Direction := 3;
        3: If ( Left > 19 )
             then
               Begin
                 Dec( Left );
                 Dec( Right );
                 Okay := Move_Window_Left( Window_4 );
               End
             else
               Direction := 4;
        4: If ( Bottom < 23 )
             then
               Begin
                 Inc( Top );
                 Inc( Bottom );
                 Okay := Move_Window_Down( Window_4 );
               End
             else
               Direction := 1;
      End; {Case }
    Until KeyPressed;

    Window_5 := Create_Window( Frame_1, Window_Explode, 2, 2, 20, 20, Green_Character + Yellow_Background, 25, 80, Visible );
    WriteLn( 'This is a test of the browse procedure created with multiple' );
    WriteLn;
    WriteLn( '  How easy it is to use the multiple window unit.' );
    WriteLn;
    WriteLn( '  Switching between windows is a snap with Switch_Active_Window!' );
    WriteLn;
    WriteLn( '  Calling up windows to the top is completely automatic!' );
    WriteLn;
    WriteLn( '  Windows can be easily moved and hidden from view!' );
    WriteLn;
    WriteLn( '  Assigning a file to a window couldn''t be easier!' );
    WriteLn;
    WriteLn( '  Windows handle themselves, so the programmer can worry about other things!' );
    WriteLn;

    Browse( Window_5 );
    If Float( Window_4 )
      then
        Browse( Window_4 );
    If Float( Window_3 )
      then
        Browse( Window_3 );

    Destroy_Window( Window_1, Window_Horizontal_Right );
    Destroy_Window( Window_2, Window_Up_Left );
    Destroy_Window( Window_3, Window_Down );
    Destroy_Window( Window_4, Window_Vertical );
    Destroy_Window( Window_5, Window_Up );

  End.

