(*****************************************************************************

  Program:  PageMake demonstration.

  Purpose:
    This program demonstrates the page make unit.

  Features:
    PageMake is a page creation unit that makes it easy to write data to the
      printer in a nice neat format.
    Just set the system using the procedures, write your data to it and let
    it do the rest.  When the page is full, the next call to it will
    automatically release the page and prepare for the next one.  If the page
    isn't full, just call page_print and continue.

  Copyright 1995, All rights reserved.
    P. Renaud.

  Compiler:
    Turbo Pascal versions 4.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Program PageMake_Demonstration( Input, Output );

  Uses
   {$IFNDEF OS2}
    PageMaker;
   {$ELSE}
    PageMake;
   {$ENDIF}

  Var
    Count: Integer;

  Begin;
    WriteLn( 'Page Maker demonstration program.' );
    WriteLn( 'Copyright 1995, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates the PageMaker unit.  Note that all output' );
    WriteLn( 'will be routed to the system printer.' );
    WriteLn;
    WriteLn( 'Please press [enter] to start.' );
    ReadLn;

    Page_Clear;
    Page_Margins( 5, 5 );
    Page_Header1( Centered, Expanded + Heightened, 'Lovely Enterprises Incorporated' );
    Page_Header2( Left_Justified, Regular, '' );
    Page_Header3( Centered, Compressed, 'The fresh is the best!' );
    Page_Footer3( Centered, Subscript, 'John Little' );
    Page_Footer4( Centered, Subscript, '1111 Anywhere Lane' );
    Page_Footer5( Centered, Subscript, 'Big City, United States of America   99999-9999' );
    For Count := 1 to 400 do
      Begin
        WriteLn( 'Writing line: ', Count );
       {$IFNDEF OS2}
        Write( PageFile, ' This is a test ' );
       {$ELSE}
        Page_Write( Regular, Pica, ' This is a test ' );
       {$ENDIF}
      End;
    Page_Print;
  End.

