(*****************************************************************************

  Screen
    Version 1.0a

  This unit is a simple unit designed to change the display to a graphic's
    display and provide information to help set the Aspect ratio for Draw.

  Purpose:
    To provide routines to set the graphic mode, check it and to clear the
    screen.

  How it works:
    The routines use the standard BIOS to set and poll the display system.

  Features:
    Simple features make it easy to set the screen mode.
      Modes are as follows...
        0 - Text only, 40 characters by 25 lines in 16 shades.
        1 - Text only, 40 characters by 25 lines in 16 colors.
        2 - Text only, 80 characters by 25 lines in 16 shades.
        3 - Text only, 80 characters by 25 lines in 16 colors.
        4 - Graphics, 320 width by 200 height in 4 colors. Text 40x25.
        5 - Graphics, 320 width by 200 height in 4 shades. Text 40x25.
        6 - Graphics, 640 width by 200 height in 2 colors. Text 80x25.
        7 - Text only, 80 character by 25 lines in 2 colors.
        13 - Graphics, 320 width by 200 height in 16 colors. Text 40x25.
        14 - Graphics, 640 width by 200 height in 16 colors. Text 80x25.
        15 - Graphics, 640 width by 350 height in 2 colors. Text 80x25.
        16 - Graphics, 640 width by 350 height in 16 colors. Text 80x25.
        17 - Graphics, 640 width by 480 height in 2 colors. Text 80x25.
        18 - Graphics, 640 width by 480 height in 16 colors. Text 80x25.
        19 - Graphics, 320 width by 200 height in 256 colors. Text 40x25.

  Versions
    1.0a - Adds the Screen_Okay flag to enable the program to check the 
	   result of the Set_Screen_Mode procedure.

  CopyRight 1993, All rights reserved.
    Paul R. Renaud

  Compiler:
    Turbo Pascal versions 4.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Unit Screen;

  Interface

    Uses
      DOS;

(***********************************************************

  GetMaxX and GetMaxY.

    These variables hold the size of the screen's width and
    height respectively.  They are updated when the screens
    graphical mode is changed by this unit.

***********************************************************)

    Var
      GetMaxX,
      GetMaxY: Integer;

(***********************************************************

  Screen_Okay.

    This flag is set to true by Set_Screen_Mode if the 
    operation was determined to be successful, otherwise it
    is set to false.

***********************************************************)

      Screen_Okay: Boolean;

(***********************************************************

  Procedure: Get screen mode.

    This procedure gets the current screen mode and returns
    it as the value defined by the system.

***********************************************************)

    Procedure Get_Screen_Mode( Var Mode: Byte );

(***********************************************************

  Procedure: Set screen mode.

    This procedure sets the screen mode to the new value
    given defined by the system.

***********************************************************)

    Procedure Set_Screen_Mode( Mode: Byte );

(***********************************************************

  Procedure: Clear graphic screen.

    This procedure clears the entire graphical screen in the
    quickest method possible.

***********************************************************)

    Procedure Clear_Graphic_Screen;

{----------------------------------------------------------------------------}

  Implementation

    Const
      Mode_Mask = $7F;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get mode
    This procedure polls the BIOS for the current
    screen mode.

*************************************************)

    Procedure Get_Mode( Var Mode: Byte );
      Var
        The_Registers: Registers;
      Begin
        The_Registers.AH := $F;
        Intr( $10, The_Registers );
        Mode := The_Registers.AL;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set mode.
    This procedure sets the video mode to the one
    specifired using the BIOS interrupt.

*************************************************)

    Procedure Set_Mode( Mode: Byte );
      Var
        The_Registers: Registers;
      Begin
        The_Registers.AH := 0;
        The_Registers.AL := Mode;
        Intr( $10, The_Registers );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get screen mode
    As previouly defined.

*************************************************)

    Procedure Get_Screen_Mode( Var Mode: Byte );
      Var
        The_Registers: Registers;
      Begin
        Get_Mode( Mode );
        Case Mode of
          0..3, 7:
            Begin
              GetMaxX := 0;
              GetMaxY := 0;
            End;
          4..5, 13, 19:
            Begin
              GetMaxX := 319;
              GetMaxY := 199;
            End;
          6, 14:
            Begin
              GetMaxX := 639;
              GetMaxY := 199;
            End;
          15, 16:
            Begin
              GetMaxX := 639;
              GetMaxY := 349;
            End;
          17, 18:
            Begin
              GetMaxX := 639;
              GetMaxY := 479;
            End;
        End; { Case }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set screen mode
    As previouly defined.

*************************************************)

    Procedure Set_Screen_Mode( Mode: Byte );
      Var
        The_Registers: Registers;
        New_Mode: Byte;
      Begin
        Set_Mode( Mode );
        Get_Screen_Mode( New_Mode );
        Screen_Okay := ( Mode = New_Mode ) or ( ( Mode and Mode_Mask ) = New_Mode );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Clear graphic screen.
    As previouly defined.

*************************************************)


    Procedure Clear_Graphic_Screen;
      Var
        Hold: Byte;
      Begin
        Get_Mode( Hold );
        Set_Mode( ( Hold and Mode_Mask ) );
      End;

{----------------------------------------------------------------------------}

  End.
