(*****************************************************************************

  Program:  Structures demonstration.

  Purpose:
    This program demonstrates the abilities of the structures unit.

  Features:
    This program demonstrates the Stack and Queue structures of the unit.
    First it fills both the stack and the queue with data.
    Then it empties the stack.
    Afterwards it empties the queue.
    Finally, it demonstrates the balanced binary tree structure.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Program Structures_Demonstration( Input, Output );

  Uses
    CRT,
    Check,
   {$IFNDEF OS2}
    Structures;
   {$ELSE}
    Structur;
   {$ENDIF}

  Const
    Limit = 1000;
    Data_Range = 10;

  Type
    Data_Type = Packed Array[ 1 .. Data_Range ] of Char;

{-----------------------------------------------------------------------------}

(*************************************************

  Function: Create char.
    This function generates a random character and
    returns it.

*************************************************)

  Function Create_Char: Char;
    Var
      Character: Char;
    Begin
      Repeat
        Character := CHR( Random( 120 ) );
      Until ( Character in [ 'A'..'Z', 'a'..'z' ] );
      Create_Char := Character;
    End;

{-----------------------------------------------------------------------------}

  Var
    Queue: Queue_Type;
    Stack: Stack_Type;
    Holder,
    Counter: Word;
    Tree: Tree_Type;
    Data: Data_Type;
    Okay: Boolean;
    Counter1,
    Counter2: LongInt;
  Begin
    WriteLn( 'Structure unit demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates some of the features of the demonstration unit.' );
    WriteLn( 'First this program fills both a stack and queue with numbers in increasing' );
    WriteLn( 'order.  Then the queue is emptied followed by the stack.  Lastly, a binary' );
    WriteLn( 'tree is created, filled with randomly generated records and searched before' );
    WriteLn( 'being destroyed.' );
    WriteLn;
    WriteLn( 'Please press [enter] to continue.' );
    ReadLn;

    Mark_Memory;

    ClrScr;
    Create_Queue( Queue, SizeOf( Counter ) );
    Create_Stack( Stack, SizeOf( Counter ) );
    For Counter := 1 to Limit do
      Begin
        Put_In( Queue, Counter );
        Push_On( Stack, Counter );
      End;
    WriteLn( 'Structures are filled' );
    WriteLn( 'Press enter to continue.' );
    ReadLn;

    For Counter := 1 to Limit do
      Begin
        Get_Out( Queue, Holder );
        Write( Holder, ' ' );
      End;
    Discard_Queue( Queue );
    WriteLn;
    WriteLn( 'Queue is empty' );
    WriteLn( 'Press enter to continue.' );
    ReadLn;

    For Counter := 1 to Limit do
      Begin
        Pop_Off( Stack, Holder );
        Write( Holder, ' ' );
      End;
    Discard_Stack( Stack );
    WriteLn;
    WriteLn( 'Stack is empty' );
    WriteLn( 'Press enter to continue.' );
    ReadLn;

    Memory_Gone;
    Mark_Memory;

    ClrScr;
    Randomize;
    Create_Tree( Tree, SizeOf( Data_Type ), 1 , SizeOf( Data_Type ) );
    WriteLn( 'Adding nodes to the tree.' );
    For Counter1 := 1 to Limit do
      Begin
        For Counter2 := 1 to Data_Range do
          Data[ Counter2 ] := Create_Char;
        If Insert_In_Tree( Tree, Data )
          then
            WriteLn( Counter1:5, ' added ', Data );
      End;
    WriteLn( 'Adding complete: Press enter to continue' );
    ReadLn;
    WriteLn( 'Searching for nodes in the tree.' );
    If Find_First_In_Tree( Tree, Data )
      then
        For Counter1 := 1 to Limit do
          Begin
            If Find_In_Tree( Tree, Data )
              then
                WriteLn( Counter1:5, ' found ', Data );
            Okay := Find_Next_In_Tree( Tree, Data );
          End;
    Destroy_Tree( Tree );
    Memory_Gone;
    WriteLn( 'Process finished.' );

  End.

