(*****************************************************************************

  Program:  Timer demonstration.

  Purpose:
    To display the ability of the timer unit.

  Features:
    The timer unit allows a procedure to be linked into the system timer
      routine.
    This program links a simple counter routine into the timer.

  Limitations:
    This program will not compile under Turbo Pascal Version 4.0.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compiler:
    Turbo Pascal versions 5.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Program Timer_Demonstration( Input, Output );

  Uses
    CRT, Timer;

  Var
    Time: Word;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write count.
    This procedure is tied into the system timer
    to write out the count every second.

*************************************************)

  {$F+}
  Procedure Write_Count;
    Begin
      GotoXY( 1, 1 );  { Must watch for non re-entrant procedures }
      Write( Time:7 );
      Inc( Time );
    End;

{----------------------------------------------------------------------------}

  Begin
    WriteLn( 'Timer demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates the abilities of the Timer unit.  Basically,' );
    WriteLn( 'it''s a loop that waits for you to press a key.  During the wait, a routine' );
    WriteLn( 'involked by the timer interrupt will take over for a short moment and display' );
    WriteLn( 'a number on the screen at the top. (Only works in text mode)' );
    WriteLn;
    WriteLn( 'Please press [enter] to start.' );
    ReadLn;

    Time := 0;
    Time_Lapse := 18; { Approximately one second between calls to Write_Count }
    Begin_Timed_Procedure( Write_Count );
    ClrScr;
    Repeat
    Until KeyPressed;
    End_Timed_Procedure;
  End.
