{$I+} { Compiler Directive: Generate Input/Output error code: On }
{$O-} { Compiler Directive: Generate overlay code: Off } { DO NOT CHANGE! }

(*****************************************************************************

  Timer
    Version 1.1

  This unit is designed to make it easy to use the timed system interrupt.

  Purpose:
    To supply a way to tie into the timer interrupt and have a procedure
      executed every time interval.

  How it works:
    This interrupt is generated by the system clock 18.2 times every second.
    This unit ties in to the program interrupt then at the specified time,
      calls the supplied procedure.

  Features:
    You may specIfy how many times the procedure is called for up to eighteen
      times per second.

  Limitations:
    Make sure that the procedure called performs in less than 1/50 of a
      second.  Otherwise, the procedure may take too long and upset the
      systems timing as well as other more important operations.
    Overlaid procedures are strongly not recommended.

  Written by:
    P. R. Renaud

  Compiler:
    Turbo Pascal versions 5.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Unit Timer;

  Interface

    Uses
      DOS;

(***********************************************************

  Timed_Procedure_Type.
    This type is defined to make it easy when passing the
    address of the procedure to the initializing procedure.

***********************************************************)

    Type
      Timed_Procedure_Type = Procedure;

(***********************************************************

  Time_Lapse.
    This value may be changed by your program to Increase or
    decrease the frequency that the timer procedure will
    call your procedure.

***********************************************************)

    Var
      Time_Lapse: Word; { Value in 1/18th of a second }

(***********************************************************

  Procedure: End timed procedure.

    This procedure will turn off the calling of your
    procedure and restore the interrupt patches to their
    default values.  This procedure is automatically called
    in the event your program terminates without previously
    calling it.

***********************************************************)

    Procedure End_Timed_Procedure;

(***********************************************************

  Procedure: Begin timed procedure.

    This procedure will turn on the calling of your
    procedure.  It takes over the timed interrupt.  The
    Time_Lapse variable should be set before this procedure
    is called.  The new procedure must use the far call
    model.
      Example:
        Begin_Timed_Procedure( New_Procedure );

***********************************************************)

    Procedure Begin_Timed_Procedure( New_Procedure: Timed_Procedure_Type );

{----------------------------------------------------------------------------}

  Implementation

    Var
      { Count is used by the interrupt to keep track of the time ratio. }
      Count: Word;
      { Times used keeps track of how many times the routine was set. }
      { It should only be used once in the program. }
      Times_Used: Byte;
      { Old interrupt keeps a copy of the old interrupt which was replaced. }
      Old_Interrupt,
      { This interrupt points to the old exit procedure. }
      Exit_Interrupt: Pointer;
      { This holds the procedure that is called at the specified time intervals. }
      Timed_Procedure: Timed_Procedure_Type;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: New interrupt.
    This procedure is really an interrupt routine
    that links up in between the original and
    the vector.  When the count is equal to the
    time lapse, then the supplied procedure will
    be called.  After that, we return to the
    original interrupt.

*************************************************)

    Procedure New_Interrupt( Flags, Cs, Ip, Ax, Bx, Cx, Dx, Si, Di, Ds, Es, Bp: Word ); Interrupt;
      Begin
        Inc( Count );
        If ( Count > Time_Lapse )
         then
           Begin
             Count := 0;
             Timed_Procedure;
           End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: End timed procedure.
    As previously defined.

*************************************************)

    Procedure End_Timed_Procedure;
      Begin
        SetIntVec( $1C, Old_Interrupt );   { Restore old interrupt vector }
        ExitProc := Exit_Interrupt;        { Restore previous exitproc    }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Begin timed procedure.
    As previously defined.

*************************************************)

    Procedure Begin_Timed_Procedure( New_Procedure: Timed_Procedure_Type );
      Begin
        If ( Times_Used < 1 )
          then
            Begin
              Inc( Times_Used );
              Count := 0;
              Timed_Procedure := New_Procedure;
              GetIntVec( $1C, Old_Interrupt );   { Save "old" interrupt }
              SetIntVec( $1C, @New_Interrupt );  { Install new interrupt }
              Exit_Interrupt := ExitProc;        { Save old exit procedure }
              ExitProc := @End_Timed_Procedure   { Install new exit procedure }
            End
          else
            Begin { There is no need to call procedure twice in same program }
              Writeln( 'Error in Begin_Timed_Procedure: Procedure should not be called twice!' );
              Halt( 1 );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure Default timed procedure.
    This is a dummy procedure, supplied, just in
    case something goes wrong.

*************************************************)

   {$F+}
    Procedure Default_Timed_Procedure;
      Begin
        { Just in case }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Main initialization section.

*************************************************)

  Begin
    Times_Used := 0;
    Time_Lapse := 1;
    Timed_Procedure := Default_Timed_Procedure;
  End.

