{$F+} { Compiler directive: Generate far procedure calls: On } { DO NOT CHANGE! }
{$O+} { Compiler directive: Generate overlay Code: On }

(*****************************************************************************

  Windows
    version 4.21

  This unit holds all the necessary procedures you will need to manage
    simple text windows on the video screen.

  Purpose:
    Designed to compliment the standard CRT unit, this unit extends the
      capabilities of screen management.

  How it works:
    First the window is defined and created on the screen.  After the
      window is created, it is fairly simple to alter it since all the
      aspects are managed internally automatically.
    Once your window is on the screen, you can move it, resize it and
      close it with the built in window managing procedures.
      ( Version 3.0 )
    This unit will also allow you to create a virtual window for use on
      the top of the window stack.  However, this virtual window exist only
      for the window in which it was created.  Simple routines are available
      to create, destroy and reposition the virtual window.  Output to the
      virtual window is handled through a special virtual window file.

  Features:
    Extensive error handling code prevents conflicts between the various
      windows.
    In order to preserve memory, only the minimum amount of needed memory
      is used.  Resizing a window will change available memory on the heap.
    Only the top window is accessed by the function calls.
    Links up with the Menu and Editor units.

  Limitations:
    WARNING!  This unit may cause conflicts with the Multiple Window unit.
    The virtual window is not currently supported under Speed Pascal/2.

  Versions:
   { Not all modifications are included. }
    2.0 -  Added support for better memory management and moveable/resizeable
           windows.
    3.0 -  Combined virtual window manager and window unit together.
    4.0 -  Major Revamp to include better shadow windows.
    4.2 -  Corrected some minor input and output errors.
    4.21 -  Added support to compile under Speed Pascal/2.

  Copyright 1989, 1991, All rights reserved.
    P. Renaud

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Unit Windows;

  Interface

    Uses
      CRT,
      DOS,
      Core,
      KeyBoard;

(***********************************************************

  Attributes.
    All the possible attribute combinations can be put
    together with the following codes in an additive form.
    For example...
      Red_Character + Black_Background
      Light_Blue_Character + Yellow_Background + Flashing
      Reverse_Video_Character + Flashing

***********************************************************)

    Const
      Black_Background   = 0;
      Blue_Background    = 16;
      Green_Background   = 32;
      Cyan_Background    = 48;
      Red_Background     = 64;
      Magenta_Background = 80;
      Yellow_Background  = 96;
      White_Background   = 112;

      Black_Character         = 0;
      Blue_Character          = 1;
      Green_Character         = 2;
      Cyan_Character          = 3;
      Red_Character           = 4;
      Magenta_Character       = 5;
      Brown_Character         = 6;
      Light_Gray_Character    = 7;
      Dark_Gray_Character     = 8;
      Light_Blue_Character    = 9;
      Light_Green_Character   = 10;
      Light_Cyan_Character    = 11;
      Light_Red_Character     = 12;
      Light_Magenta_Character = 13;
      Yellow_Character        = 14;
      White_Character         = 15;

      Flashing = 128;

      No_Character                = 0;
      Dim_Underlined_Character    = 1;
      Dim_Character               = 2;
      Bright_Underlined_Character = 9;
      Bright_Character            = 10;
      Reverse_Video_Character     = 112;

(***********************************************************

  Frame styles for the windows.
    The frame styles are defined here for use in opening a
    window on the screen.

***********************************************************)

      No_Frame = Core.No_Frame;
      Frame_1  = Core.Frame_1;
      Frame_2  = Core.Frame_2;
      Frame_3  = Core.Frame_3;
      Frame_4  = Core.Frame_4;
      Frame_5  = Core.Frame_5;
      Frame_6  = Core.Frame_6;
      Frame_7  = Core.Frame_7;
      Frame_8  = Core.Frame_8;
      { These codes were added as of version 4.2 }
      Frame_9  = Core.Frame_9;
      Frame_10 = Core.Frame_10;
      Frame_11 = Core.Frame_11;
      Frame_12 = Core.Frame_12;
      Frame_13 = Core.Frame_13;
      Frame_14 = Core.Frame_14;
      Frame_15 = Core.Frame_15;
      Frame_16 = Core.Frame_16;
      Frame_17 = Core.Frame_17;
      Frame_18 = Core.Frame_18;
      Frame_19 = Core.Frame_19;
      Frame_20 = Core.Frame_20;
      Frame_21 = Core.Frame_21;
      Frame_22 = Core.Frame_22;
      Frame_23 = Core.Frame_23;
      Frame_24 = Core.Frame_24;

      { Window extentions for shadowed windows as of version 4 }

      Frame_s1  = 128;
      Frame_s2  = 129;
      Frame_s3  = 130;
      Frame_s4  = 131;
      Frame_s5  = 132;
      Frame_s6  = 133;
      Frame_s7  = 134;
      Frame_s8  = 135;
      Frame_s9  = 136;
      Frame_s10 = 137;
      Frame_s11 = 138;
      Frame_s12 = 139;
      Frame_s13 = 140;
      Frame_s14 = 141;
      Frame_s15 = 142;
      Frame_s16 = 143;
      Frame_s17 = 144;
      Frame_s18 = 145;
      Frame_s19 = 146;
      Frame_s20 = 147;
      Frame_s21 = 148;
      Frame_s22 = 149;
      Frame_s23 = 150;
      Frame_s24 = 151;

(***********************************************************

  Methods for opening and closing the windows.
    These are the possible animation techniques for opening
    and closing windows.

***********************************************************)

      Window_Up               = 1;
      Window_Pop              = 2;
      Window_Left             = 3;
      Window_Down             = 4;
      Window_Right            = 5;
      Window_Explode          = 6;
      Window_Up_Left          = 7;
      Window_Up_Right         = 8;
      Window_Vertical         = 9;
      Window_Down_Left        = 10;
      Window_Down_Right       = 11;
      Window_Horizontal       = 12;
      Window_Vertical_Up      = 13;
      Window_Vertical_Down    = 14;
      Window_Horizontal_Left  = 15;
      Window_Horizontal_Right = 16;

(***********************************************************

  Shadow.
    This variable is predefined to specify the colors that
    the shadows of a shadowed window will create. It may be
    changed if desired.

***********************************************************)

      Shadow_Attribute: Byte = 1;

(***********************************************************

  Delay amount.
    This variable defines the amount of time it takes to
    perform a single movement during the window opening and
    closing animation.
    Generally it will not be changed, but it may if it's
    desirable.

***********************************************************)

      Delay_Amount: Word = 1;

(***********************************************************

  VW_TextAttr
    Works with virtual windows in the exact same way that
    TextAttr works with the standard CRT unit.

***********************************************************)

    Var
      VW_TextAttr: Byte;

(***********************************************************

  VW
    The file which allows output to be sent to the virtual
    window.  It works like output does with the CRT unit,
    but it can't be redirected.

***********************************************************)

     {$IFNDEF OS2}
      VW: Text;
     {$ENDIF}

(***********************************************************

  Function: Reverse.

    This function reverses the high and low part of the
    given byte.  It is especially useful for reversing the
    text attribute.  Not supported with version 4.0.

***********************************************************)

     {$IFNDEF VER40}
      Reverse: Function( Value: Byte ): Byte;
     {$ENDIF}

(***********************************************************

  Procedure: Close all open windows.

    This procedure is designed to quickly close all of the
    opened windows on the screen.

***********************************************************)

    Procedure Close_All_Windows;

(***********************************************************

  Procedure: Close the current window.

    This procedure will close the current or topmost window
    using the specified closure method.  It automatically
    closes any virtual window associated along with it.

***********************************************************)

    Procedure Close_Window( Method: Byte );

(***********************************************************

  Procedure: Label the current window.

    This procedure will put a label on the frame of the
    current window using the given attribute.  The label
    will remain on the window unless that window is reduced
    or expanded.  Extra long labels are truncated.

***********************************************************)

    Procedure Label_Window( Attribute: Byte; Name: String );

(***********************************************************

  Function: Open a new window.

    This function will open a window with the given window
    coordinates and frame style using the specified open
    method.  The windows are opened on the stack with the
    most recent window as top and the least as bottom.
    Input and output to the window is still handled through
    the CRT unit.  Windows store underlying screen data in
    the window stack.  It returns false if it fails.
   ( As of version 4.2, this function will truncate the
     window if it exceeds the screen size )

***********************************************************)

    Function Open_Window( New_Frame_Style, Open_Method, New_Left, New_Top, New_Right, New_Bottom, Attribute: Byte ): Boolean;

(***********************************************************

  Functions: Move the current window.

    These functions will move the current window in the
    specified direction on the screen without destroying
    underlying data.

***********************************************************)

    Function Move_Window_Up: Boolean;
    Function Move_Window_Down: Boolean;
    Function Move_Window_Left: Boolean;
    Function Move_Window_Right: Boolean;

(***********************************************************

  Functions: Expand the current window.

    These functions will expand the current window in the
    specified direction while keeping memory requirements
    to a minimum and maintaining underlying data integrity.
    Internal window data is adjusted accordingly.  Nothing
    happens if the window can't be expanded.

***********************************************************)

    Function Expand_Window_Up: Boolean;
    Function Expand_Window_Down: Boolean;
    Function Expand_Window_Left: Boolean;
    Function Expand_Window_Right: Boolean;

(***********************************************************

  Functions: Reduce the current window.

    These functions will reduce the current window on the
    specified side while keeping memory requirements to a
    minimum and maintaining underlying data integrity.
    Window labels may possibly be destroyed.

***********************************************************)

    Function Reduce_Window_Up: Boolean;
    Function Reduce_Window_Down: Boolean;
    Function Reduce_Window_Left: Boolean;
    Function Reduce_Window_Right: Boolean;

(***********************************************************

  Function: Create a virtual window.

    This function creates a virtual window on the screen.
    All data written to that window must be handled through
    the VW routines and text file.
    Row_Length gives height of the actual window to be
     allocated.
    Column_Length gives width of the actual window to be
     allocated.
    Window location on the screen is determined by the
     current window coordinates.
    This function returns false if there isn't enough
     memory to create the window.

***********************************************************)

    Function VW_Create( Row_Length, Column_Length: Byte ): Boolean;

(***********************************************************

  Procedure: Destroy a virtual window.

    Destroys the current virtual window on the stack and
    makes the simple window active only.

***********************************************************)

    Procedure VW_Destroy;

(***********************************************************

  Procedure: Browse through a virtual window.

    This procedure allows the viewer to conduct a complete
    examination of the contents of a virtual window.
    This Procedure will exit when enter or escape is
     pressed.
    This procedure has it's own help screen.
    This procedure allows movement, expansion and shrinkage
     of the window, so the window's screen coordinates may
     be changed.

***********************************************************)

    Procedure VW_Browse;

(***********************************************************

  Procedures.

    These procedures are included to allow the same
    versatility which the CRT unit gives to the screen, to
    be used with virtual windows.  They all work identically
    to the procedures given in the CRT unit.  The cursor
    position procedures work with the virtual screen's
    cursor.

***********************************************************)

    Procedure VW_ClrEOL;
    Procedure VW_ClrScr;
    Procedure VW_GotoXY( Column, Row: Byte );
    Function VW_WhereY: Byte;
    Function VW_WhereX: Byte;

(***********************************************************

  Procedure: Scroll the window.

    These extensions allow the virtual screen to be scrolled
    in the specified directions: Up, Down, Left and Right.

***********************************************************)

    Procedure VW_Scroll_Up;
    Procedure VW_Scroll_Down;
    Procedure VW_Scroll_Left;
    Procedure VW_Scroll_Right;

(***********************************************************

  Functions: Virtual window move view.

    These functions allow for moving the view in a virtual
    window which happens to be larger than the corresponding
    screen window.

***********************************************************)

    Function VW_Move_View_Left: Boolean;
    Function VW_Move_View_Right: Boolean;
    Function VW_Move_View_Up: Boolean;
    Function VW_Move_View_Down: Boolean;

(***********************************************************

  Procedure: Assign VW.

    This is a special procedure that allows a text file to
    be assigned to the virtual_window.  It is almost
    identical to the AssignCRT procedure in the CRT unit.

***********************************************************)

   {$IFNDEF OS2}
    Procedure Assign_VW( Var The_File: Text );
   {$ENDIF}

{----------------------------------------------------------------------------}

  Implementation

    Const
     { Maximum amount of rows the code will handle. }
      Max_Rows = 50;
     { Maximum amount of columns the code will handle. }
      Max_Columns = 121;

    Type
     { Definitions for storage of virtual window information in records. }
      Virtual_Window_Pointer_Type = ^Virtual_Window_Type;
      Virtual_Window_Type = Record
                              Where_Top,
                              Where_Left,
                              Where_Right,
                              Where_Bottom,
                              Screen_Top,
                              Screen_Left,
                              Screen_Right,
                              Screen_Bottom,
                              Window_Width,
                              Window_Height: Byte;
                              Storage: Storage_Record;
                            END;

     { Definitions for storage of window information on the stack. }
      Window_Pointer_Type = ^Window_Type;
      Window_Type = Record
                      Next: Window_Pointer_Type;
                      Frame: Frame_Type;
                      Storage: Storage_Record;
                      Shadow: Boolean;
                      Old_Top,
                      Old_Left,
                      Old_Right,
                      Old_Bottom,
                      Safety_Top,
                      Safety_Left,
                      Safety_Right,
                      Safety_Bottom,
                      Old_Attribute,
                      New_Attribute,
                      Old_Where_Row,
                      Old_Where_Column,
                      Frame_Style: Byte;
                      Virtual_Window: Virtual_Window_Pointer_Type;
                     {$IFNDEF VER40}
                      Reposition: Procedure;
                     {$ENDIF}
                    End;

     { Type definition for window opening animation. }
      Expand_Data_Type = Record
                           Frame: Frame_Type;
                           Top,
                           Left,
                           Right,
                           Bottom,
                           Attribute,
                           Current_Top,
                           Current_Left,
                           Current_Right,
                           Current_Bottom: Byte;
                           Expand_Up,
                           Expand_Down,
                           Expand_Left,
                           Expand_Right: Boolean;
                         End;

    Var
     { Holds the old video mode of the system. }
      Old_Mode: Word;
     { Multipurpose work area for several routines. }
      Work_Area: Area_Type;
     { Points to the window stack. }
      Current_Window: Window_Pointer_Type;

{----------------------------------------------------------------------------}

 {$I Windows2.Pas}

{----------------------------------------------------------------------------}

 {$I Windows3.Pas}

{----------------------------------------------------------------------------}

(*************************************************

  Function: Internal expand window up.
    This function tries to stretch the window up
    on the screen.

*************************************************)

    Function Internal_Expand_Window_Up( Var Data: Window_Type ): Boolean;
      Var
        Column,
        Old_Row,
        New_Top,
        Old_Column: Byte;
        Okay: Boolean;
        New_Area: Storage_Record;
      Begin
        Okay := False;
        If ( Data.Safety_Top > 1 )
          then
            With Data do
              Begin
                Get_The_Mode;
                Get_Row_And_Column( Old_Row, Old_Column );
                New_Top := Pred( Safety_Top );
                Calculate_Storage_Amount( New_Area, Succ( Safety_Bottom - New_Top ), Succ( Safety_Right - Safety_Left ) );
                New_Area.Location := Nil;
                If ( MaxAvail >= New_Area.Amount )
                  then
                    Okay := Allocate_Storage( New_Area );
                If Okay
                  then
                    Begin
                      Move( Storage.Location^, New_Area.Location^, Storage.Amount );
                      Scroll_Storage_Down( New_Area );
                      Deallocate_Storage( Storage );
                      Storage := New_Area;
                      Preserve_Row( New_Top, Safety_Left, Safety_Right, New_Top );
                      If ( Frame_Style = No_Frame )
                        then
                          Window( Safety_Left, New_Top, Safety_Right, Safety_Bottom )
                        else
                          If Shadow
                            then
                              Begin
                                Window( Safety_Left, New_Top, Pred( Safety_Right ), Safety_Top );
                                Scroll_Window_Up;
                                Make_Shadow( Succ( New_Top ), Safety_Right, 1 );
                                Draw_Window_Sides( Frame, Safety_Left, Pred( Safety_Top ), Pred( Safety_Right ),
                                                   Succ( Safety_Top ) );
                                Window( Succ( Safety_Left ), Safety_Top, Pred( Pred( Safety_Right ) ),
                                        Pred( Pred( Safety_Bottom ) ) );
                              End
                            else
                              Begin
                                Window( Safety_Left, New_Top, Safety_Right, Safety_Top );
                                Scroll_Window_Up;
                                Draw_Window_Sides( Frame, Safety_Left, Pred( Safety_Top ), Safety_Right, Succ( Safety_Top ) );
                                Window( Succ( Safety_Left ), Safety_Top, Pred( Safety_Right ), Pred( Safety_Bottom ) );
                              End;
                      Safety_Top := New_Top;
                      Scroll_Window_Up;
                      GotoXY( Old_Column, Old_Row );
                     {$IFNDEF VER40}
                      Reposition;
                      UpDate_Control;
                     {$ELSE}
                      VW_Reposition;
                     {$ENDIF}
                      Delay( Delay_Amount );
                    End;
              End;
        Internal_Expand_Window_Up := Okay;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Internal expand window down.
    This function tries to stretch the window down
    on the screen.

*************************************************)

    Function Internal_Expand_Window_Down( Var Data: Window_Type ): Boolean;
      Var
        Old_Row,
        Old_Column,
        New_Bottom: Byte;
        Okay: Boolean;
        New_Area: Storage_Record;
      Begin
        Okay := False;
        Get_The_Mode;
        If ( Data.Safety_Bottom < Screen_Row_Limit )
          then
            With Data do
              Begin
                Get_Row_And_Column( Old_Row, Old_Column );
                New_Bottom := Succ( Safety_Bottom );
                Calculate_Storage_Amount( New_Area, Succ( New_Bottom - Safety_Top ), Succ( Safety_Right - Safety_Left ) );
                New_Area.Location := Nil;
                If ( MaxAvail >= New_Area.Amount )
                  then
                    Okay := Allocate_Storage( New_Area );
                If Okay
                  then
                    Begin
                      Move( Storage.Location^, New_Area.Location^, Storage.Amount );
                      Deallocate_Storage( Storage );
                      Storage := New_Area;
                      Preserve_Row( New_Bottom, Safety_Left, Safety_Right, Safety_Top );
                      If ( Frame_Style = No_Frame )
                        then
                          Window( Safety_Left, Safety_Top, Safety_Right, New_Bottom )
                        else
                          If Shadow
                            then
                              Begin
                                Window( Safety_Left, Pred( Safety_Bottom ), Pred( Safety_Right ), Pred( New_Bottom ) );
                                Scroll_Window_Down;
                                Make_Shadow( New_Bottom, Succ( Safety_Left ), ( Safety_Right - Safety_Left ) );
                                Draw_Window_Sides( Frame, Safety_Left, Pred( Pred( Safety_Bottom ) ), Pred( Safety_Right ),
                                                   Safety_Bottom );
                                Window( Succ( Safety_Left ), Succ( Safety_Top ), Pred( Pred( Safety_Right ) ),
                                        Pred( Safety_Bottom ) );
                              End
                            else
                              Begin
                                Window( Safety_Left, Safety_Bottom, Safety_Right, New_Bottom );
                                Scroll_Window_Down;
                                Draw_Window_Sides( Frame, Safety_Left, Pred( Safety_Bottom ), Safety_Right,
                                                   Succ( Safety_Bottom ) );
                                Window( Succ( Safety_Left ), Succ( Safety_Top ), Pred( Safety_Right ), Safety_Bottom );
                              End;
                      Safety_Bottom := New_Bottom;
                      Internal_Expand_Window_Down := True;
                      If ( Frame_Style = No_Frame )
                        then
                          Blank_Row( New_Bottom, Safety_Left, Safety_Right );
                      GotoXY( Old_Column, Old_Row );
                     {$IFNDEF VER40}
                      Reposition;
                      UpDate_Control;
                     {$ELSE}
                      VW_Reposition;
                     {$ENDIF}
                      Delay( Delay_Amount );
                    End;
              End;
        Internal_Expand_Window_Down := Okay;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Internal expand window left.
    This function tries to stretch the window left
    on the screen.

*************************************************)

    Function Internal_Expand_Window_Left( Var Data: Window_Type ): Boolean;
      Var
        Row,
        Old_Row,
        New_Left,
        Character,
        Attribute,
        Old_Column: Byte;
        Okay: Boolean;
        New_Area: Storage_Record;
      Begin
        Okay := False;
        If ( Data.Safety_Left > 1 )
          then
            With Data do
              Begin
                Get_The_Mode;
                Get_Row_And_Column( Old_Row, Old_Column );
                New_Left := Pred( Safety_Left );
                Calculate_Storage_Amount( New_Area, Succ( Safety_Bottom - Safety_Top ), Succ( Safety_Right - New_Left ) );
                New_Area.Location := Nil;
                If ( MaxAvail >= New_Area.Amount )
                  then
                    Okay := Allocate_Storage( New_Area );
                If Okay
                  then
                    Begin
                      For Row := 1 to New_Area.Row_Length do
                        Move( Address_Storage( Storage, Row, 1 )^, Address_Storage( New_Area, Row, 2 )^,
                              ( Storage.Column_Length * 2 ) );
                      Deallocate_Storage( Storage );
                      Storage := New_Area;
                      Preserve_Column( New_Left, Safety_Top, Safety_Bottom, New_Left );
                      If ( Frame_Style = No_Frame )
                        then
                          Window( New_Left, Safety_Top, Safety_Right, Safety_Bottom )
                        else
                          If Shadow
                            then
                              Begin
                                Draw_Left_Shadow( Frame, Safety_Top, New_Left, Pred( Safety_Bottom ) );
                                Window( Safety_Left, Succ( Safety_Top ), Pred( Pred( Safety_Right ) ),
                                        Pred( Pred( Safety_Bottom ) ) );
                              End
                            else
                              Begin
                                Draw_Left( Frame, Safety_Top, New_Left, Safety_Bottom );
                                Window( Safety_Left, Succ( Safety_Top ), Pred( Safety_Right ), Pred( Safety_Bottom ) );
                              End;
                      Safety_Left := New_Left;
                      Internal_Expand_Window_Left := True;
                      Scroll_Window_Left;
                      GotoXY( Old_Column, Old_Row );
                     {$IFNDEF VER40}
                      Reposition;
                      UpDate_Control;
                     {$ELSE}
                      VW_Reposition;
                     {$ENDIF}
                      Delay( Delay_Amount );
                    End;
              End;
        Internal_Expand_Window_Left := Okay;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Internal expand window right.
    This function tries to stretch the window
    right on the screen.

*************************************************)

    Function Internal_Expand_Window_Right( Var Data: Window_Type ): Boolean;
      Var
        Row,
        Old_Row,
        New_Right,
        Character,
        Attribute,
        Old_Column: Byte;
        Okay: Boolean;
        New_Area: Storage_Record;
      Begin
        Okay := False;
        Get_The_Mode;
        If ( Data.Safety_Right < Screen_Column_Limit )
          then
            With Data do
              Begin
                Get_Row_And_Column( Old_Row, Old_Column );
                New_Right := Succ( Safety_Right );
                Calculate_Storage_Amount( New_Area, Succ( Safety_Bottom - Safety_Top ), Succ( New_Right - Safety_Left ) );
                New_Area.Location := Nil;
                If ( MaxAvail >= New_Area.Amount )
                  then
                    Okay := Allocate_Storage( New_Area );
                If Okay
                  then
                    Begin
                      For Row := 1 to New_Area.Row_Length do
                        Move( Address_Storage( Storage, Row, 1 )^, Address_Storage( New_Area, Row, 1 )^,
                              ( Storage.Column_Length * 2 ) );
                      Deallocate_Storage( Storage );
                      Storage := New_Area;
                      Preserve_Column( New_Right, Safety_Top, Safety_Bottom, Safety_Left );
                      If ( Frame_Style = No_Frame )
                        then
                          Window( Safety_Left, Safety_Top, New_Right, Safety_Bottom )
                        else
                          If Shadow
                            then
                              Begin
                                Draw_Right_Shadow( Frame, Safety_Top, Pred( New_Right ), Pred( Safety_Bottom ) );
                                Window( Succ( Safety_Left ), Succ( Safety_Top ), Pred( Safety_Right ),
                                        Pred( Pred( Safety_Bottom ) ) );
                              End
                            else
                              Begin
                                Draw_Right( Frame, Safety_Top, New_Right, Safety_Bottom );
                                Window( Succ( Safety_Left ), Succ( Safety_Top ), Safety_Right, Pred( Safety_Bottom ) );
                              End;
                      Safety_Right := New_Right;
                      Internal_Expand_Window_Right := True;
                      If ( Frame_Style = No_Frame )
                        then
                          Blank_Column( New_Right, Safety_Top, Safety_Bottom );
                      GotoXY( Old_Column, Old_Row );
                     {$IFNDEF VER40}
                      Reposition;
                      UpDate_Control;
                     {$ELSE}
                      VW_Reposition;
                     {$ENDIF}
                      Delay( Delay_Amount );
                    End;
              End;
        Internal_Expand_Window_Right := Okay;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Internal reduce window up.
    This function tries to push the window up
    on the screen.

*************************************************)

    Function Internal_Reduce_Window_Up( Var Data: Window_Type ): Boolean;
      Var
        Okay: Boolean;
        New_Bottom: Byte;
        New_Area: Storage_Record;
      Begin
        Okay := False;
        New_Bottom := Pred( Data.Safety_Bottom );
        If ( ( New_Bottom - Data.Safety_Top ) > 3 )
          then
            With Data do
              Begin
                Get_The_Mode;
                Calculate_Storage_Amount( New_Area, Succ( New_Bottom - Safety_Top ), Succ( Safety_Right - Safety_Left ) );
                New_Area.Location := Nil;
                If ( MaxAvail >= New_Area.Amount )
                  then
                    Okay := Allocate_Storage( New_Area );
                If Okay
                  then
                    Begin
                      If ( Frame_Style <> No_Frame )
                        then
                          If Shadow
                            then
                              Begin
                                Scroll_Region_Up( Safety_Left, Pred( New_Bottom ), Pred( Safety_Right ),
                                                  Pred( Safety_Bottom ) );
                                Restore_Row( Pred( Safety_Bottom ), Safety_Left, Safety_Right, Safety_Top );
                                Make_Shadow( Pred( Safety_Bottom ), Succ( Safety_Left ), ( Safety_Right - Safety_Left ) );
                              End
                            else
                              Scroll_Region_Up( Safety_Left, New_Bottom, Safety_Right, Safety_Bottom );
                      Restore_Row( Safety_Bottom, Safety_Left, Safety_Right, Safety_Top );
                      Safety_Bottom := New_Bottom;
                      Internal_Reduce_Window_Up := True;
                      Move( Address_Storage( Storage, 1, 1 )^, Address_Storage( New_Area, 1, 1 )^,
                            New_Area.Amount );
                      Deallocate_Storage( Storage );
                      Storage := New_Area;
                      Reset_Window;
                     {$IFNDEF VER40}
                      Reposition;
                      UpDate_Control;
                     {$ELSE}
                      VW_Reposition;
                     {$ENDIF}
                      Delay( Delay_Amount );
                    End;
              End;
        Internal_Reduce_Window_Up := Okay;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Internal reduce window down.
    This function tries to push the window down
    on the screen.

*************************************************)

    Function Internal_Reduce_Window_Down( Var Data: Window_Type ): Boolean;
      Var
        Okay: Boolean;
        New_Top: Byte;
        New_Area: Storage_Record;
      Begin
        Okay := False;
        New_Top := Succ( Data.Safety_Top );
        If ( ( Data.Safety_Bottom - New_Top ) > 3 )
          then
            With Data do
              Begin
                Get_The_Mode;
                Calculate_Storage_Amount( New_Area, Succ( Safety_Bottom - New_Top ), Succ( Safety_Right - Safety_Left ) );
                New_Area.Location := Nil;
                If ( MaxAvail >= New_Area.Amount )
                  then
                    Okay := Allocate_Storage( New_Area );
                If Okay
                  then
                    Begin
                      If ( Frame_Style <> No_Frame )
                        then
                          If Shadow
                            then
                              Begin
                                Scroll_Region_Down( Safety_Left, Safety_Top, Pred( Safety_Right ), New_Top );
                                Restore_Column( Safety_Right, Safety_Top, Succ( Safety_Top ), Safety_Left );
                              End
                            else
                              Scroll_Region_Down( Safety_Left, Safety_Top, Safety_Right, New_Top );
                      Restore_Row( Safety_Top, Safety_Left, Safety_Right, Safety_Top );
                      Safety_Top := New_Top;
                      Internal_Reduce_Window_Down := True;

                      Move( Address_Storage( Storage, 2, 1 )^, Address_Storage( New_Area, 1, 1 )^,
                            New_Area.Amount );
                      Deallocate_Storage( Storage );
                      Storage := New_Area;
                      Reset_Window;
                     {$IFNDEF VER40}
                      Reposition;
                      UpDate_Control;
                     {$ELSE}
                      VW_Reposition;
                     {$ENDIF}
                      Delay( Delay_Amount );
                    End;
              End;
        Internal_Reduce_Window_Down := Okay;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Internal reduce window right.
    This function tries to push the window right
    on the screen.

*************************************************)

    Function Internal_Reduce_Window_Right( Var Data: Window_Type ): Boolean;
      Var
        Row,
        New_Left: Byte;
        Okay: Boolean;
        New_Area: Storage_Record;
      Begin
        Okay := False;
        New_Left := Succ( Data.Safety_Left );
        If ( ( Data.Safety_Right - New_Left ) > 3 )
          then
            With Data do
              Begin
                Get_The_Mode;
                Calculate_Storage_Amount( New_Area, Succ( Safety_Bottom - Safety_Top ), Succ( Safety_Right - New_Left ) );
                New_Area.Location := Nil;
                If ( MaxAvail >= New_Area.Amount )
                  then
                    Okay := Allocate_Storage( New_Area );
                If Okay
                  then
                    Begin
                      If ( Frame_Style <> No_Frame )
                        then
                          If Shadow
                            then
                              Begin
                                Scroll_Region_Right( Safety_Left, Safety_Top, New_Left, Pred( Safety_Bottom ) );
                                Restore_Row( Safety_Bottom, Safety_Left, Succ( Safety_Left ), Safety_Top )
                              End
                            else
                              Scroll_Region_Right( Safety_Left, Safety_Top, New_Left, Safety_Bottom );
                      Restore_Column( Safety_Left, Safety_Top, Safety_Bottom, Safety_Left );
                      Safety_Left := New_Left;
                      Internal_Reduce_Window_Right := True;

                      For Row := 1 to New_Area.Row_Length do
                        Move( Address_Storage( Storage, Row, 2 )^, Address_Storage( New_Area, Row, 1 )^,
                              ( New_Area.Column_Length * 2 ) );
                      Deallocate_Storage( Storage );
                      Storage := New_Area;
                      Reset_Window;
                     {$IFNDEF VER40}
                      Reposition;
                      UpDate_Control;
                     {$ELSE}
                      VW_Reposition;
                     {$ENDIF}
                      Delay( Delay_Amount );
                    End;
              End;
        Internal_Reduce_Window_Right := Okay;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Internal reduce window left.
    This function tries to push the window left
    on the screen.

*************************************************)

    Function Internal_Reduce_Window_Left( Var Data: Window_Type ): Boolean;
      Var
        Row,
        New_Right: Byte;
        Okay: Boolean;
        New_Area: Storage_Record;
      Begin
        Okay := False;
        Get_The_Mode;
        New_Right := Pred( Data.Safety_Right );
        If ( ( New_Right - Data.Safety_Left ) > 3 )
          then
            With Data do
              Begin
                Calculate_Storage_Amount( New_Area, Succ( Safety_Bottom - Safety_Top ), Succ( New_Right - Safety_Left ) );
                New_Area.Location := Nil;
                If ( MaxAvail >= New_Area.Amount )
                  then
                    Okay := Allocate_Storage( New_Area );
                If Okay
                  then
                    Begin
                      If ( Frame_Style <> No_Frame )
                        then
                          If Shadow
                            then
                              Begin
                                Scroll_Region_Left( Pred( New_Right ), Safety_Top, Pred( Safety_Right ),
                                                    Pred( Safety_Bottom ) );
                                Restore_Column_Shadow( Pred( Safety_Right ), Safety_Top, Safety_Bottom, Safety_Left );
                              End
                            else
                              Scroll_Region_Left( New_Right, Safety_Top, Safety_Right, Safety_Bottom );
                      Restore_Column( Safety_Right, Safety_Top, Safety_Bottom, Safety_Left );
                      Safety_Right := New_Right;
                      Internal_Reduce_Window_Left := True;

                      For Row := 1 to New_Area.Row_Length do
                        Move( Address_Storage( Storage, Row, 1 )^, Address_Storage( New_Area, Row, 1 )^,
                              ( New_Area.Column_Length * 2 ) );
                      Deallocate_Storage( Storage );
                      Storage := New_Area;
                      Reset_Window;
                     {$IFNDEF VER40}
                      Reposition;
                      UpDate_Control;
                     {$ELSE}
                      VW_Reposition;
                     {$ENDIF}
                      Delay( Delay_Amount );
                    End;
              End;
        Internal_Reduce_Window_Left := Okay;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Move window up.
    As previously defined.

*************************************************)

    Function Move_Window_Up;
      Begin
        If ( Current_Window <> Nil )
          then
            Move_Window_Up := Internal_Move_Window_Up( Current_Window^ )
          else
            Move_Window_Up := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Move window down.
    As previously defined.

*************************************************)

    Function Move_Window_Down;
      Begin
        If ( Current_Window <> Nil )
          then
            Move_Window_Down := Internal_Move_Window_Down( Current_Window^ )
          else
            Move_Window_Down := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Move window left.
    As previously defined.

*************************************************)

    Function Move_Window_Left;
      Begin
        If ( Current_Window <> Nil )
          then
            Move_Window_Left := Internal_Move_Window_Left( Current_Window^ )
          else
            Move_Window_Left := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Move window right.
    As previously defined.

*************************************************)

    Function Move_Window_Right;
      Begin
        If ( Current_Window <> Nil )
          then
            Move_Window_Right := Internal_Move_Window_Right( Current_Window^ )
          else
            Move_Window_Right := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Expand window up.
    As previously defined.

*************************************************)

    Function Expand_Window_Up;
      Begin
        If ( Current_Window <> Nil )
          then
            Expand_Window_Up := Internal_Expand_Window_Up( Current_Window^ )
          else
            Expand_Window_Up := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Expand window down.
    As previously defined.

*************************************************)

    Function Expand_Window_Down;
      Begin
        If ( Current_Window <> Nil )
          then
            Expand_Window_Down := Internal_Expand_Window_Down( Current_Window^ )
          else
            Expand_Window_Down := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Expand window left.
    As previously defined.

*************************************************)

    Function Expand_Window_Left;
      Begin
        If ( Current_Window <> Nil )
          then
            Expand_Window_Left := Internal_Expand_Window_Left( Current_Window^ )
          else
            Expand_Window_Left := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Expand window right.
    As previously defined.

*************************************************)

    Function Expand_Window_Right;
      Begin
        If ( Current_Window <> Nil )
          then
            Expand_Window_Right := Internal_Expand_Window_Right( Current_Window^ )
          else
            Expand_Window_Right := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Reduce window up.
    As previously defined.

*************************************************)

    Function Reduce_Window_Up;
      Begin
        If ( Current_Window <> Nil )
          then
            Reduce_Window_Up := Internal_Reduce_Window_Up( Current_Window^ )
          else
            Reduce_Window_Up := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Reduce window down.
    As previously defined.

*************************************************)

    Function Reduce_Window_Down;
      Begin
        If ( Current_Window <> Nil )
          then
            Reduce_Window_Down := Internal_Reduce_Window_Down( Current_Window^ )
          else
            Reduce_Window_Down := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Reduce window left.
    As previously defined.

*************************************************)

    Function Reduce_Window_Left;
      Begin
        If ( Current_Window <> Nil )
          then
            Reduce_Window_Left := Internal_Reduce_Window_Left( Current_Window^ )
          else
            Reduce_Window_Left := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Reduce window right.
    As previously defined.

*************************************************)

    Function Reduce_Window_Right;
      Begin
        If ( Current_Window <> Nil )
          then
            Reduce_Window_Right := Internal_Reduce_Window_Right( Current_Window^ )
          else
            Reduce_Window_Right := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Main initialization section.
    First initialize the window stack.
    Then initialize the virtual window file.
    Link in the window moving routines.

*************************************************)

    Begin
      Current_Window := Nil;
     {$IFNDEF OS2}
      Assign_VW( VW );
      Rewrite( VW );
     {$ENDIF}
     {$IFNDEF VER40}
      Reverse := Core.Reverse;
      Core.Up_Routine := Move_Window_Up;
      Core.Down_Routine := Move_Window_Down;
      Core.Left_Routine := Move_Window_Left;
      Core.Right_Routine := Move_Window_Right;
      Core.Reduce_Height_Routine := Reduce_Window_Up;
      Core.Expand_Height_Routine := Expand_Window_Down;
      Core.Reduce_Width_Routine := Reduce_Window_Left;
      Core.Expand_Width_Routine := Expand_Window_Right;
     {$EndIf}
    End.

