unit IniUnit;
{@ .INI file object }

{
	******************************************************************
	*                                                                *
	*   This is a Microsoft(R) style .INI file objectfor TP7/BP7.0   *
	*                                                                *
	*	Written by Fran Moerel & donated to the public domain.         *
	*	If you have any problems or suggestions please contact me      *
	*	on:                                                            *
	*                                                                *
	*		BBS Source Paradise +31-15-621077                            *
	*                                                                *
	*		FidoNet             2:281/912                                *
	*                                                                *
	*		PascalNet           115:3113/0                               *
	*                                                                *
	*		Internet            moerel@nni.nl                            *
	*                                                                *
	*		SnailMail           Fran Moerel                              *
	*												Diepenbrockstraat 210                    *
	*												2625XB DELFT                             *
	*												The Netherlands                          *
	*                                                                *
	******************************************************************

	How to use this unit:


	Initialising & disposing the object
	-----------------------------------

	Init(strIniFileName);
	Done;


	Getting, Inserting or deleting entries
	--------------------------------------

	function GetItem(strSectionName, strItem, strDefault) : string;

		example :

			strDosDir := GetItem('Paths', 'DOS', 'C:\DOS');
	
			This will return 'C:\DOS601' with the followin INI file:

					[Paths]
					DOS=C:\DOS600
					Test=C:\

			If the item does not yet exist, it will be created with the Default Value


	function PutItem(strSectionName, strItem, strValue) : string;

		example :

			strDosDir := PutItem('Colours', 'Background', 'RED');
	
			This will enter 'Background=Red' in section 'Colours'.
			If applied to the .Ini file of the example above, you will get:

					[Paths]
					DOS=C:\DOS600
					Test=C:\

					[Colours]
					Background=Red


	function ChangeItem(strSectionName, strItem, strNewValue) : string;

		example :

			strDosDir := ChangeItem('Colours', 'Background', 'Blue');
	
			If applied to the .Ini file of the example above, you will get:

					[Paths]
					DOS=C:\DOS600
					Test=C:\

					[Colours]
					Background=Blue


	function DeleteItem(strSectionName, strItem) : string;

		example :

			strDosDir := DeleteItem('Colours', 'Background');
	
			If applied to the .Ini file of the example above, you will get:

					[Paths]
					DOS=C:\DOS600
					Test=C:\

					[Colours]



	You can put blank lines between the Ini lines. Comment lines can
	lines have to start with ;

	Have a look at EXAMPLE.INI to get an idea of the results.

}


interface


uses toolkit;


const
	BChange = 1;
	BDelete = 2;


type
	PIni = ^TIni;
	TIni = object

		strIniFile : string;

		constructor Init(strNewIniFile : string);
		destructor  Done;
		function    GetItem(strSection, strItem, strDefault : string) : string;
		procedure   PutItem(strSection, strItem, strValue : string);
		procedure   DeleteItem(strSection, strItem : string);
		procedure   ChangeItem(strSection, strItem, strValue : string;
													 bytCommand : byte);

	end;

implementation


constructor TIni.Init(strNewIniFile : string);
begin
	strIniFile := strNewIniFile;
end;


destructor TIni.Done;
begin
end;


function TIni.GetItem(strSection, strItem, strDefault : string) : string;
{ Get item out of ini file}

var
	filIni      : text;
	intIOResult : integer;
	strCommand  : string;
	strData     : string;
	strLine     : string;
	bolSection  : boolean;
	bolFound    : boolean;

begin
	Assign(filIni, strIniFile);
	{ check for evt. file lock }
	repeat
		{$I-}
		Reset(filIni);
		{$I+}
		intIOResult := IOResult;
	until intIOResult <> 162;
	{ Check for non-existing ini file }
	if intIOResult = 2 then
	begin
		PutItem(strSection, strItem, strDefault);
		GetItem := strDefault;
	end
		else
	begin
		{ Check for doserror }
		tlkDosErr('Ini.GetItem', intIOResult);
		{ All OK, process }
		strCommand := '';
		strData := '';
		bolSection := FALSE;
		bolFound := FALSE;
		while not Eof(filIni) and not bolFound do
		begin
			ReadLn(filIni, strLine);
			if strLine[1] <> ';' then
			begin
				tlkTokenSplit(strLine, '=', strCommand, strData);
				strCommand := tlkStrip(strCommand, ' ', BStripBoth);
				strData := tlkStrip(strData, ' ', BStripBoth);
				if strCommand[1] = '[' then
				begin
					if Pos(tlkUpper('['+ strSection + ']'), tlkUpper(strCommand)) <> 0 then bolSection := TRUE
						else bolSection := FALSE;
				end
					else
				begin
					if bolSection and (tlkUpper(strCommand) = tlkUpper(strItem)) then bolFound := TRUE;
				end;
			end;
		end;
		if bolFound then
		begin
			GetItem := strData;
			Close(filIni);
		end
			else
		begin
			GetItem := strDefault;
			Close(filIni);
			PutItem(strSection, strItem, strDefault);
		end;
	end;

end;





procedure TIni.ChangeItem(strSection, strItem, strValue : string;
													bytCommand : byte);
{ Modify, delete or put item in ini file }

var
	filIni          : text;
	filTemp         : text;
	intIOResult     : integer;
	strCommand      : string;
	strData         : string;
	strLine         : string;
	strLastSection  : string;
	strLastComment  : string;
	strTempFile     : string[12];
	bolSection      : boolean;
	bolFound        : boolean;
	bolFirstSection : boolean;
	bolDelete       : boolean;

begin
	Assign(filIni, strIniFile);
	{ check for evt. file lock }
	repeat
		{$I-}
		Reset(filIni);
		{$I+}
		intIOResult := IOResult;
	until intIOResult <> 162;
	{ Open temp file }
	Str(Random(32767), strTempFile);
	strTempFile := strTempFile + '{I}.TMP';
	Assign(filTemp, strTempFile);
	Rewrite(filTemp);
	{ Check for non-existing ini file }
	if intIOResult = 2 then
	begin
		Rewrite(filIni);
		WriteLn(filTemp);
		WriteLn(filTemp, '[' + strSection + ']');
		WriteLn(filTemp, strItem + '=' + strValue);
	end
		else
	begin

		{ Check for doserror }
		tlkDosErr('Ini.GetItem', intIOResult);
		{ All OK, process }
		strCommand := '';
		strData := '';
		strLastSection := '';
		bolSection := FALSE;
		bolFound := FALSE;
		bolFirstSection := TRUE;
		strLastComment := '';
		bolDelete := FALSE;
		while not Eof(filIni) do
		begin
			ReadLn(filIni, strLine);
			tlkTokenSplit(strLine, '=', strCommand, strData);
			if (strLine[1] = ';') and (Length(strLine) <> 0) then
			begin
				strLastComment := strLine;
			end
				else
			begin
				if (strCommand[1] = '[') and (Length(strCommand) <> 0)then
				begin
					if Pos(tlkUpper('['+ strSection + ']'), tlkUpper(strCommand)) <> 0 then
					begin
						strLastSection := strCommand;
						bolSection := TRUE;
					end
						else
					begin
						bolSection := FALSE;
						if (not bolFound) and (tlkUpper(strLastSection) = tlkUpper('[' + strSection + ']'))
								and (bytCommand <> BDelete) then
						begin
							WriteLn(filTemp, strItem + '=' + strValue);
							bolFound := TRUE;
						end;
					end;
					WriteLn(filTemp);
					if strLastComment<> '' then
					begin
						WriteLn(filTemp, strLastComment);
						strLastComment := '';
					end;
					WriteLn(filTemp, strCommand);
				end
					else
				begin
					if bolSection and (tlkUpper(strCommand) = tlkUpper(strItem)) then
					begin
						if bytCommand = BChange
							then strData := strValue
							else bolDelete := TRUE;
						bolFound := TRUE;
					end;
					if strLastComment<> '' then
					begin
						WriteLn(filTemp, strLastComment);
						strLastComment := '';
					end;
					if strCommand <> '' then
					begin
						if not bolDelete
							then WriteLn(filTemp, strCommand + '=' + strData)
							else bolDelete := FALSE;
					end;
				end;
			end;
		end;
		if not bolFound  and (bytCommand <> BDelete)then
		begin
			if not bolSection then
			begin
				WriteLn(filTemp);
				WriteLn(filTemp, '[' + strSection + ']');
			end;
			WriteLn(filTemp, strItem + '=' + strValue);
		end;
	end;
	Close(filIni);
	Close(filTemp);

	{ Wait for lock and delete old ini file}
	repeat
		{$I-}
		Erase(filIni);
		{$I+}
	until IOResult = 0;
	Rename(filTemp, strIniFile);

end;

procedure TIni.PutItem(strSection, strItem, strValue : string);
{ Modify or add an item in a ini file }
begin
	ChangeItem(strSection, strItem, strValue, BChange);
end;


procedure TIni.DeleteItem(strSection, strItem : string);
{ Delete an item in an ini file }
begin
	ChangeItem(strSection, strItem, '', BDelete);
end;


end.
