.MODEL   TPASCAL
LOCALS

.DATA

EXTRN	UpperTbl:BYTE
EXTRN	LowerTbl:BYTE

.CODE

tlkLoCase       PROC FAR C:BYTE
                PUBLIC  tlkLoCase
		mov	al,[C]
		mov	bx,OFFSET LowerTbl
		xlat
		ret
tlkLoCase       ENDP

tlkUpCase       PROC FAR C:BYTE
                PUBLIC  tlkUpCase
		mov	al,[C]
		mov	bx,OFFSET UpperTbl
		xlat
		ret
tlkUpCase       ENDP

tlkUpper        PROC FAR S:DWORD  RETURNS Result:DWORD
                PUBLIC  tlkUpper
		USES	DS
		mov	dx,SEG DATA
		les	di,[Result]	; get addr of function result
		lds	si,[S]		; get addr of function parameter
		xor	ax,ax
		cld			; forward string op
		lodsb			; get length
		stosb			; copy length
		or	ax,ax		; null string ?
		jz	@@done
		mov	cx,ax
		mov	bx,OFFSET UpperTbl
		xor	ax,ax
@@copy:		lodsb
		push	ds
		mov	ds,dx
		xlat			; transform
		pop	ds
		stosb
		loop	@@copy
@@done:		mov	ds,dx
		ret
tlkUpper        ENDP

tlkLower        PROC FAR S:DWORD RETURNS Result:DWORD
                PUBLIC  tlkLower
		mov	dx,ds
		les	di,[Result]	; get addr of function result
		lds	si,[S]		; get addr of function parameter
		xor	ax,ax
		cld			; forward string op
		lodsb			; get length
		stosb			; copy length
		or	ax,ax		; null string ?
		jz	@@done
		mov	cx,ax
		mov	bx,OFFSET LowerTbl
		xor	ax,ax
@@copy:		lodsb
		push	ds
		mov	ds,dx
		xlat			; transform
		pop	ds
		stosb
		loop	@@copy
@@done:		mov	ds,dx
		ret
tlkLower        ENDP

tlkPadLeft      PROC FAR S:DWORD,Pad:BYTE,Siz:BYTE RETURNS Result:DWORD
                PUBLIC  tlkPadLeft
		USES	DS
		les	di,[Result]	; get addr of function result
		cld			; forward string op
		xor	ax,ax
		mov	al,[Siz]	; get field size
		stosb			; store it
		mov	cx,ax
		mov	al,[Pad]	; get pad character
		rep stosb		; fill result string with pad char
		les	di,[Result]	; get addr of function result
		inc	di		; adjust to access 1st char
		lds	si,[S]		; get addr of function parameter
		lodsb			; get original string length
		mov	cl,[Siz]	; get field size
		cmp	ax,cx
		jge	@@Ok		; Ok  since (length(Orig) > Siz)
					; ax<cx  (length(orig) < Siz)
		xchg	cx,ax		; set count to be the lesser
		sub	ax,cx		; find adjustment
		add	di,ax		; and adjust destination
@@Ok:		rep movsb
		ret
tlkPadLeft      ENDP

tlkPadRight     PROC FAR S:DWORD,Pad:BYTE,Siz:BYTE RETURNS Result:DWORD
                PUBLIC  tlkPadRight
		USES	DS
		les	di,[Result]	; get addr of function result
		cld			; forward string op
		xor	ax,ax
		mov	al,[Siz]	; get field size
		stosb			; store it
		mov	cx,ax
		mov	al,[Pad]	; get pad character
		rep stosb		; fill result string with pad char
		lds	si,[S]		; get addr of function parameter
		lodsb			; get original string length
		les	di,[Result]	; get addr of function result
		inc	di		; adjust to access 1st char
		mov	cl,[Siz]	; get field size
		cmp	ax,cx
		jge	@@Ok		; Ok  since (length(Orig) > Siz)
		; ax<cx  (length(orig) < Siz)
		xchg	cx,ax		; set count to be the lesser
@@Ok:		rep movsb
		ret
tlkPadRight     ENDP


tlkStrip        PROC FAR S:DWORD,U:DWORD,L:BYTE RETURNS Result:DWORD
		PUBLIC	tlkStrip
		USES	ds
		LOCAL	Skip:BYTE,EndSkip:BYTE
		mov	[Skip],0
		mov	[EndSkip],0
		mov	al,[L]
                cmp     al,0
		je	@@IsArr
		cmp	al,2
		jne	@@TestEll
@@IsArr:	sub	ax,ax
		mov	cx,ax
		lds	si,[S]
		mov	al,[si]		; get length of original
		mov	bx,ax
		add	si,bx		; move to end of original string
		les	di,[U]
		mov	cl,es:[di]	; get length of unwanted
		or	ax,cx
		jz	@@DoCopy	; if either are zero, then done
		mov	dx,di
@@RightStrip:	inc	di		; LOOP ; move past length byte
		std			;   backward string op
		lodsb			;   check char
		cld			;   forward string op
		repne scasb		;   scan
		jne	@@TestEll	; EXIT IF NOT Found
		inc	[EndSkip]	;   increment skip count
		dec	bx		;   decrease copy length
		or	bx,bx		;
		jz	@@DoCopy	; EXIT IF NullString
		mov	di,dx		;   reset search string
		mov	cl,es:[di]	;   get length again
		jmp	@@RightStrip	; ENDLOOP
@@TestEll:	mov	al,[L]
		cmp	al,1
		je	@@IsEll
		cmp	al,2
		jne	@@DoCopy
@@IsEll:	sub	cx,cx
		mov	ax,cx
		les	di,[U]
		mov	dx,di
		mov	cl,es:[di]	; get length of unwanted string
		lds	si,[S]
		lodsb			; get length of original string
		mov	bx,ax
		sub	bl,[Skip]	; adjust for skipped chars
		or	ax,cx
		jz	@@DoCopy	; if either is zero, then done
		cld			; forward string op
@@LeftStrip:	inc	di		; LOOP ;move past length byte
		lodsb			;   get char to check
		repne scasb		;   scan
		jne	@@DoCopy	; EXIT IF NOT Found
		inc	[Skip]		;   increment skip count
		dec	bx		;   decrease copy length
		or	bx,bx		;
		jz	@@DoCopy	; EXIT IF NullString
		mov	di,dx		;   reset search string
		mov	cl,es:[di]	;   get length again
		jmp	@@LeftStrip	; ENDLOOP
@@DoCopy:	lds	si,[S]
		les	di,[Result]
		sub	ax,ax
		sub	bx,bx
		lodsb
		mov	bl,[Skip]
		add	si,bx
		sub	al,bl
		sub	al,[EndSkip]
		stosb
		mov	cx,ax
		jcxz	@@Done
		cld			; forward string op
		rep movsb
@@Done:		ret
tlkStrip        ENDP

tlkRightPos     PROC FAR     Needle:DWORD,HayStack:DWORD
                PUBLIC  tlkRightPos
		USES	ds
;
		xor	ax,ax
		mov	bx,ax
		les	di,[HayStack]	;IF Length(HayStack)=0 THEN
                mov     al,es:[di]
		or	al,al
		jz	Done		;   Return(0)
		; NOTE: ax <-- Length(HayStack)
		lds	si,[Needle]	;IF Length(Needle) = 0 THEN
		mov	bl,ds:[si]
		or	bl,bl
		jz	Done		;   Return(Length(HayStack))
		; NOTE: bx <-- Length(Needle)
		cmp	al,bl		;IF Length(Needle) > Length(HayStack) THEN
		jl	@@NotFound
		mov	cx,ax		;  cx <-- length(HayStack)
		sub	cx,bx		;         - length(Needle)
		inc	cx		;         + 1
		add	di,cx		;  di <-- ofs(HayStack[cx])
					;  REPEAT
@@More:		std			;    reverse string op
		mov	al,[si+1]	;    ax <-- Needle[1]
		repne scasb
		je	@@Ok		;    if not found then
@@NotFound:	mov	ax,0		;        Return(0)
		jmp	Done
@@Ok:		mov	ax,cx
		mov	dx,di
		inc	di		;    adjust di
		inc	si		;    move ds:si to 1st char
		cld			;    forward string op
		mov	cx,bx
		repz cmpsb		;    test match
		jz	@@Found		;
		lds	si,[Needle]
		mov	di,dx
		mov	cx,ax
		or	cx,cx		;  UNTIL cx=0
		jnz	@@More
					;END IF
@@Found:	sub	di,bx		;adjust di
		mov	ax,di
		les	di,[HayStack]
		sub	ax,di
Done:		ret
	ENDP

tlkRightCPos    PROC FAR C:BYTE,S:DWORD
                PUBLIC  tlkRightCPos
		USES	DS
		les	di,[S]		; get addr of function parameter
		xor	ax,ax
		mov	al,es:[di]
		or	ax,ax
		jz	@@done
		mov	bx,di
		dec	bx
		mov	cx,ax
		add	di,cx
		mov	al,[C]
		std			; backward string op
		repne scasb		; search
		je	@@Found
		mov	di,bx
@@Found:	xchg	ax,di
		sub	ax,bx
@@done:		ret
tlkRightCPos    ENDP

tlkLeftCPos     PROC FAR C:BYTE,S:DWORD
                PUBLIC  tlkLeftCPos
		USES	DS
		xor	ax,ax
		les	di,[S]		; get addr of function parameter
                mov     al,es:[di]
		or	ax,ax
		jz	@@done
		inc	di
		mov	bx,di
		mov	cx,ax
		mov	al,[C]
		cld			; forward string op
		repne scasb		; search
		je	@@Found
		mov	di,bx
@@Found:	xchg	ax,di
		sub	ax,bx
@@done:		ret
tlkLeftCPos     ENDP

END
