{$A+,B-,D+,E+,F-,G-,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+}

unit Toolkit;
{@ My little toolbox }

{ Writen by Fran Moerel }

interface


uses Dos, Strings;


const

	SPrefixes = '*''T*''S*T*AAN*D''*DE*DEN*DER*AM*AUF*DEM*AUS*BIJ*DIE*DES*DI*'
							+ 'DO*DON*DOS*DU*EL*HET*I*IM*IN*L*L''*LA*LAS*LES*LO*LOS*ONDER*'
							+ 'OP*TEN*OVER*S''*TE*TEN*TER*TOT*UIT*UIJT*UNTER*VAN*VOM*VON*VOOR*VOR*ZU*ZUM*ZUR*';

	ARRNormMonthOffs : array[1..13] of integer = (0,31,59,90,120,151,181,212,243,273,304,334, 365);
	ARRLeapMonthOffs : array[1..13] of integer = (0,31,60,91,121,152,182,213,244,274,305,335, 366);

	SUpCase  : array[1..2] of string = 
						('',
						 '');

	SLoCase  : array[1..2] of string = 
						('',
						 '');


	{ Toolkit }
	BName     = 0;
	BAddr     = 1;
	BDCUserID = 2;

	{ Time string }
	BTimeLong   = 0;
	BTimeShort  = 1;

	{ Serial numbering }
	BLong  = 0;
	BShort = 1;

	BDomain     = 1;
	BSubDomain1 = 2;
	BSubDomain2 = 3;
	BSubDomain3 = 4;
	BSubDomain4 = 5;

	BStripRight = 0;
	BStripLeft  = 1;
	BStripBoth  = 2;


type
	CharSet	      = set of Char;
	timestring    = string[8];
	byteptr       = ^byte;
	memory        = byte;
	memptr        = ^memory;
	CharLookTbl	  = array [char] of char;
	hexwordstring = string[4];

	{ Globablly used types }
	datestring 		   = string[19];
	serialnumstring  = string[9];
	fidostring       = string[32];
	namestring  	   = string[80];
	str127           = string[127];

var
	LowerTbl,
	UpperTbl	: CharLookTbl;



{ Date/Time functions 
	-------------------
	All dates are in YY-MM-DD form, other format have to be obtained using
	tlkReformatDate
	Time is in HH:MM:SS form using 24 hour system}
function  tlkDateString : datestring;
function  tlkDateTimePack : longint;
function  tlkDateTimeToPack(strDate, strTime : string) : longint;
function  tlkTimeString(bytMode : byte) : timestring;
function  tlkDateOnly(strDateTime : string) : datestring;
function  tlkTimeOnly(strDateTime : string) : timestring;
function  tlkYearOnly(wrdYear : word) : word;
function  tlkNoSeconds(strTime : timestring) : timestring;
function  tlkPackToDate(linDate : longint) : datestring;
function  tlkPackToTime(linDate : longint) : timestring;
function  tlkIncDate(strISODate : datestring; intOffset : integer) : datestring;
function  tlkReformatDate(strDate, strFromFormat, strToFormat : datestring) : datestring;
function  tlkMinutesToday : integer;
function  tlkMinutes(linPackDate : longint) : integer;
function  tlkDayOfWeek : byte;

{ Serial number functions }
function  tlkNextSerial(strCurrNum : serialnumstring; bytCommand : byte) : serialnumstring;
function  tlkFileNextSerial(strSerialFile : string; bytCommand : byte) : serialnumstring;

{ String functions }

function  tlkLoCase(chrToProcess : char) : char;
function  tlkUpCase(chrToProcess : char) : char;
function  tlkUpper(strToProcess : string) : string;
function  tlkLower(strToProcess : string) : string;
function  tlkPadRight(strToPad : string; chrPadChar : char; bytPadLength : byte) : string;
function  tlkPadLeft(strToPad : string; chrPadChar : char; bytPadLength : byte) : string;
function  tlkPadLinLeft(wrdToPad : longint; bytLength : byte; chrPadChar : char) : String;
function  tlkStrLeft(strToStrip : string; bytLength : byte) : string;
procedure tlkTokenSplit(strToToken : string; chrToken : char;
												var strLeftFromToken, strRightFromToken : string);
procedure tlkRightTokenSplit(strToToken : string; chrToken : char;
														 var strLeftFromToken, strRightFromToken : string);
function  tlkCharReplace(strToProcess : datestring; chrToReplace,
												 chrReplaceWith : char) : string;
function  tlkBinString(wrdToConvert : word) : string;
function  tlkRightCPos(chrToFind : char; strToSearch : string) : integer;
function  tlkLeftCPos(chrToFind : char; strToSearch : string) : integer;
function  tlkRightPos(strToSearch, strToFind : string) : byte;
function  tlkStrip(strToDo, strToStrip : string; bytMode : byte) : string;
function  tlkHexWordString(wrdToDo : word) : hexwordstring;
function  tlkHexToWord(strHex : string) : word;

{ Memory functions }
procedure tlkDecPtr(var P : memptr);
procedure tlkIncPtr(var P : memptr);
procedure tlkSwapLin(var linToSwap : longint);
function  tlkLinHi(linToSplit : longint) : word;
function  tlkLinLo(linToSplit : longint) : word;

{ Addressing functions }
function  tlkFormatName(strName : string) : string;
function  tlkFormatInitials(strInitials : string) : string;
function  tlkNoPrefix(strName : string) : string;
function  tlkPrefix(strName : string) : string;
function  tlkFidoNet(strFidoAddr : fidostring) : word;
function  tlkFidoNode(strFidoAddr : fidostring) : word;
function  tlkFidoZone(strFidoAddr : fidostring) : byte;
function  tlkPointNum(strAddr : fidostring) : fidostring;
function  tlkINetSplit(strAddr : namestring; bytElement : byte) : namestring;
function  tlkInetAddr(strInet : namestring; bytCommandType : byte) : namestring;

{ DOS functions }
procedure tlkDosErr(strErrPos : string; intIOResult : integer);
procedure tlkCopyFile(strFrom, strTo : string);
procedure tlkConcatFile(strFrom1, strFrom2, strTo : string);
procedure tlkMoveFile(strFrom, strTo : string);
procedure tlkMoveAll(strFromPath, strToPath : string);
procedure tlkDelFile(strFrom: string; bolMustExist : boolean);
procedure tlkDelAll(strPath: string);
procedure tlkCreateDir(strNewDir: string);
function  tlkLockFile(Var filToLock; linLockStart, linLockLength: longint) : boolean;
procedure tlkUnLockFile(Var filToUnlock; linLockStart, linLockLength: longint);
procedure tlkHalt(strErrorText : string);

{ Sound functions }
procedure tlkShortBeep;
procedure tlkErrorBeep;
procedure tlkSOSBeep;
procedure tlkSound(Hz:Word);
procedure tlkNoSound;

{ Crt functions }
procedure tlkDispChar(chrToDisp : char);
procedure tlkDispString(strToDisp : string);
procedure tlkDispLn(strToDisp : string);
procedure tlkHideCursor;
procedure tlkShowCursor;
function  tlkKeyScan : integer;
procedure tlkSwitch50; 
procedure tlkSwitch25; 
function  tlkReadKey : char;
function  tlkKeyPressed : boolean;
procedure tlkDelay(ms : Word);


Implementation


Const
	WRDBlCursor    = $0006;               { Cursor Constants   }
	WRDLineCursor  = $0B0C;
	WRDNoCursor    = $2000;


{ Externals }

{$L TOOLKIT.OBJ }

function tlkPadLeft(strToPad : string; chrPadChar : char; bytPadLength : byte) : string; external;
{ Pad a string with a character to the left }

function tlkPadRight(strToPad : string; chrPadChar : char; bytPadLength : byte) : string; external;
{ Pad a string with a character to the right }

function tlkStrip(strToDo, strToStrip : string; bytMode : byte) : string; external;
{ Strip something from a string, 0 = left, 1 = right, 2 = both ends }

function tlkRightCPos(chrToFind : char; strToSearch : string) : integer; external;
{ Search character in string starting at end }

function tlkLeftCPos(chrToFind : char; strToSearch : string) : integer; external;
{ Search character in string starting at start }

function tlkRightPos(strToSearch, strToFind : string) : byte; external;
{ Find a string in another string starting from the end }

function tlkLoCase(chrToProcess : char) : char; external;
{ Convert char to lowercase using X-Lat tables }

function tlkUpCase(chrToProcess : char) : char; external;
{ Convert char to uppercase using X-Lat tables }

function tlkUpper(strToProcess : string) : string; external;
{ Convert string to uppercase}

function tlkLower(strToProcess : string) : string; external;
{ Convert string to lowercase}


{ Internals }


procedure tlkSwitch50; assembler;
{ Switch to 43/50 lines }
asm
	 MOV AX,$1112
	 INT $10
end;


procedure tlkSwitch25; assembler;
{ Switch to 25 lines }
asm
	 MOV AX,$1114
	 INT $10
end;


function tlkHexWordString(wrdToDo : word) : hexwordstring;
{ Return a Hex word from a word }

const
 hexChars: array [0..$F] of Char =
	 '0123456789ABCDEF';
begin
 tlkHexWordString := hexChars[Hi(wrdToDo) shr 4] +
										 hexChars[Hi(wrdToDo) and $F] +
										 hexChars[Lo(wrdToDo) shr 4] +
										 hexChars[Lo(wrdToDo) and $F];
end;


function tlkHexToWord(strHex : string) : word;
{ Convert a hex byte to byte }

var
	wrdResult : word;
	wrdOfs    : word;
	bytPos    : byte;
	bytDigit  : byte;

begin
	{ Check for length }
	if Length(strHex) > 4 then
	begin
		WriteLn('Overflow errror on hex ', strHex);
		Halt(100);
	end;

	{ Convert it }
	wrdResult := 0;
	for bytPos := 1 to Length(strHex) do
	begin
		wrdResult := wrdResult Shl 4;
		bytDigit := Pos(tlkUpCase(strHex[bytPos]), '0123456789ABCDEF');
		if bytDigit = 0 then
		begin
			WriteLn(strHex, ' is not a hex number');
			Halt(100);
		end;
		wrdResult := wrdResult + (bytDigit - 1);
	end;

	tlkHexToWord := wrdResult;
end;


procedure tlkHalt(strErrorText : string);
{ Halt with an error display }
begin
	WriteLn(strErrorText);
	Halt(100);
end;


{$F+}
function MakeFarPtr(Seg,Ofs : Word) : byteptr;
begin
	inline ( $8B / $46 / $08 /
					 $89 / $46 / $FE /
					 $8B / $46 / $06 /
					 $89 / $46 / $FC );
end;
{$F-}


procedure tlkIncPtr(var P : memptr);
begin
	P := MemPtr(MakeFarPtr(  Seg(P^) , Succ(Ofs(P^))));
end;


procedure tlkDecPtr(var P : memptr);
begin
	P := MemPtr(MakeFarPtr(  Seg(P^) , Pred(Ofs(P^))));
end;


function tlkINetSplit(strAddr : namestring; bytElement : byte) : namestring;

var
	bytDotCount   : byte;
	bytAddrPos    : byte;
	bytLastDotPos : byte;
	bytCurrDotPos : byte;

begin
	bytDotCount   := 0;
	bytAddrPos    := Length(strAddr);
	bytLastDotPos := 0;
	bytCurrDotPos := 0;
	if strAddr = '' then
	begin
		tlkINetSplit := '';
	end
		else
	begin
		repeat
			if strAddr[bytAddrPos] = '.' then
			begin
				bytLastDotPos := bytCurrDotPos;
				bytCurrDotPos := bytAddrPos;
				Inc(bytDotCount);
			end;
			Dec(bytAddrPos);
		until (bytAddrPos = 0) or (bytDotCount = bytElement);
		if (bytAddrPos = 0) and (bytDotCount < bytElement - 1)
			then tlkInetSplit := ''
		else if (bytAddrPos = 0) and (bytDotCount = bytElement -1)
			then tlkInetSplit := Copy(strAddr, 1, bytCurrDotPos - 1)
		else if (bytDotCount = 0) and (bytElement = 1)
			then tlkInetSplit := strAddr
		else if bytElement = 1
			then tlkInetSplit := Copy(strAddr, bytCurrDotPos + 1, Length(strAddr) - bytCurrDotPos + 1)
		else tlkInetSplit := Copy(strAddr, bytCurrDotPos + 1, bytLastDotPos - bytCurrDotPos - 1)
	end;
end;


function tlkPointNum(strAddr : fidostring) : fidostring;
{ Split point off the address }

var
	strPoint : fidostring;
	strDummy : fidostring;

begin
	tlkTokenSplit(strAddr, '.', strDummy, strPoint);
	tlkPointNum := strPoint;
end;


function tlkFidoZone(strFidoAddr : fidostring) : byte;

var
	strLeft   : fidostring;
	strRight  : fidostring;
	intCode   : integer;
	bytResult : byte;

begin
	tlkTokenSplit(strFidoAddr, ':', strLeft, strRight);
	Val(strLeft, bytResult, intCode);
	tlkFidoZone := bytResult;
end;


function tlkFidoNet(strFidoAddr : fidostring) : word;

var
	strLeft   : fidostring;
	strRight  : fidostring;
	wrdResult : word;
	intCode   : integer;

begin
	tlkTokenSplit(strFidoAddr, ':', strLeft, strRight);
	tlkTokenSplit(strRight, '/', strLeft, strRight);
	Val(strLeft, wrdResult, intCode);
	tlkFidoNet := wrdResult;
end;


function tlkFidoNode(strFidoAddr : fidostring) : word;

var
	strLeft   : fidostring;
	strRight  : fidostring;
	wrdResult : word;
	intCode   : integer;

begin
	tlkTokenSplit(strFidoAddr, ':', strLeft, strRight);
	tlkTokenSplit(strRight, '/', strLeft, strRight);
	if tlkLeftCPos('.', strRight) <> 0 then
	begin
		tlkTokenSplit(strRight, '.', strLeft, strRight);
		Val(strLeft, wrdResult, intCode);
	end
		else
	begin
		Val(strRight, wrdResult, intCode);
	end;
	tlkFidoNode := wrdResult;
end;


function tlkYearOnly(wrdYear : word) : word;
{ Return only year without century }
begin
	if wrdYear >= 2000 then tlkYearOnly := wrdYear - 2000
		else tlkYearOnly := wrdYear - 1900;
end;


function tlkPackToDate(linDate : longint) : datestring;
{ Return date from a packed date }
var
	dttTime      : DateTime;

begin
	UnpackTime(linDate, dttTime);
	tlkPackToDate := tlkPadLinLeft(tlkYearOnly(dttTime.Year),2,'0') + '-' +
									 tlkPadLinLeft(dttTime.Month,2,'0') + '-' +
									 tlkPadLinLeft(dttTime.Day,2,'0');
end;


function tlkPackToTime(linDate : longint) : timestring;
{ Return time from a packed date }
var
	dttTime      : DateTime;

begin
	UnpackTime(linDate, dttTime);
	tlkPackToTime := tlkPadLinLeft(dttTime.Hour,2,'0') + ':' +
											 tlkPadLinLeft(dttTime.Min,2,'0');
end;


function  tlkDateTimeToPack(strDate, strTime : string) : longint;

var
	dttTime      : DateTime;
	linPacked    : longint;
	Code         : integer;

begin
	Val(Copy(strDate, 1, 2), dttTime.Year, Code);
	Val(Copy(strDate, 4, 2), dttTime.Month, Code);
	Val(Copy(strDate, 7, 2), dttTime.Day, Code);
	if dttTime.Year > 90
		then dttTime.Year := dttTime.Year + 1900
		else dttTime.Year := dttTime.Year + 2000;
	Val(Copy(strTime, 1, 2), dttTime.Hour, Code);
	Val(Copy(strTime, 4, 2), dttTime.Min, Code);
	dttTime.Sec   := 0;
	PackTime(dttTime, linPacked);
	tlkDateTimeToPack := linPacked;
end;


function  tlkBinString(wrdToConvert : word) : string;
{ Convert word to binary in string form }

var
	cnt1       : integer;
	strResult  : string[16];
	wrdDivider : word;

begin
	strResult := '';
	wrdDivider := 32768;
	for cnt1 := 1 to 16 do
	begin
		if (wrdToConvert AND wrdDivider) <> 0
			then strResult := strResult + '1'
			else strResult := strResult + '0';
		wrdDivider := wrdDivider SHR 1;
	end;
	tlkBinString := strResult;
end;


function tlkCharReplace(strToProcess : datestring; chrToReplace,
												chrReplaceWith : char) : string;
{ Replace one character with another in a string }

var
	cnt1 : integer;

begin
	For cnt1 := 1 to Length(strToProcess) do
	begin
		if strToProcess[cnt1] = chrToReplace then
			strToProcess[cnt1] := chrReplaceWith;
	end;
	tlkCharReplace := strToProcess;
end;


procedure tlkShortBeep;
begin
	tlkSound(1000);
	tlkDelay(50);
	tlkNoSound;
end;


procedure tlkErrorBeep;
begin
	tlkSound(1000);
	tlkDelay(200);
	tlkSound(500);
	tlkDelay(200);
	tlkNoSound;
end;


procedure tlkSOSBeep;
begin
	tlkSound(1800);
	tlkDelay(100);
	tlkNosound;
	tlkDelay(50);

	tlkSound(1800);
	tlkDelay(100);
	tlkNosound;
	tlkDelay(50);

	tlkSound(1800);
	tlkDelay(100);
	tlkNosound;
	tlkDelay(100);

	tlkSound(1800);
	tlkDelay(200);
	tlkNosound;
	tlkDelay(50);

	tlkSound(1800);
	tlkDelay(200);
	tlkNosound;
	tlkDelay(50);

	tlkSound(1800);
	tlkDelay(200);
	tlkNosound;
	tlkDelay(100);

	tlkSound(1800);
	tlkDelay(100);
	tlkNosound;
	tlkDelay(50);

	tlkSound(1800);
	tlkDelay(100);
	tlkNosound;
	tlkDelay(50);

	tlkSound(1800);
	tlkDelay(100);
	tlkNosound;
	tlkDelay(200);

end;


procedure tlkSetCursor(curs : Word);
var reg : Registers;
begin
	with reg Do
	begin
		AH := 1;
		BH := 0;
		CX := Curs;
		Intr($10, reg);
	end;
end;


procedure tlkDispChar(chrToDisp : char);
var reg : Registers;
begin
	with reg Do
	begin
		AH := 2;
		AL := 0;
		DX := byte(chrToDisp);
		Intr($21, reg);
	end;
end;


procedure tlkDispString(strToDisp : string);

var
	bytPos : byte;

begin
	for bytPos := 1 to Length(strToDisp) do tlkDispChar(strToDisp[bytPos]);
end;


procedure tlkDispLn(strToDisp : string);
begin
	tlkDispString(strToDisp);
	tlkDispChar(#13);
	tlkDispChar(#10);
end;


procedure tlkShowCursor;
var Curs : Word;
Begin
	tlkSetCursor (WRDLineCursor);
end;


procedure tlkHideCursor;
begin
	tlkSetCursor(WRDNoCursor)
end;


function tlkLinLo(linToSplit : longint) : word;
{ Swap the Lo & Hi order words of a longint }

type 
	PWord = ^TWord;
	TWord = array [0..1] of word;

var 
	ptrLin  : pointer;

begin
	ptrLin 	 := @linToSplit;
	tlkLinLo := PWord(ptrLin)^[0];
end;


function tlkLinHi(linToSplit : longint) : word;
{ Swap the Lo & Hi order words of a longint }
type 
	PWord = ^TWord;
	TWord = array [0..1] of word;

var 
	ptrLin  : pointer;

begin
	ptrLin 	 := @linToSplit;
	tlkLinHi := PWord(ptrLin)^[1];
end;


function tlkLockFile(Var filToLock; linLockStart, linLockLength: longint): boolean;

var
	Regs         : registers;
	Handle       : word absolute filToLock;

begin

	linLockStart := linLockStart * linLockLength;

	Regs.Ah := $5c;
	Regs.Al := $00;
	Regs.Bx := Handle;
	Regs.Cx := tlkLinHi(linLockStart);
	Regs.Dx := tlkLinLo(linLockStart);
	Regs.Si := tlkLinHi(linLockLength);
	Regs.Di := tlkLinLo(linLockLength);
	MsDos(Regs);

	if ((Regs.Flags and 1) = 0) then
	begin
		tlkLockFile := TRUE;
	end
		else
	begin
		if Regs.AX <> 33 then
		begin
			WriteLn('Lock Error', Regs.AX);
			Halt(100);
		end;
		tlkLockFile := FALSE;
	end;

end;


procedure tlkUnLockFile(var filToUnlock; linLockStart, linLockLength: longint);

var
	Regs    : registers;
	Handle  : word absolute filToUnlock;
	wrdCode : word;

begin
	linLockStart := linLockStart * linLockLength;
	Regs.Ah := $5c;
	Regs.Al := $01;
	Regs.Bx := Handle;
	Regs.Cx := tlkLinHi(linLockStart);
	Regs.Dx := tlkLinLo(linLockStart);
	Regs.Si := tlkLinHi(linLockLength);
	Regs.Di := tlkLinLo(linLockLength);
	MsDos(Regs);

	if ((Regs.Flags and 1) <> 0) then
	begin
		WriteLn('Unlock Error', Regs.AX);
		Halt(100);
	end;

end;


procedure tlkCopyFile(strFrom, strTo : string);
{ Copy a file to another file }

var
	filFrom       : file;
	filTo         : file;
	wrdNumRead    : word;
	wrdNumWritten : Word;
	Buf: array[1..2048] of Char;

begin
	Assign(filFrom, strFrom); { Open input file }
	{$I-}
	Reset(filFrom, 1);  { Record size = 1 }
	{$I+}
	tlkDosErr('File Copy : ' + strFrom + ' - ' + strTo, IOResult);

	Assign(filTo, strTo); { Open output file }
	Rewrite(filTo, 1);  { Record size = 1 }
	repeat
		BlockRead(filFrom, Buf, SizeOf(Buf), wrdNumRead);
		BlockWrite(filTo, Buf, wrdNumRead, wrdNumWritten);
	until (wrdNumRead = 0) or (wrdNumWritten <> wrdNumRead);
	Close(filFrom);
	Close(filTo);
end;


procedure tlkConcatFile(strFrom1, strFrom2, strTo : string);
{ Concat 2 files to another file }

var
	filFrom1      : file;
	filFrom2      : file;
	filTo         : file;
	wrdNumRead    : word;
	wrdNumWritten : Word;
	Buf: array[1..2048] of Char;

begin
	{ Open output filew }
	Assign(filTo, strTo);
	Rewrite(filTo, 1);

	{ Open input files }
	Assign(filFrom1, strFrom1);
	{$I-}
	Reset(filFrom1, 1);
	{$I+}
	tlkDosErr('File Concat file 1', IOResult);
	Assign(filFrom2, strFrom2);
	{$I-}
	Reset(filFrom2, 1);
	{$I+}
	tlkDosErr('File Concat file 2', IOResult);

	repeat
		BlockRead(filFrom1, Buf, SizeOf(Buf), wrdNumRead);
		BlockWrite(filTo, Buf, wrdNumRead, wrdNumWritten);
	until (wrdNumRead = 0) or (wrdNumWritten <> wrdNumRead);

	repeat
		BlockRead(filFrom2, Buf, SizeOf(Buf), wrdNumRead);
		BlockWrite(filTo, Buf, wrdNumRead, wrdNumWritten);
	until (wrdNumRead = 0) or (wrdNumWritten <> wrdNumRead);

	Close(filFrom1);
	Close(filFrom2);
	Close(filTo);
end;


procedure tlkMoveFile(strFrom, strTo : string);

var
	filFileIn : text;

begin
	tlkCopyFile(strFrom, strTo);
	Assign(filFileIn, strFrom);
	{$I-}
	Erase(filFileIn);
	{$I+}
	tlkDosErr('Move File erase : ' + strFrom, IOResult);
end;


procedure tlkDelFile(strFrom: string; bolMustExist : boolean);

var
	filFileIn   : text;
	intIOResult : integer;

begin
	Assign(filFileIn, strFrom);
	{$I-}
	Erase(filFileIn);
	{$I+}
	intIOResult := IOResult;
	if not bolMustExist then
	begin
		if intIOResult <> 2 then tlkDosErr('Toolkit File erase',intIOResult);

	end
		else
	begin
		tlkDosErr('File erase : ' + strFrom, IOResult);
	end;
end;


procedure tlkMoveAll(strFromPath, strToPath : string);

var
	filFileIn   : text;
	dirInfo     : searchrec;

begin
	FindFirst(strFromPath + '\*.*', ARCHIVE, dirInfo);
	while DosError = 0 do
	begin
		tlkMoveFile(strFromPath + '\' + dirInfo.Name,
								strToPath + '\' + dirInfo.Name);
		FindNext(dirInfo);
	end;
end;


procedure tlkDelAll(strPath: string);

var
	filFileIn   : text;
	dirInfo     : searchrec;

begin
	FindFirst(strPath + '\*.*', ARCHIVE, dirInfo);
	while DosError = 0 do
	begin
		Assign(filFileIn, strPath + '\' + dirInfo.Name);
		{$I-}
		Erase(filFileIn);
		{$I+}
		tlkDosErr('Toolkit File erase', IOResult);

		FindNext(dirInfo);
	end;
end;


procedure tlkCreateDir(strNewDir: string);
{ Create Directory }

var
	regs      : registers;
	ntsNewDir : array[0..80] of char;

begin
	regs.AH := $39;
	StrPCopy(ntsNewDir, strNewDir);
	regs.DX := Ofs(ntsNewDir);
	regs.DS := Seg(ntsNewDir);
	MsDos(regs);
end;


function tlkKeyScan : integer;

var
	intKey : integer;

begin
	if tlkKeyPressed then
	begin
		intKey := Ord (tlkReadKey);
		If intKey = 0
		Then intKey := 256 + Ord (tlkReadKey);
		tlkKeyScan := intKey
	end
		else
	begin
		tlkKeyScan := 0;
	end;
end;


procedure tlkDosErr(strErrPos : string; intIOResult : integer);
{ If Dos error then halt & report it  else return }

var
	reg : registers;

begin
	If intIOResult <> 0 then
	begin
		Write(strErrPos + ' : ');
		case intIOResult of
			1 : WriteLn('SHARE.EXE not loaded');
			2 : WriteLn('File not found');
			3 : WriteLn('Path not found');
			4 : WriteLn('Path not found'); 
			5 : WriteLn('Access denied');
			6 : WriteLn('Invalid handle');
			8 : WriteLn('Not enough memory');
		 10 : WriteLn('Invalid environment');
		 11 : WriteLn('Invalid format');
		 18 : WriteLn('No more files');
		 33 : WriteLn('Lock Violation');
		100 : WriteLn('Disk read error');
		else
			WriteLn('Unknown IO error number ',intIOResult);
		end;
		Halt(intIOResult);
	end;
end;


procedure tlkTokenSplit(strToToken : string; chrToken : char;
												var strLeftFromToken, strRightFromToken : string);
{ Split a tokenised command in two }

var 
	bytTokenPos : byte;
	bytStrLen   : byte;

begin
	strRightFromToken[0] := #0;
	strLeftFromToken[0] := #0;
	bytStrLen := Length(strToToken);
	bytTokenPos := tlkLeftCPos(chrToken, strToToken);
	if (bytTokenPos > 0) and (bytStrLen > 1) then
	begin
		strLeftFromToken := Copy(strToToken, 1, bytTokenPos - 1);
		if bytStrLen >= 1 + bytTokenPos then
		begin
			strRightFromToken := Copy(strToToken, bytTokenPos + 1,
													 bytStrLen - bytTokenPos);
		end
	end
		else
	begin
		strLeftFromToken := strToToken;
		strRightFromToken := '';
	end;
end;


procedure tlkRightTokenSplit(strToToken : string; chrToken : char;
														 var strLeftFromToken, strRightFromToken : string);
{ Split a tokenised command in two }

var 
	bytTokenPos : byte;
	bytStrLen   : byte;

begin
	strRightFromToken[0] := #0;
	strLeftFromToken[0] := #0;
	bytStrLen := Length(strToToken);
	bytTokenPos := tlkRightCPos(chrToken, strToToken);
	if (bytTokenPos > 0) and (bytStrLen > 1) then
	begin
		strLeftFromToken := Copy(strToToken, 1, bytTokenPos - 1);
		if bytStrLen >= 1 + bytTokenPos then
		begin
			strRightFromToken := Copy(strToToken, bytTokenPos + 1,
													 bytStrLen - bytTokenPos);
		end
	end
		else
	begin
		strLeftFromToken := strToToken;
		strRightFromToken := '';
	end;
end;


function tlkInetAddr(strInet : namestring; bytCommandType : byte) : namestring;
{ Return an internet name }

var
	strInetName : string;
	strInetAddr : string;
begin
	tlkTokenSplit(strInet, '@', strInetName, strInetAddr);
	if bytCommandType = BAddr then 
	begin
		tlkInetAddr := strInetAddr;
	end
		else
	begin
		tlkTokenSplit(strInetName, '!', strInetName, strInetAddr);
		IF bytCommandType = BName 
			then tlkInetAddr := strInetName
			else tlkInetAddr := strInetAddr;
	end;
end;


function tlkStrLeft(strToStrip : string; bytLength : byte) : string;
{ string left function }
begin
	tlkStrLeft := Copy(strToStrip, Length(strToStrip) - bytLength, bytLength);
end;


function  tlkPadLinLeft(wrdToPad : longint; bytLength : byte; chrPadChar : char) : String;
{ Convert a word to string & left pad it }
var
	strFill   : string;
	strResult : string;
begin
	Str(wrdToPad:0, strResult);
	tlkPadLinLeft := tlkPadLeft(strResult, chrPadChar, bytLength);
end;


procedure tlkSwapLin(var linToSwap : longint);
{ Swap the Lo & Hi order words of a longint }
type PWord = ^TWord;
		 TWord = array [0..1] of word;

var ptrLin  : pointer;
		wrdTmp  : word;

begin
	ptrLin := @linToSwap;
	wrdTmp := PWord(ptrLin)^[0];
	PWord(ptrLin)^[0] := PWord(ptrLin)^[1];
	PWord(ptrLin)^[1] := wrdTmp;
end;


function tlkTimeString(bytMode : byte) : timestring;
{ Return time string }
var
	wrdHour      : word;
	wrdMin       : word;
	wrdSec       : word;
	wrdHund      : word;

begin
	GetTime(wrdHour, wrdMin, wrdSec, wrdHund);
	if bytMode = BTimeLong 
		then tlkTimeString := tlkPadLinLeft(wrdHour,2,'0') + ':' +
													tlkPadLinLeft(wrdMin,2,'0') + ':' +
													tlkPadLinLeft(wrdSec,2,'0')
		else tlkTimeString := tlkPadLinLeft(wrdHour,2,'0') + ':' +
													tlkPadLinLeft(wrdMin,2,'0') + ':'
end;


function tlkDateString : datestring;
{ Return date string }
var
	wrdYear      : word;
	wrdMonth     : word;
	wrdDay       : word;
	wrdDayOfWeek : word;

begin
	GetDate(wrdYear, wrdMonth, wrdDay, wrdDayOfWeek);
	tlkDateString := tlkPadLinLeft(tlkYearOnly(wrdYear),2,'0') + '-' +
									 tlkPadLinLeft(wrdMonth,2,'0') + '-' +
									 tlkPadLinLeft(wrdDay,2,'0')
end;


function tlkDayOfWeek : byte;
{ Return date string }
var
	wrdYear      : word;
	wrdMonth     : word;
	wrdDay       : word;
	wrdDayOfWeek : word;

begin
	GetDate(wrdYear, wrdMonth, wrdDay, wrdDayOfWeek);
	tlkDayOfWeek := wrdDayOfWeek;
end;


function tlkMinutesToday : integer;
{ Return total number of minutes today }

var
	recDateTime : datetime;
	wrdDummy    : word;

begin
	with recDateTime do 
	begin
		GetTime(Hour, Min, Sec, wrdDummy);
		tlkMinutesToday := (Hour * 60) + Min;
	end;
end;


function tlkMinutes(linPackDate : longint) : integer;
{ Get the total number if minutes in packed time }

var
	recDateTime : datetime;

begin
	UnpackTime(linPackDate, recDateTime);
	with recDateTime do tlkMinutes := (Hour * 60) + Min;
end;


function tlkDateTimePack : longint;
{ Return date string }
var
	recDateTime : datetime;
	wrdDummy    : word;
	linDateTime : longint;

begin
	with recDateTime do 
	begin
		GetDate(Year, Month, Day, wrdDummy);
		GetTime(Hour, Min, Sec, wrdDummy);
	end;
	PackTime(recDateTime, linDateTime);
	tlkDateTimePack := linDateTime;
end;


function tlkNoPrefix(strName : string) : string;
{ Return name without prefix }

var
	strNoPrefix : string;
	strPrefix   : string;

begin
	strNoPrefix := '';
	if (strName <> '') and (tlkLeftCPos(' ', strName) <> 0) then
	begin
		repeat
			tlkTokenSplit(strName, ' ', strPrefix, strName);
			if Pos('*' + tlkUpper(strPrefix) + '*', SPrefixes) = 0	then
			begin
				if strNoPrefix = ''
					then strNoPrefix := strPrefix
					else strNoPrefix := strNoPrefix + ' ' + strPrefix;
			end;
		until tlkLeftCPos(' ', strName) = 0;
	end;
	if strNoPrefix = ''
		then strNoPrefix := strName
		else strNoPrefix := strNoPrefix + ' ' + strName;
	tlkNoPrefix := strNoPrefix;
end;


function tlkPrefix(strName : string) : string;
{ Return prefix of name}

var
	strPrefix   : string;
	strPrefixes : string;

begin
	strPrefixes := '';
	if (strName <> '') and (tlkLeftCPos(' ', strName) <> 0) then
	begin
		repeat
			tlkTokenSplit(strName, ' ', strPrefix, strName);
			if Pos('*' + tlkUpper(strPrefix) + '*', SPrefixes) <> 0	then
			begin
				if strPrefixes = ''
					then strPrefixes := strPrefix
					else strPrefixes := strPrefixes + ' ' + strPrefix;
			end;
		until tlkLeftCPos(' ', strName) = 0;
	end;
	tlkPrefix := tlkLower(strPrefixes);
end;


function tlkFormatName(strName : string) : string;
{ Convert every first letter in a name to uppercase, rest lowercase }

var
	intPos : integer;

begin
	if strName <> '' then
	begin
		strName[1] := tlkUpcase(strName[1]);
		for intPos := 2 to Length(strName) do
		begin
			if strName[intPos - 1] in [' ', '-'] then
			begin
				strName[intPos] := tlkUpcase(strName[intPos]);
			end
				else
			begin
				if strName[intPos] in ['A'..'Z']
					then strName[intPos] := Char(32 + Ord(tlkUpCase(strName[intPos])));
			end;
		end;
	end;
	tlkFormatName := strName;
end;


function tlkDateOnly(strDateTime : string) : datestring;
{ Get date only }
var
	strLeft  : string;
	strRight : string;
begin
	tlkTokenSplit(strDateTime, ' ', strLeft, strRight);
	tlkDateOnly := strLeft;
end;


function tlkTimeOnly(strDateTime : string) : timestring;
{ Get time only }
var
	strLeft  : string;
	strRight : string;
begin
	tlkTokenSplit(strDateTime, ' ', strLeft, strRight);
	if strRight = '' then
	begin
		tlkTimeOnly := strLeft;
	end
		else
	begin
		tlkTimeOnly := tlkStrip(strRight, ' ', BStripLeft);
	end;
end;


function tlkIncDate(strISODate : datestring; intOffset : integer) : datestring;
{ Return the date after an offset }

var
	strTmp        : string[2];
	strResult     : datestring;
	intYear       : integer;
	intMonth      : integer;
	intDay        : integer;
	intCode       : integer;
	intNewDay     : integer;
	intStartDay   : integer;
	intYearLength : integer;

begin
	Val(Copy(strISODate, 1, 2), intYear, intCode);
	Val(Copy(strISODate, 4, 2), intMonth, intCode);
	Val(Copy(strISODate, 7, 2), intDay, intCode);

	{ Check for leap year }
	if (intYear <> 0) and (intYear MOD 4 = 0) 
		then intYearLength := 366
		else intYearLength := 365;

	{ Calculate day of year }
	if intYearLength = 365 then
	begin
		intStartDay := ARRNormMonthOffs[intMonth] + intDay;
	end
		else
	begin
		intStartDay := ARRLeapMonthOffs[intMonth] + intDay;
	end;

	{ Add offset }
	intNewDay   := intStartDay + intOffset;

	{ Check for next year }
	if intNewDay > intYearLength then
	begin
		Inc(intYear);
		if intYear = 100 then intYear := 0;
		intNewDay := intNewDay - intYearLength;
	end;

	if intYearLength = 365 then
	begin

		{ Calculate new month }
		intMonth := 1;
		while intNewDay > ARRNormMonthOffs[intMonth + 1] do Inc(intMonth);

		{ Calculate Day }
		intDay := intNewDay - ARRNormMonthOffs[intMonth];

	end
		else
	begin

		{ Calculate new month }
		intMonth := 1;
		while intNewDay > ARRLeapMonthOffs[intMonth + 1] do Inc(intMonth);

		{ Calculate Day }
		intDay := intNewDay - ARRLeapMonthOffs[intMonth];

	end;

	strTmp := tlkPadLinLeft(intYear, 2, '0');
	strResult := strTmp;
	strTmp := tlkPadLinLeft(intMonth, 2, '0');
	strResult := strResult + '-' + strTmp;
	strTmp := tlkPadLinLeft(intDay, 2, '0');
	strResult := strResult + '-' + strTmp;

	tlkIncDate := strResult;

end;


function tlkReformatDate(strDate, strFromFormat, strToFormat : datestring) : datestring;
{ reformat date for stupid fucking shit programs not conforming to european standard }
var
	strLeft       : datestring;
	strRight      : datestring;
	strNewDate    : datestring;
	strResult     : datestring;
	bytFromDay    : byte;
	bytFromMonth  : byte;
	bytFromYear   : byte;
	chrToToken    : char;
	chrSplitToken : char;

begin
	{ Convert date to leading zero's of needed }
	if Length(strDate) < 8 then
	begin
		chrSplitToken := strFromFormat[3];
		tlkTokenSplit(strDate, chrSplitToken, strLeft, strRight);
		strNewDate := tlkPadLeft(strLeft, '0', 2);
		tlkTokenSplit(strRight, chrSplitToken, strLeft, strRight);
		strNewDate := strNewDate + chrSplitToken + tlkPadLeft(strLeft, '0', 2) +
									chrSplitToken + tlkPadLeft(strRight, '0', 2);
		strDate := strNewDate;
	end;

	{ Get new dividing token }
	chrToToken   := strToFormat[3];

	strFromFormat := tlkUpper(strFromFormat);
	strToFormat   := tlkUpper(strToFormat);

	{ Get from format splitted }
	if Copy(strFromFormat, 1, 2) = 'DD' then
	begin
		bytFromDay := 1;
		if Copy(strFromFormat, 4, 2) = 'MM' then
		begin
			bytFromMonth := 4;
			bytFromYear  := 7;
		end
			else
		begin
			bytFromYear  := 4;
			bytFromMonth := 7;
		end
	end
	else if Copy(strFromFormat, 1, 2) = 'MM' then
	begin
		bytFromMonth := 1;
		if Copy(strFromFormat, 4, 2) = 'DD' then
		begin
			bytFromDay   := 4;
			bytFromYear  := 7;
		end
			else
		begin
			bytFromYear  := 4;
			bytFromDay   := 7;
		end
	end
	else
	begin
		bytFromYear := 1;
		if Copy(strFromFormat, 4, 2) = 'DD' then
		begin
			bytFromDay   := 4;
			bytFromMonth := 7;
		end
			else
		begin
			bytFromMonth := 4;
			bytFromDay   := 7;
		end
	end;

	{ Get to format splitted }
	if Copy(strToFormat, 1, 2) = 'DD' then
	begin
		strResult := Copy(strDate, bytFromDay, 2) + chrToToken;
		if Copy(strToFormat, 4, 2) = 'MM' then
		begin
			strResult := strResult + Copy(strDate, bytFromMonth, 2) + chrToToken
														 + Copy(strDate, bytFromYear,  2);
		end
			else
		begin
			strResult := strResult + Copy(strDate, bytFromYear,  2) + chrToToken
														 + Copy(strDate, bytFromMonth, 2);
		end
	end
	else if Copy(strToFormat, 1, 2) = 'MM' then
	begin
		strResult := Copy(strDate, bytFromMonth, 2) + chrToToken;
		if Copy(strToFormat, 4, 2) = 'DD' then
		begin
			strResult := strResult + Copy(strDate, bytFromDay,  2) + chrToToken
														 + Copy(strDate, bytFromYear, 2);
		end
			else
		begin
			strResult := strResult + Copy(strDate, bytFromYear, 2) + chrToToken
														 + Copy(strDate, bytFromDay,  2);
		end
	end
	else
	begin
		strResult := Copy(strDate, bytFromYear, 2) + chrToToken;
		if Copy(strToFormat, 4, 2) = 'MM' then
		begin
			strResult := strResult + Copy(strDate, bytFromMonth, 2) + chrToToken
														 + Copy(strDate, bytFromDay,   2);
		end
			else
		begin
			strResult := strResult + Copy(strDate, bytFromDay,   2) + chrToToken
														 + Copy(strDate, bytFromMonth, 2);
		end
	end;

	tlkReformatDate := strResult;

end;


function tlkNoSeconds(strTime : timestring) : timestring;
{ Return the time string without seconds }

var
	strResult : timestring;

begin
	if Length(strTime) = 5
		then strResult := strTime
		else strResult := Copy(strTime, 1, 5);
	tlkNoSeconds := strResult;
end;


function tlkNextSerial(strCurrNum : serialnumstring; bytCommand : byte) : serialnumstring;
{ Return next serial number }

var
	bolRest    : boolean;
	bytNewOrd  : byte;
	bytPos     : byte;

begin
	{ Error checking }
	if Length(strCurrNum) <> 8 then
	begin
		WriteLn('Not a Serial number');
		Halt(100);
	end;

	{ Set vars }
	bolRest := FALSE;
	bytPos  := 8;

	{ Loop through string }
	if bytCommand = BLong then
	begin
		repeat
			if strCurrNum[bytPos] = 'Z' then
			begin
				strCurrNum[bytPos] := '0';
				bolRest := TRUE;
			end
				else
			begin
				bytNewOrd := Ord(strCurrNum[bytPos]) + 1;
				if bytNewOrd = 58 then bytNewOrd := 65;
				strCurrNum[bytPos] := Chr(bytNewOrd);
				bolRest := FALSE;
			end;
			Dec(bytPos);
		until (not bolRest) or (bytPos = 0);
	end
		else
	begin
		repeat
			if strCurrNum[bytPos] = '9' then
			begin
				strCurrNum[bytPos] := '0';
				bolRest := TRUE;
			end
				else
			begin
				bytNewOrd := Ord(strCurrNum[bytPos]) + 1;
				strCurrNum[bytPos] := Chr(bytNewOrd);
				bolRest := FALSE;
			end;
			Dec(bytPos);
		until (not bolRest) or (bytPos = 0);
	end;

	{ Return result }
	tlkNextSerial := strCurrNum;
end;


function tlkFileNextSerial(strSerialFile : string; bytCommand : byte) : serialnumstring;
{ Get serial num out of file & then increment & update it }

var
	filSerial   : file of serialnumstring;
	strSerial   : serialnumstring;
	intIOResult : integer;

begin
	Assign(filSerial, strSerialFile);
	FileMode := 2;
	intIOResult := 33;
	while intIOResult = 33 do
	begin
		{$I-}
		Reset(filSerial);
		{$I+}
		intIOResult := IOResult;
	end;
	if intIOResult <> 0 then
	begin
		Rewrite(filSerial);
		strSerial := '00000000';
		Write(filSerial, strSerial);
	end
		else
	begin
		{$I-}
		Read(filSerial, strSerial);
		{$I+}
		tlkDosErr('ID read',IOResult);
		Close(filSerial);
		Rewrite(filSerial);
		strSerial := tlkNextSerial(strSerial, bytCommand);
		Write(filSerial, strSerial);
	end;
	Close(filSerial);
	tlkFileNextSerial := strSerial;
end;


function tlkFormatInitials(strInitials : string) : string;
{ Format intials conform NEN-1888 }

var
	strLeft   : string;
	strRight  : string;
	strResult : string;

begin
	strResult := '';
	strRight  := strInitials;
	if tlkLeftCPos('.', strInitials) <> 0 then
	begin
		repeat
			tlkTokenSplit(strRight, '.', strLeft, strRight);
			if strLeft <> '' then strResult := strResult + tlkUpCase(strLeft[1]);
		until strLeft = '';
	end
		else
	begin
		strResult := tlkUpper(strInitials);
	end;
	tlkFormatInitials := strResult;
end;


procedure Init;

var
	chrToDo : char;
	bytCode : byte;

begin

	{ Init custom case conversion tables }
	for chrToDo := chr(0) TO chr(255) do 
	begin
		UpperTbl[chrToDo] := chrToDo;
		LowerTbl[chrToDo] := chrToDo;
	end;

	for chrToDo := chr(0) to chr(255) do
	begin
		if UpCase(chrToDo) <> chrToDo then 
		begin
			LowerTbl[UpCase(chrToDo)] := chrToDo;
			UpperTbl[chrToDo] := UpCase(chrToDo);
		end;
	end;

	for bytCode := 1 to Length(SLoCase[1]) do
	begin
		LowerTbl[SLoCase[1][bytCode]] := SLoCase[2][bytCode];
		UpperTbl[SUpCase[1][bytCode]] := SUpCase[2][bytCode];
	end;
end;


procedure tlkSound(Hz:Word); assembler;
{ Sound replacement for CRT }
 asm
			MOV  BX,Hz
			MOV  AX,34DDH
			MOV  DX,0012H
			CMP  DX,BX
			JNC  @DONE
			DIV  BX
			MOV  BX,AX
			IN   AL,61H
			TEST AL,3
			JNZ  @99
			OR   AL,3
			OUT  61H,AL
			MOV  AL,0B6H
			OUT  43H,AL
@99:  MOV  AL,BL
			OUT  42H,AL
			MOV  AL,BH
			OUT  42H,AL
@DONE:
end;


procedure tlkNoSound; assembler;
{ NoSound replacement for CRT }
asm
	 IN   AL, $61
	 AND  AL, $FC
	 OUT  $61, AL
end;


procedure tlkDelay(ms : word); assembler;
asm {machine independent Delay Function}
	mov ax, 1000;
	mul ms;
	mov cx, dx;
	mov dx, ax;
	mov ah, $86;
	int $15;
end;


function tlkReadKey : char; assembler;
{ CRT ReadKey replacement }
asm
	mov ah, 00h
	int 16h
end;


function tlkKeyPressed : boolean; assembler;
{ CRT KeyPressed replacement }
asm
	mov ah, 01h
	int 16h
	mov ax, 00h
	jz  @1
	inc ax
	@1:
end;


begin
	Init;
end.
