{

                                                      ͻ
                                                          PTUI Text     
                                                          Mouse Unit    
                                                          Rev.  1.00    
                                                      ͼ

}

{$F+} {$O-} {$A+} {$G+}
{$V-} {$B-} {$X-} {$N+} {$E+}

{$I FINAL.PAS}

{$IFDEF FINAL}
  {$I-} {$R-}
  {$D-} {$L-} {$S-}
{$ENDIF}

Unit PTUIMSE;

Interface

Uses CRT,Dos,PTUIMDef;

Procedure Init         (Installed:Boolean);
Procedure Show;
Procedure Hide;
Procedure SetSpeed     (Mousems:Byte);
Procedure SetXY        (X,Y:Word);
Procedure SetBounds    (X1,Y1,X2,Y2:Word);
Procedure GetPresses   (Var X,Y:Word;Var Button:Byte;Var Held:Boolean;
                        Var NumTimes:Word);
Procedure GetXY        (Var X,Y:Word);
Procedure GetStatus    (Var X,Y:Word;Var Left,Right,Middle:Boolean);
Procedure GetClick     (Var X1, Y1, X2, Y2:Word; Var MouseButton:Byte;
                        Var Held,Doubled:Boolean);


Implementation

Var
  OldMouseChar:Word;

Procedure Init(Installed:Boolean);
Begin
  If Not Installed Then
    Installed:=False
  Else
  Asm
    xor   ax, ax
    int   33h
    and   ax, 1         {ax = $FFFF if installed, Else 0}
    mov   Installed, al
  End;
  Active:=Installed;
  If Installed Then SetSpeed(25);
End;

Procedure Show; Assembler;

{ ͻ }
{   Show mouse on screen.                                                  }
{ ͼ }

Asm
  mov ax, 1
  int 33h
End;

Procedure Hide; Assembler;

{ ͻ }
{   Mouse still active but hidden, not on screen.                          }
{ ͼ }

Asm
  mov ax, 2
  int 33h
End;

Procedure SetSpeed(Mousems:Byte);

{ ͻ }
{   Sets up the ComputerSpeed variable for mouse double click speed.       }
{ ͼ }

Var
   MBC       :0..2;
   H,M,S,S100:Word;
   LoopAmount,
   Counter,
   Total100b,
   Total100  :LongInt;
   Regs      :Registers;
   C         :Char;
   Fraction  :Real;

Begin
  If Not Active Then
  Begin
    ComputerSpeed:=1000;
    Exit;
  End;

  LoopAmount:=9000;
  Repeat
    Inc(LoopAmount,1000);
    GetTime(H,M,S,S100);
    Total100:=S100;
    Inc(Total100,S*100);
    Inc(Total100,LongInt(M)*60*100);
    Inc(Total100,LongInt(H)*60*60*100);
    MBC:=0;
    For Counter:=1 to LoopAmount do
    Begin                                   {Waste Time Approx time for Mouse Check}
      Regs.AX:=5;
      Regs.BX:=MBC;
      Intr($33,Regs);
      If MBC=2 Then MBC:=0 Else Inc(MBC);
      If (Regs.BX<>0) Then ;                {The Until Equivalent}
      If KeyPressed Then C:=ReadKey;
    End;
    GetTime(H,M,S,S100);
    Total100b:=S100;
    Inc(Total100b,S*100);
    Inc(Total100b,LongInt(M)*60*100);
    Inc(Total100b,LongInt(H)*60*60*100);

    If LoopAmount>2100000000 Then
    Begin
      WriteLn('Unable to set Mouse Double Click Timer.');
      Halt(0);
    End;
  Until (Total100b>Total100+10);

  Total100:=Total100b-Total100;   {Time Taken to do loop}
  Fraction:=Mousems/Total100;     {We want time to be Mousems ms}
  ComputerSpeed:=Round(Fraction*LoopAmount);
End;

Procedure SetXY(X,Y:Word); Assembler;

{ ͻ }
{   Mouse the mouse to a VGA co-ordinate on the screen.                    }
{ ͼ }

Asm
  mov  ax,4
  mov  cx,X
  mov  dx,Y
  int  33h
End;

Procedure SetBounds(X1,Y1,X2,Y2:Word); Assembler;

{ ͻ }
{   Lock the mouse in a rectangle of the screen.                           }
{ ͼ }

Asm
  mov  ax,7
  mov  cx,X1
  mov  dx,X2
  int  33h
  mov  ax,8
  mov  cx,Y1
  mov  dx,Y2
  int  33h
End;

Procedure GetPresses(Var X,Y:Word;Var Button:Byte;Var Held:Boolean;Var NumTimes:Word); Assembler;

{ ͻ }
{                                                                          }
{  Returns the Co-Ordinate of Last Button Press For Buttons.               }
{  Returns which button was pressed (0..2) or 255 if no button has been    }
{  pressed.                                                                }
{  Returns Held True if the button is still being held down.               }
{                                                                          }
{ ͼ }

Label EndOfCheck,NotHeld,NoButtons,EndOfSub,
      Button0,Button1,Button2,VeryEndOfSub;

Asm
  mov  ax,5
  mov  bx,0
  mov  si,1
  int  33h
  cmp  bx,0             {Test Button 0}
  jne  EndOfCheck

  mov  ax,5
  mov  bx,1
  mov  si,2
  int  33h
  cmp  bx,0             {Test Button 1}
  jne  EndOfCheck

  mov  ax,5
  mov  bx,2
  mov  si,4
  int  33h
  cmp  bx,0             {Test Button 2}
  jne  EndOfCheck

  jmp  NoButtons

EndOfCheck:

  les  di,NumTimes
  mov  es:[di],bx
  les  di,X
  mov  es:[di],cx
  les  di,Y
  mov  es:[di],dx

  les  di,Held
  and  ax,si
  cmp  ax,0
  je   NotHeld

  mov  al,1
  jmp  EndOfSub

NotHeld:

  mov  al,0
  jmp  EndOfSub

NoButtons:

  mov  si,0
  mov  ax,0
  les  di,NumTimes
  mov  es:[di],ax
  les  di,X
  mov  es:[di],ax
  les  di,Y
  mov  es:[di],ax
  les  di,Held
  mov  al,0

EndOfSub:

  mov  es:[di],al       {Move value into Held}

  les  di,Button
  cmp  si,1
  je   Button0
  cmp  si,2
  je   Button1
  cmp  si,4
  je   Button2

  mov  al,0ffh            {No Button}

  jmp  VeryEndOfSub

Button0:

  mov  al,0
  jmp  VeryEndOfSub

Button1:

  mov  al,1
  jmp  VeryEndOfSub

Button2:

  mov  al,2

VeryEndOfSub:

  mov  es:[di],al               {Move a value into Button}

End;

Procedure GetXY(Var X,Y:Word); Assembler;
Asm
  mov  ax,3
  int  33h
  les  di,X
  mov  es:[di],cx
  les  di,Y
  mov  es:[di],dx
End;

Procedure GetStatus(Var X,Y:Word;Var Left,Right,Middle:Boolean); Assembler;
Asm
  mov  ax,3
  int  33h
  les  di,X
  mov  es:[di],cx
  les  di,Y
  mov  es:[di],dx

  mov  ax,bx
  and  ax,1
  les  di,Left
  mov  es:[di],al

  mov  ax,bx
  and  ax,2
  shr  ax,1
  les  di,Right
  mov  es:[di],al

  mov  ax,bx
  and  ax,4
  shr  ax,1
  shr  ax,1
  les  di,Middle
  mov  es:[di],al
End;

Procedure GetClick(Var X1, Y1, X2, Y2:Word;
                   Var MouseButton:Byte;
                   Var Held,Doubled:Boolean);

{ ͻ }
{   Return the VGA co-ordinate of the mouse once a key or mouse button     }
{   has been pressed.  Double set True for a Double Click.                 }
{   Also returns which button is being pressed or held.                    }
{ ͼ }

Var
  Button2    :Byte;
  NumPresses :Word;
  X          :LongInt;
  HeldA,
  HeldB,
  HeldC      :Boolean;

Begin
  Doubled:=False;
  Held:=False;

  If Active Then
  Begin
    Repeat
      GetPresses(X1,Y1,MouseButton,Held,NumPresses);
    Until (MouseButton<>255) Or KeyPressed;

    X:=0;
    Repeat
      GetPresses(X2,Y2,Button2,Held,NumPresses);
      Inc(X);
    Until (Button2<>255) Or KeyPressed Or (X>ComputerSpeed);

    If (X<=ComputerSpeed) Then
      Doubled:=True
    Else
    Begin
      GetStatus(X2,Y2,HeldA,HeldB,HeldC);
      Held:=HeldA Or HeldB Or HeldC;
      X2:=0;             {No Double Click}
      Y2:=0;
    End;
  End
  Else  {No Mouse}
  Begin
    X1:=0;
    Y1:=0;
    X2:=0;
    Y2:=0;
    Doubled:=True;
    MouseButton:=1;
  End;
  If Doubled Then Held:=False;
End;

End.

{ Copyright 1993, Michael Gallias }
