Async Professional 2.0 (Pascal) Product Information
---------------------------------------------------
Async Professional is a powerful, easy to use asynchronous
communications library that will help you get your comm applications
working fast. Async Professional uses a layered architecture that
provides both object-oriented and traditional procedural interfaces.
It supports all industry standard file transfer protocols including
ZMODEM. It also provides comprehensive fax support for Class 1, Class
2, and CAS faxmodems. Also included is an event logging and tracing
facility that makes debugging your application easy.

A Layered Communications Architecture
-------------------------------------
The layered architecture separates the specifics of a particular
communications device from the application program interface. The
abstract layer defines the standard data and core procedures that all
comm ports will support.

The device layer implements the core procedures for a specific device.
Async Professional provides four device layers: one that works with
all standard PC UART (universal asynchronous receiver/transmitter)
chips, one that uses the BIOS interrupt 14H services, one that
interacts with a FOSSIL driver, and one that controls multi-port
DigiBoard boards. Because the abstract layer has a well-defined
interface, you can also write your own device layers to support
non-standard devices such as network modem servers.

Applications call the routines in the interface layer, which transfers
the requests to the appropriate device layer routines. By working
through the interface layer, your application will automatically
support any new devices without change. Async Professional provides
two interface layers -- object-oriented and procedural. You can choose
either programming style depending on which Pascal compiler you have
and your personal preference.

Async Professional's higher level facilities for file transfer, modem
control, etc., call the interface layer and are also provided in both
OOP and non-OOP styles.

Fast and Flexible UART Control
------------------------------
Async Professional provides interrupt-driven, buffered I/O at speeds
up to 115K baud on an 8MHz IBM AT. The interrupt handler supports
optional automatic hardware handshaking (CTS/RTS and DTR/DSR) and
software flow control (XON/XOFF).

Async Professional supports COM1-COM4 for PC compatibles, and
COM1-COM8 for PS/2 machines. Up to four ports can be open
simultaneously (subject to the hardware limitations of the standard PC
buss). Interrupt (IRQ) sharing is supported for the micro-channel
PS/2. Async Professional takes advantage of the 16550 buffered UART
during receives.

You can activate a status buffer that is updated at the same time as
the receive data buffer. When line errors occur, you'll then know
exactly how much of the data is affected.

The Protocols You Need, Including ZMODEM
----------------------------------------
Async Professional includes ZMODEM, the most powerful general purpose
protocol available. It automatically adjusts packet sizes and can
resume aborted file transfers from the point where they stopped. Async
Professional also includes the XMODEM/YMODEM family of protocols
(including the CRC, 1K, and G variants). It also provides the Kermit
protocol, which is especially useful for transfers to mini-computers
and mainframes, many of which have Kermit drivers already available.
The supplied protocols are designed so that they can be run in the
background.

Comprehensive Fax Support
-------------------------
Async Professional gives you tools to convert text, PCX, DCX, TIFF,
and PCL files to fax format, to send and receive faxes using Class 1,
Class 2, or CAS faxmodems, to convert fax files to PCX format, and to
view or print fax files. Includes demo programs for all of these
functions, including a background fax receive TSR, a foreground
program that multiplexes between receiving and printing faxes, and a
fax control center with a handy mouse driven interface for converting
files, queueing fax transmissions, and viewing or printing received
faxes.

Powerful Debugging Tools Help You Finish Faster
-----------------------------------------------
Event logging creates a time-stamped audit trail of all serial
interrupts as your application runs. Tracing creates a report of all
the characters sent and received by your program. With tools like
these you can forget the old breakout box and debug communication
problems more quickly than ever.

Terminal Emulation Support Tools
--------------------------------
Async Professional's ANSI interpreter decodes escape sequences to
perform standard CRT operations. An object-oriented ANSI emulator
gives you complete control over the actions that occur whenever a
particular ANSI command is received.

Async Professional provides a modem unit that makes it easy to control
and receive responses from Hayes-compatible modems, and also includes
support for V.32, HST 9600, and MNP level 5 modems.

Compression Tools for ZIP and LZH Access
------------------------------------------
Async Professional includes modules for compressing and decompressing
archive files stored in the ZIP and LZH formats. Now your programs can
access these files without shelling out to DOS. Compression supports
all PKZIP 2.0 and LHA 2.0 formats.

Example Programs Get You Up to Speed Fast
-----------------------------------------
Async Professional includes several full-featured demonstration
programs and many small example programs to illustrate the proper use
of each routine. A simple, general-purpose terminal program uses only
the functions of Async Professional to demonstrate comm port and modem
control, ANSI emulation, and file transfer protocols. Another
demonstration shows how to use Async Professional with Object
Professional -- this program has a friendly, modern user interface
including mouse support, pull-down menus, and a text editor for
message composition. (You must own Object Professional to change or
recompile this program.) A TerminalWindow object derived from Object
Professional's CommandWindow hierarchy lets you easily add a
communications window to your program.

Professional Documentation and Technical Support
------------------------------------------------
You get complete printed documentation, pop-up help from an 8K TSR,
and accurate CompuServe and telephone support directly from the
authors. Async Professional includes complete source code. You pay no
royalties for your finished applications.

Uses for Async Professional
---------------------------
  o instrumentation data acquisition
  o plotter and printer drivers
  o terminal emulators
  o BBS development
  o micro to mini data transfer
  o long-distance file transfer
  o distributed data storage without a LAN
  o general-purpose communications programs
  o fax-intensive business applications

Feature List
---------------------------
  o interrupt driven buffered I/O to 115K baud
  o ZMODEM, Kermit, XMODEM, YMODEM protocols
  o fax send and receive on Class 1, Class 2, and CAS faxmodems
  o OOP and procedural calling interfaces
  o automatic flow control - XON/XOFF, CTS/RTS, DTR/DTS
  o COM1-COM8 support with up to 4 ports open at once
  o 16550 buffered UART support
  o hardware interrupt sharing on PS/2 machines
  o direct UART and BIOS-level device layers
  o user-extensible device layers
  o ANSI terminal emulation
  o modem control including Hayes, V.32, V.42, and MNP5
  o timer management functions
  o trace and event logging facilities
  o introductory and sophisticated demo programs
  o popup help database
  o complete source code
  o free technical support
  o no royalties

Price and Shipping Info
-----------------------
Async Professional 2.0 requires Turbo Pascal 6.0 or 7.0. When using
Borland Pascal 7.0, Async Professional supports DOS real mode and DOS
protected mode applications, and the library can optionally be used in
DLL format. PC-DOS or MS-DOS 3.0 or later and an IBM AT, PS/2, or
compatible are required.

The list price for Async Professional is $199. Version 2.0 is
available for immediate shipment. Upgrades from earlier Async
Professional versions are available for $79 plus shipping.

TurboPower Software offers the Electronic Maintenance System, which
delivers maintenance updates at no charge other than the cost of a
download. More information about the EMS is available in the file
UPDATE.TXT.

For more information, or to order, call 1-800-333-4160 from 9 a.m. to
5 p.m. Mountain time, or write to TurboPower Software, P.O. Box 49009,
Colorado Springs, CO 80949. International customers call 719-260-9136.
Send faxes to 719-260-7151. Send CompuServe mail to 76004,2611. Visit
our CompuServe area in PCVENB section 6. We accept MasterCard, Visa,
American Express, Discover, a check in U.S. funds drawn on a U.S.
bank, or COD (within U.S. only).

  Version 2.0
  3.5" media only
  Weight 3.0 pounds
  Price $199 plus shipping
      FedEx Economy   $10     U.S. only                 (2 days)
      Airmail          $5     U.S. only                 (3-10 days)
      Airmail         $10     Canada only               (3-10 days)
      Airmail         $20     Elsewhere                 (7-21 days)
