Unit SObj2;

Interface

Uses Graph;

Const
  BackGroundColor=0;

Type

  TsAttr=record
    X,Y,W,H:Word;
    Style:Word;
    OldX,OldY,OldW,OldH:Word;
    FrameThick:Byte;
    Color,FrameColor,DisplayColor,TitleColor,MaxColor:Byte;
  End;

  PsObject=^TsObject;
  TsObject=object
    HWindow:Word;
    Constructor Init;
    Destructor Done; virtual;
    Procedure SetUpWindow; virtual;
  End;

  PsLinkedList=^TsLinkedList;
  TsLinkedList=record
    Next,Previous:PsLinkedList;
    Current:PsObject;
  End;

  PsCollection=^TsCollection;
  TsCollection=object(TsObject)
    List:PsLinkedList;
    NextHandle:Word;
    Constructor Init;
    Destructor Done; virtual;
    Function Insert(sObject:PsObject):Word; virtual;
    Function Delete(sHWindow:Word):Integer; virtual;
    Function RetrieveFirst:PsObject; virtual;
    Function RetrieveNext:PsObject; virtual;
  End;

Implementation

(* TsObject Methods *)

  Constructor TsObject.Init;
    Begin
    End;

  Destructor TsObject.Done;
    Begin
    End;

  Procedure TsObject.SetUpWindow;
    Begin
    End;

(* TsCollection Methods *)

  Function TsCollection.RetrieveFirst:PsObject;
    Begin
      While List^.Previous<>nil Do
        List:=List^.Previous;
      RetrieveFirst:=List^.Current;
    End;

  Function TsCollection.RetrieveNext:PsObject;
    Begin
      If List^.Next<>nil Then List:=List^.Next;
      RetrieveNext:=List^.Current;
    End;

  Constructor TsCollection.Init;
    Begin
      New(List);
      List^.Next:=nil;
      List^.Previous:=nil;
      List^.Current:=nil;
      NextHandle:=1;
    End;

  Destructor TsCollection.Done;
    Begin
      While List^.Previous<>nil Do
        Begin
          List:=List^.Previous;
          Dispose(List^.Next);
        End;
      Dispose(List);
    End;

  Function TsCollection.Insert(sObject:PsObject):Word;
    Var
      Temp:PsLinkedList;

    Begin
      While List^.Next<>nil Do
        List:=List^.Next;
      List^.Current:=sObject;
      New(List^.Next);
      Temp:=List;
      List:=List^.Next;
      List^.Previous:=Temp;
      List^.Next:=Nil;
      List^.Current:=Nil;
      Insert:=NextHandle;
      Inc(NextHandle);
    End;

  Function TsCollection.Delete(sHWindow:Word):Integer;
    Var
      Temp:PsLinkedList;
      t:Word;

    Begin
      Delete:=sHWindow;
      While List^.Previous<>nil Do
        List:=List^.Previous;
      For t:=1 To sHWindow-1 Do
        Begin
          If List^.Next<>nil Then
            List:=List^.Next
          Else
            Begin
              Delete:=-1;
              Exit;
            End;
        End;
      Temp:=List^.Next;
      If List^.Next<>nil Then
        List^.Next^.Previous:=List^.Previous;
      If List^.Previous<>nil Then
        List^.Previous^.Next:=Temp;
      If List^.Next=nil Then
        Temp:=List^.Previous
      Else
        Temp:=List^.Next;
      Dispose(List);
      Dec(NextHandle);
      List:=Temp;
      While List^.Next<>nil Do
        Begin
          List^.Current^.HWindow:=List^.Current^.HWindow-1;
          List:=List^.Next;
        End;
    End;


End.