{ HEXBYTE.PAS }
{ This demonstration illustrates the use of TP&Asm and Turbo Pascal  }
{ to develop and verify an assembly language procedure intended for  }
{ stand-alone assembly.  The assembly code at 'Hexbyte:' returns     }
{ (in AX) a Word containing the 2-byte Ascii representation of the   }
{ byte value passed to it in Al.  Use Pascal to Call Hexbyte (via    }
{ the Pascal function TestHexByte) and print the result for every    }
{ possible input value.                                              }
{ HEXBYTE.PAS }


{ TestHexByte }
{  Pascal Function containing the code to be tested.                 }
{ TestHexByte }
FUNCTION TestHexByte(SourceByte: BYTE): INTEGER;
{- In the assembly routine it will be convenient to get the -}
{- parameter from Al and to leave the Result in Ax.         -}
CONST
  HexDigits: ARRAY[0..15] OF CHAR = '0123456789ABCDEF';

BEGIN

Assemble

  Mov Al,SourceByte  ; Get parameter
  Call HexByte       ; Call ASSEMBLY procedure
  Mov TestHexByte,Ax ; Put in TestHexByte Function Result
  Pas Exit;          { and Exit }

 ;- Here is the precise code we will use in the assembly program -
 ;- Assumes Al = SourceByte on entry, Returns result in Ax
 ;- All other registers are preserved
HexByte:
  Push Bx
  Xor Ah,Ah  ; set Ah = 0 to prevent Divide Overflow
  Mov Bl,010
  Div Bl     ; Al = Quo, Ah = Rem
  Mov Bx,Offset HexDigits
  Xchg Al,Ah
  XlatB
  Xchg Al,Ah
  XlatB
  Pop Bx
  Ret
 ;- End of HexByte code


Finish:
END; {Assemble}

END; {FUNCTION TestHexByte}

CONST Result: RECORD
        Len: BYTE;
        Wrd: INTEGER;
      END = (Len:2;Wrd:0);
VAR
  n: BYTE;
  ResultString: STRING[2] Absolute Result;

BEGIN {Main Program}
  FOR n := 0 TO 255 DO BEGIN
    WRITE(n:3,' ');
    Result.Wrd := TestHexByte(n);
    WRITE(ResultString,'  ');
  END; {FOR n := 0 TO 255 DO }
  WRITELN;
END. {Main}
