{ USAGE.PAS }
{  Non-Executable file with sample assembly language instructions     }
{ USAGE.PAS }

(* NOTES *

 This file contains one or more examples of each 8086 instruction
 mnemonic with a variety of combinations of operand types.  It is not
 intended as a replacement for a tutorial or reference on assembly
 language programming, however in some cases a couple of examples
 of typical instruction syntax is all that you may need.  Please see
 the  various .PAS files (on the registration disk or in the archive
 TP-ASM.ZIP) for examples of assembly language in the context of
 working programs.


 The following symbols, used in the example instructions, can
 represent a variety of Pascal and/or Assembly symbols as indicated
 in the discussion which follows:

   Immediate_Byte   Immediate_Word
   MemoryVar_Byte   MemoryVar_Word   MemoryVarDWord   MemoryVariable
   MemoryReg_Byte   MemoryReg_Word
   CodeLabelSHORT   CodeLabel_NEAR


 Immediate_Byte can be:
  a standard Pascal Constant, an Assembly EQU Constant, or a numeric
  value or expression in the range -128 to 255

 Immediate_Word can be:
  a standard Pascal Constant, an Assembly EQU Constant, or a numeric
  value or expression in the range -32768 to 65535

 MemoryVar_Byte can be:
  a Pascal BOOLEAN, BYTE, CHAR, or SHORTINT Variable or Typed Constant
  or an Assembly BYTE Variable defined via DB or EQU B [..]

 MemoryReg_Byte can be:
  a MemoryVar_Byte or a Byte register (Al, Ah, Bl, Bh, Cl, Ch, Dl, Dh)

 MemoryVar_Word can be:
  a Pascal INTEGER or WORD Variable or Typed Constant
  or an Assembly WORD Variable defined via DW or EQU W [..]

 MemoryReg_Word can be:
  a MemoryVar_Word or a Word register (Ax, Bx, Cx, Dx, Si, Di, Bp, Sp)

 MemoryVarDWord can be:
  a Pascal LONGINT or POINTER (^INTEGER, ^BYTE, etc) Variable or Typed
  Constant, a Proc/Function VAR or UNTYPED Parameter,
  or an Assembly DWORD Variable defined via DD or EQU D [..]

 MemoryVariable can be:
  a MemoryVar_Byte, MemoryVar_Word, or MemoryVarDWord,
  or a Pascal Variable of any other Type (e.g. STRING)

 CodeLabelSHORT must be:
  an Assembly Code Label within 127 bytes (forward) or 128 bytes (back)
  from the beginning of the next instruction

 CodeLabel_NEAR must be:
  an Assembly Code Label within the current Assemble/Internal statement

 Dh is used as a typical Byte register.  It can be replaced by any of
  the following Byte registers:  Al, Ah, Bl, Bh, Cl, Ch, Dl, or Dh

 Si is used as a typical Word register.  It can be replaced by any of
  the following Word registers:  Ax, Bx, Cx, Dx, Si, Di, Bp, or Sp


 The following list contains separate examples for instructions using
 the Accumulator (AL or AX) in cases where the Accumulator version uses
 a different opcode.  Instructions using the Accumulator are often one
 byte shorter than instructions using another register.

* NOTES *)




{- Type Definitions For Version 3 -}
TYPE
  WORD    =  INTEGER;
  POINTER = ^INTEGER;

{- Standard constants -}
CONST
  Immediate_Byte = 5;
  Immediate_Word = $0213;

{- Typed Constants -}
CONST
  MemoryVar_Byte: BOOLEAN = TRUE;
  MemoryReg_Byte: CHAR = 'A';

{- Global Variables -}
VAR
  MemoryVar_Word: WORD;
  MemoryReg_Word: INTEGER;


PROCEDURE OptestProc;

{- Local Variables -}
VAR
  MemoryVarDWord: POINTER;
  MemoryVariable: STRING[34];

BEGIN
Assemble

 AAA
 AAD
 AAM
 AAS
 ADC AL,Immediate_Byte
 ADC AX,Immediate_Word
 ADC MemoryReg_Byte,Immediate_Byte
 ADC MemoryReg_Byte,Dh
 ADC MemoryReg_Word,Immediate_Byte
 ADC MemoryReg_Word,Immediate_Word
 ADC MemoryReg_Word,Si
 ADC Dh,MemoryReg_Byte
 ADC Si,MemoryReg_Word
 ADD AL,Immediate_Byte
 ADD AX,Immediate_Word
 ADD MemoryReg_Byte,Immediate_Byte
 ADD MemoryReg_Byte,Dh
 ADD MemoryReg_Word,Immediate_Byte
 ADD MemoryReg_Word,Immediate_Word
 ADD MemoryReg_Word,Si
 ADD Dh,MemoryReg_Byte
 ADD Si,MemoryReg_Word
 AND AL,Immediate_Byte
 AND AX,Immediate_Word
 AND MemoryReg_Byte,Immediate_Byte
 AND MemoryReg_Byte,Dh
 AND MemoryReg_Word,Immediate_Word
 AND MemoryReg_Word,Si
 AND Dh,MemoryReg_Byte
 AND Si,MemoryReg_Word
 CALL 0040:0222
 CALL CodeLabel_NEAR
 CALL MemoryVarDWord
 CALL MemoryReg_Word
 CBW
 CLC
 CLD
 CLI
 CMC
 CMP AL,Immediate_Byte
 CMP AX,Immediate_Word
 CMP MemoryReg_Byte,Immediate_Byte
 CMP MemoryReg_Byte,Dh
 CMP MemoryReg_Word,Immediate_Byte
 CMP MemoryReg_Word,Immediate_Word
 CMP MemoryReg_Word,Si
 CMP Dh,MemoryReg_Byte
 CMP Si,MemoryReg_Word
 CMPSB
 CMPSW
 CWD
 DAA
 DAS
 DEC MemoryReg_Byte
 DEC MemoryReg_Word
 DEC Si
 DIV MemoryReg_Byte
 DIV MemoryReg_Word
 HLT
 IDIV MemoryReg_Byte
 IDIV MemoryReg_Word
 IMUL MemoryReg_Byte
 IMUL MemoryReg_Word
 IN AL,DX
 IN AL,Immediate_Byte
 IN AX,DX
 IN AX,Immediate_Byte
 INC MemoryReg_Byte
 INC MemoryReg_Word
 INC Si
 INT 3
 INT Immediate_Byte
 INTO
 IRET
 JA CodeLabelSHORT
 JAE CodeLabelSHORT
 JB CodeLabelSHORT
 JBE CodeLabelSHORT
 JC CodeLabelSHORT
 JCXZ CodeLabelSHORT
 JE CodeLabelSHORT
 JG CodeLabelSHORT
 JGE CodeLabelSHORT
 JL CodeLabelSHORT
 JLE CodeLabelSHORT
 JMP CodeLabelSHORT
 JMP 0040:0222
 JMP CodeLabel_NEAR
 JMP MemoryReg_Word
 JMP MemoryVarDWord
 JNA CodeLabelSHORT
 JNAE CodeLabelSHORT
 JNB CodeLabelSHORT
 JNBE CodeLabelSHORT
 JNC CodeLabelSHORT
 JNE CodeLabelSHORT
 JNG CodeLabelSHORT
 JNGE CodeLabelSHORT
 JNL CodeLabelSHORT
 JNLE CodeLabelSHORT
 JNO CodeLabelSHORT
 JNP CodeLabelSHORT
 JNS CodeLabelSHORT
 JNZ CodeLabelSHORT
 JO CodeLabelSHORT
 JP CodeLabelSHORT
 JPE CodeLabelSHORT
 JPO CodeLabelSHORT
 JS CodeLabelSHORT
 JZ CodeLabelSHORT
CodeLabelSHORT:
 LAHF
 LDS Si,MemoryVarDWord
 LEA Si,MemoryVariable
 LES Si,MemoryVarDWord
 LOCK Mov Ax,[Si+2]
 LODSB
 LODSW
 LOOP CodeLabelSHORT
 LOOPE CodeLabelSHORT
 LOOPNE CodeLabelSHORT
 LOOPNZ CodeLabelSHORT
 LOOPZ CodeLabelSHORT
 MOV AL,MemoryVar_Byte
 MOV AX,MemoryVar_Word
 MOV DS,MemoryVar_Word
 MOV DS,Si
 MOV MemoryReg_Byte,Immediate_Byte
 MOV MemoryReg_Byte,Dh
 MOV ES,MemoryVar_Word
 MOV ES,Si
 MOV MemoryVar_Word,CS
 MOV Si,CS
 MOV MemoryVar_Word,DS
 MOV Si,DS
 MOV MemoryVar_Word,ES
 MOV Si,ES
 MOV MemoryReg_Word,Immediate_Word
 MOV MemoryReg_Word,Si
 MOV MemoryVar_Word,SS
 MOV Si,SS
 MOV Dh,MemoryReg_Byte
 MOV Dh,Immediate_Byte
 MOV Si,MemoryReg_Word
 MOV Si,Immediate_Word
 MOV SS,MemoryVar_Word
 MOV SS,Si
 MOV MemoryVar_Byte,AL
 MOV MemoryVar_Word,AX
 MOVSB
 MOVSW
 MUL MemoryReg_Byte
 MUL MemoryReg_Word
 NEG MemoryReg_Byte
 NEG MemoryReg_Word
 NOP
 NOT MemoryReg_Byte
 NOT MemoryReg_Word
 OR AL,Immediate_Byte
 OR AX,Immediate_Word
 OR MemoryReg_Byte,Immediate_Byte
 OR MemoryReg_Byte,Dh
 OR MemoryReg_Word,Immediate_Word
 OR MemoryReg_Word,Si
 OR Dh,MemoryReg_Byte
 OR Si,MemoryReg_Word
 OUT DX,AL
 OUT DX,AX
 OUT Immediate_Byte,AL
 OUT Immediate_Byte,AX
 POP DS
 POP ES
 POP MemoryVar_Word
 POP Si
 POP SS
 POPF
 PUSH CS
 PUSH DS
 PUSH ES
 PUSH MemoryVar_Word
 PUSH Si
 PUSH SS
 PUSHF
 RCL MemoryReg_Byte,1
 RCL MemoryReg_Byte,CL
 RCL MemoryReg_Word,1
 RCL MemoryReg_Word,CL
 RCR MemoryReg_Byte,1
 RCR MemoryReg_Byte,CL
 RCR MemoryReg_Word,1
 RCR MemoryReg_Word,CL
 REP MovSB
 REPE CmpSB
 REPNE CmpSB
 REPNZ ScaSB
 REPZ ScaSB
 RET
 RET Immediate_Word
 RETF
 RETF Immediate_Word
 ROL MemoryReg_Byte,1
 ROL MemoryReg_Byte,CL
 ROL MemoryReg_Word,1
 ROL MemoryReg_Word,CL
 ROR MemoryReg_Byte,1
 ROR MemoryReg_Byte,CL
 ROR MemoryReg_Word,1
 ROR MemoryReg_Word,CL
 SAHF
 SAL MemoryReg_Byte,1  ;Same as SHL
 SAL MemoryReg_Byte,CL ;Same as SHL
 SAL MemoryReg_Word,1  ;Same as SHL
 SAL MemoryReg_Word,CL ;Same as SHL
 SAR MemoryReg_Byte,1
 SAR MemoryReg_Byte,CL
 SAR MemoryReg_Word,1
 SAR MemoryReg_Word,CL
 SBB AL,Immediate_Byte
 SBB AX,Immediate_Word
 SBB MemoryReg_Byte,Immediate_Byte
 SBB MemoryReg_Byte,Dh
 SBB MemoryReg_Word,Immediate_Byte
 SBB MemoryReg_Word,Immediate_Word
 SBB MemoryReg_Word,Si
 SBB Dh,MemoryReg_Byte
 SBB Si,MemoryReg_Word
 SCASB
 SCASW
 SHL MemoryReg_Byte,1
 SHL MemoryReg_Byte,CL
 SHL MemoryReg_Word,1
 SHL MemoryReg_Word,CL
 SHR MemoryReg_Byte,1
 SHR MemoryReg_Byte,CL
 SHR MemoryReg_Word,1
 SHR MemoryReg_Word,CL
 STC
 STD
 STI
 STOSB
 STOSW
 SUB AL,Immediate_Byte
 SUB AX,Immediate_Word
 SUB MemoryReg_Byte,Immediate_Byte
 SUB MemoryReg_Byte,Dh
 SUB MemoryReg_Word,Immediate_Byte
 SUB MemoryReg_Word,Immediate_Word
 SUB MemoryReg_Word,Si
 SUB Dh,MemoryReg_Byte
 SUB Si,MemoryReg_Word
 TEST AL,Immediate_Byte
 TEST AX,Immediate_Word
 TEST MemoryReg_Byte,Immediate_Byte
 TEST MemoryReg_Byte,Dh
 TEST MemoryReg_Word,Immediate_Word
 TEST MemoryReg_Word,Si
 TEST Dh,MemoryReg_Byte
 TEST Si,MemoryReg_Word
 WAIT
 XCHG AX,Si
 XCHG MemoryReg_Byte,Dh
 XCHG MemoryReg_Word,Si
 XCHG Dh,MemoryReg_Byte
 XCHG Si,AX
 XCHG Si,MemoryReg_Word
 XLAT MemoryVar_Byte
 XLATB
 XOR AL,Immediate_Byte
 XOR AX,Immediate_Word
 XOR MemoryReg_Byte,Immediate_Byte
 XOR MemoryReg_Byte,Dh
 XOR MemoryReg_Word,Immediate_Word
 XOR MemoryReg_Word,Si
 XOR Dh,MemoryReg_Byte
 XOR Si,MemoryReg_Word
CodeLabel_NEAR:

END; {Assemble}
END; {OptestProc}

BEGIN
Asm Mov Ax,OptestProc; {- Force "smart linker" to INCLUDE OptestProc -}
WRITELN;
WRITELN('This is not an executable file');
WRITELN;
END.
