############################################################################
#  Reads one or more hmp files and one or more oc or hfp files and 
#  constructs a hfp file of the characters from the characters
#  listed in the hmp files.
#
#  The hmp files are regognized by their extensions. All other files
#  are assumed to be font files.
############################################################################

############################
#  Read all the hmp files
############################

($ARGV[0] =~ /\.hmp/i) || die "I need at least one hmp file.";

while ($ARGV[0] =~ /\.hmp/i) {
  open(IN, $ARGV[0]);
  while(<IN>) {
    @charNumbers=split(/\s+/);
    foreach (@charNumbers) {
      if (/(\d+)\-(\d+)/) {
        for $i ($1..$2) {
          $fontSym{$i}++;
        }
      }
      else {
        $fontSym{$_}++;
      }
    }
  }
  close(IN);
  shift;
}

############################################################################
#  Now read through the font files and write to the output only those
#  letters for which we have an associative array value defined
############################################################################
$line='';
while(<ARGV>) {
  chop;
  if ( (($symNum, $numStrokes) = /(.....)(...)/)
    && ($numStrokes=~ /^\s*\d+$/) && ($symNum=~ /^\s*(\d+)$/)) {
    print "$line\n" if defined $fontSym{$lineSymNum};
    $line='';
    $lineSymNum=$1;
  }
  $line .= $_;
}

