{*****************************************************************************}
{*  TSTHERSH.PAS                                                             *}
{*                                                                           *}
{*  An example of how to use the TPHERSH unit.                               *}
{*                                                                           *}
{*  Dov Grobgeld                                                             *}
{*  Department of Chemical Physics                                           *}
{*  The Weizmann Institute of Science                                        *}
{*  Israel                                                                   *}
{*  Email: dov@menora.weizmann.ac.il                                         *}
{*                                                                           *}
{*  8/9/1991                                                                 *}
{*                                                                           *}
{*****************************************************************************}

uses graph, dos, tphersh;

{ Include some fonts ... }

{$i gothgbt.inc }  { Has to be constructed by the hmp2inc.pl program }
{$i romanc.inc  }  { See the documentation file hmp2inc.doc }
{$i romanp.inc }
{$i cyrilc.inc }
{$i greekc.inc }
{$I italicc.inc }

var
  gd, gm,i : integer;
  mem : longint;

begin
  mem:= MaxAvail;
  HersheyLoadGlyphs;
  writeln('Font load size: ', mem - MaxAvail);
  write('Press Enter to continue...'); readln;

  gd:= detect;
  initgraph(gd, gm, getenv('bgidir')); { Set the environment variable bgi dir }
                                       { to the directory where the bgi files reside }

  
  HersheySetFont(HersheyGothgbt);
  HersheySetGlyphSize(60,60);
  HersheySetAngle(-30);
  setcolor(lightred);  { BGI stuff }
  HersheyOutTextXY(50,50, 'TP Hersh');
  HersheySetFont(HersheyItalicC);
  HersheySetGlyphSize(22,14);
  setcolor(yellow);
  HersheyOutTextXY(150,200, 'by Dov Grobgeld');
  setcolor(lightgreen);
  HersheySetAngle(0);
  HersheySetGlyphSize(10,10);
  HersheySetFont(HersheyRomanC);
  HersheyOutTextXY(150,20, '!"#$%&''()*+,-./09:;<=>?@A{\}~'#127);
  HersheySetFont(HersheyCyrilc);
  HersheyOutTextXY(200,70, 'Cyrillic');
  HersheySetFont(HersheyGreekC);
  HersheyOutText(' and Greek.');

  HersheySetFont(HersheyRomanC);
  HersheyMove(450,170);
  setcolor(lightCyan);
  HersheySetGlyphSize(20,20);
  HersheySetAngle(45);
  for i:= 1 to 7 do HersheyDisplayGlyph(740 + i);
  setColor(lightGreen);
  HersheyMove(600,80);
  HersheySetAngle(-100);
  HersheySetGlyphSize(30,30);
  for i:= 1 to 10 do HersheyDisplayGlyph(840+i);
  HersheySetGlyphSize(12,12);
  HersheySetAngle(0);
  HersheySetStringJustify(-1,0); HersheyOutTextXY(50, 170, 'abc');
  HersheySetStringJustify(0,0); HersheyOutTextXY(50, 200, 'abc');
  HersheySetStringJustify(1,0); HersheyOutTextXY(50, 230, 'abc');
  HersheySetStringJustify(-1,-1); HersheyOutTextXY(80, 230, 'A');
  HersheySetStringJustify(-1,0); HersheyOutText('A');
  HersheySetStringJustify(-1,1); HersheyOutText('A');
  HersheySetStringJustify(1,0);
  HersheySetFont(HersheyRomanP);
  HersheySetStringJustify(0,0);
  HersheyOutTextXY(100,300, 'Some centered strings');
  HersheyOutTextXY(100,320, '12345');
  HersheyOutTextXY(100,330, '941');

  HersheySetGlyphSize(8,8);
  HersheySetFont(HersheyRomanC);
  HersheySetStringJustify(-1,0);
  HersheySetGlyphSize(6,6);
  HersheyMove(210,320); HersheyDisplayGlyph(2269);
  HersheySetGlyphSize(8,8);
  HersheyOutText('E=0');


  readln;
  closegraph;
end.
