{ DEMOMOVE.PAS }
program MoveDemo;
{ Demonstrates how Move procedure can be used to move large numbers
of bytes around inside an array.  This demo stores lines of text
into a large TextArray.  New lines are added by calling AddLine, which
calls MakeAHole to slide the existing data in the TextArray to make
room for new text.  AddLine then uses Move to copy the string data
into TextArray.  Data is fetched using the procedure GetLine.
  The variable CurSize keeps track of how many bytes of TextArray are
currently in use.  CurLocation keeps track of the current position; if we
were writing a text editor based on this approach, CurLocation would index
into TextArray where the editor's cursor appears on the screen.  In other
word, the next new line that we type would be inserted at CurLocation.
}

const
  MaxSize = 32000;
  MARKER = 13;

var
  TextArray : Array[0..MaxSize] of Char;
  CurSize : Word;
  CurLocation : Word;


procedure MakeAHole ( Address : Word; Size : Word );
{ Slides data in the TextArray sideways, leaving a "hole" to fill
with new data }
begin
  Move( TextArray[Address], TextArray[Address+Size], CurSize - Address + 1 );
end;



procedure AddLine ( var Address : Word; S : String );
{ Adds the contents of S to the TextArray, starting at location Address }
var
  NumBytes : Integer;
begin
  NumBytes := Length(S) + 1;
  S[0] := Chr(MARKER);
  MakeAHole ( Address, NumBytes );
  Move( S[0], TextArray[Address], NumBytes );
  CurSize := CurSize + NumBytes;
  Address := Address + NumBytes;
end;



procedure GetLine ( Address : Word; var S : String );
{ On entry, Address points to a MARKER character in the text array.  GetLine
copies the text between this marker and the next marker (or end of array)
to S. }
var
  TempAddr : Word;
begin
  TempAddr := Address + 1;
  while (TempAddr <= CurSize) and
        (TextArray[TempAddr] <> Chr(MARKER)) do
    Inc(TempAddr);
  Move ( TextArray[Address+1], S[1], TempAddr - Address );
  S[0] := chr( TempAddr - Address );
end;


procedure MoveAhead (var Address : Word );
{ Where address points to some location in TextArray, MoveAhead positions
Address to the index location of the next Marker character. }
begin
  if  TextArray[Address] = chr(MARKER)  then
    Inc(Address);
  while (Address <= CurSize) and
        (TextArray[Address] <> Chr(MARKER)) do
    Inc(Address);
end;


var
  I : Integer;
  ALine : String;

begin
  CurSize := 0;
  CurLocation := 0;

  { Add some sample data into TextArray }
  AddLine ( CurLocation, 'Line 1 I''m the first line of data');
  AddLine ( CurLocation, 'Line 2 and I''m the second!');
  AddLine ( CurLocation, 'Line 3 The quick brown fox jumped over the');
  AddLine ( CurLocation, 'Line 4 lazy brown dog and fell and hurt herself.');

  CurLocation := 0;
  MoveAhead ( CurLocation );
  AddLine ( CurLocation, 'One more line!!!!!');

  CurLocation := 0;
  for I := 1 to 5 do
  begin
    GetLine ( CurLocation, ALine );
    Writeln( ALine );
    MoveAhead ( CurLocation );
  end;

  readln;
end.
