{ FSEARCH.PAS }
Program DemoSearch;
{ Demonstrates an algorithm to locate a program's required data and
  configuration files through the use of the DosVersion function,
  ParamStr function, FSplit procedure and FSearch function.  This algorithm
  assumes that the required config. files are kept in the same directory
  as the .EXE file.
}
uses
  Dos;

const
  { This is the filename that we must locate }
  DataFilename = 'SCRATCH.DAT';

var
  Path : PathStr;
  Directory : DirStr;
  FName : NameStr;
  Extension : ExtStr;
  F : File;

begin

  Path := '';
  {$I-}
  { First, check the current directory }
  Assign( F, DataFilename );
  Reset( F );
  if IoResult <> 0 then
  { if not found here, then continue checking ... }
  begin
    if Lo(DosVersion) >= 3.0 then
    { if running >= DOS 3.0, then use ParamStr(0) to get location of
      the .EXE file and assume that directory for the data files }
    begin
      FSplit ( ParamStr(0), Directory, FName, Extension );
      Path := Directory;
    end
    else
      { Otherwise, search through the list of directories in the DOS
        PATH statement.  The .EXE, and hence, its data files, must
        have been booted from one of these directories. }
      Path := FSearch ( DataFileName, GetEnv('PATH') );
  end
  else
  Close ( F );

  Writeln('Path = ', Path );
end.
