{ PAGEDEMO.PAS }
program PageDemo;
{ Demonstrates multiple video pages by writing to page #0 and displaying
  that page.  Then, by calling SetActivePage ( 1 ), switches to Page #1
  and sends output to that page while still display page #0.  After
  writing the output to Page #1, the program then switches back and
  forth between the two pages.
  This program should only be run in graphic modes that support
  multiple pages.
}
uses
  Graph;

var
  GraphBuffer : Pointer;
  GraphDriver, GraphMode : Integer;
  TheText : String;

begin
  { Check for VGA and select a multi-page mode }
  DetectGraph ( GraphDriver, GraphMode );

  { This code may be different for your monitor }
  if  GraphDriver = VGA then
    GraphMode := VGALo;

  InitGraph ( GraphDriver, GraphMode, '\BP\BGI');

  SetVisualPage ( 0 );
  SetActivePage ( 0 );

  SetTextJustify (CenterText, CenterText);
  SetTextStyle( TriplexFont, HorizDir, 3);
  OutTextXY (GetMaxX div 2, GetMaxY div 2, 'This is Page #0');

  SetActivePage ( 1 );
  OutTextXY ( GetMaxX div 2, GetMaxY div 2, 'This is Page # 1');
  Line ( 50, 50, 150, 150 );
  Readln;
  SetVisualPage ( 1 );
  Readln;
  SetVisualPage ( 0 );
  Readln;

  CloseGraph;
end.
