{ RANDFILE.PAS }
program RandFile;
{ Demonstrates random access to a record file }

const
  MaxRecords = 100;

type
  TDataRecord = record
                  Name        : String[20];
                  PhoneNumber : String[14];
                  Age         : Integer;
                  Available   : Boolean;
                end;

var
  Command     : Char;
  RandomFile  : File of TDataRecord;



procedure AddRecord;
var
  DataRecord : TDataRecord;
  NewName : String[20];
  NewPhone: String[14];
  NewAge  : String[20];
  RecordNum  : Word;


function  FindFreeRecord : Integer;
{ Scans through the file until finding a free or unused record.
  Returns:  The record number of the free record, or if no free
            records are found, then returns MaxRecords + 1.
}
var
  DataRecord : TDataRecord;
  RecNum : Integer;
begin
  RecNum := 0;
  repeat
    Seek( RandomFile, RecNum );
    Read( RandomFile, DataRecord );
    if  not  DataRecord.Available  then
      RecNum := RecNum + 1;
  until (RecNum > MaxRecords) Or (DataRecord.Available);
  FindFreeRecord := RecNum;
end; { FindFreeRecord }


begin { AddRecord }

  RecordNum := FindFreeRecord;
  if  RecordNum > MaxRecords  then
    Writeln('The maximum number of records (',MaxRecords,') are in use.')
  else
  begin

    with  DataRecord  do
    begin
      Writeln('Adding record #', RecordNum );
      Write('Enter Name ?');
      Readln( Name );
      Write('Enter # PhoneNumber ?');
      Readln( PhoneNumber );
      Write('Enter Age ?');
      Readln( Age );
      Available := False;
    end;

    Seek( Randomfile, RecordNum );
    Write( RandomFile, DataRecord );
  end;

end; { AddRecord }


procedure DisplayRecords;
var
  DataRecord : TDataRecord;
  I : Integer;
begin
  for  I := 0 to MaxRecords  do
  begin
    Seek( Randomfile, I );
    Read( RandomFile, DataRecord );
    if  not DataRecord.Available  then
    { Found a record that is in use }
    begin
      Writeln('Record #', I);
      with  DataRecord  do
        Writeln('Name=', Name,', Phone #=', PhoneNumber,', Age=', Age:3);
      Writeln;
    end; { if begin }
  end; { for begin }
end; { DisplayRecords }


procedure EditRecord;
var
  DataRecord : TDataRecord;
  Error : Integer;
  NewName : String[20];
  NewPhone: String[14];
  NewAge  : String[20];
  RecordNum  : Word;
begin

  Repeat

    Write('Enter number of record to edit:  ');
    Readln( RecordNum );

    Seek( RandomFile, RecordNum );
    Read( RandomFile, DataRecord);
    if  DataRecord.Available  then
      writeln('Record #', RecordNum, ' does not contain any data.');

  Until  not DataRecord.Available;


  with  DataRecord  do
  begin
    Write('Name =', Name,'(CR=no change) ? ');
    Readln( NewName );
    if  NewName <> '' then
      Name := NewName;
    Write('PhoneNumber =', PhoneNumber, '(CR=no change) ? ');
    Readln( NewPhone );
    if  NewPhone <> ''  then
      PhoneNumber := NewPhone;
    Write('Age =', Age, '(CR=no change) ? ');
    Readln( NewAge );
    if  NewAge <> ''  then
      Val( NewAge, Age, Error);
  end;
  Seek( RandomFile, RecordNum );
  Write( RandomFile, DataRecord );
end; { EditRecord }


procedure OpenFile;
var
  SampleRecord : TDataRecord;
  Error : Integer;
  I : Integer;
begin
  { Open existing file or create a new random access data file }
  Assign( RandomFile, 'RANDFILE.DAT');
  {$I-}
  Reset( RandomFile );
  {$I+}
  Error := IoResult;
  if  Error <> 0  then
  begin
    { Create and initialize a new file.  Set all records to available }
    Rewrite( RandomFile );
    SampleRecord.Available := True;
    for  I := 0 to MaxRecords  do
      write( RandomFile, SampleRecord );
  end; { if begin }
end; { OpenFile }


begin { RandFile }

  OpenFile;

  repeat
    Write('A)dd record, D)isplay records, E)dit record, Q)uit? ');
    Readln( Command );
    Command := Upcase( Command );
    case  Command  of
      'A' :  AddRecord;
      'D' :  DisplayRecords;
      'E' :  EditRecord;
    end; { case }
  until Command = 'Q';

  Close( RandomFile );


  Write('Press Enter when done.');
  Readln;


end. { program }
