program benchmark;
uses crt,strings;

{ NOTE: ITER is set to give good timing resolution on an IBM PC.  For
  faster machines, to maintain the same resolution, it should be
  increased roughly in proportion to the speed of the machine relative to
  a PC. }
const iter=1000;

var randstr,searchstr,temp1,temp2,temp3:string; i,j:byte; ii:word;
    biostimer:longint absolute $0040:$006C;
    elapsed:longint;

begin
    clrscr;
    randomize;
    randstr[0]:=#255;
    for i:=1 to 255 do randstr[i]:=chr(random(256));
    searchstr:=substr(randstr,250,6);
    writeln('Note: One timer tick is approximately 1/18th of a second.');

{ compare POS & FIRSTPOS }

    writeln('Timing the TP POS function:');
    elapsed:=biostimer;
    for ii:=1 to iter do i:=pos(searchstr,randstr);
    elapsed:=biostimer-elapsed;
    writeln(iter,' iterations of POS takes ',elapsed,' clock ticks.');
    writeln('Timing FIRSTPOS function:');
    elapsed:=biostimer;
    for ii:=1 to iter do j:=strings.firstpos(searchstr,randstr,1);
    elapsed:=biostimer-elapsed;
    writeln(iter,' iterations of FIRSTPOS takes ',elapsed,' clock ticks.');
    if i=j then writeln('Results agree.')
       else writeln('Results disagree!! what???');

{ compare COPY and SUBSTR }

    writeln; writeln('Timing the TP COPY function:');
    elapsed:=biostimer;
    for ii:=1 to 4*iter do temp1:=copy(randstr,100,150);
    elapsed:=biostimer-elapsed;
    writeln(4*iter,' iterations of COPY takes ',elapsed,' clock ticks.');
    writeln('Timing SUBSTR function:');
    elapsed:=biostimer;
    for ii:=1 to 4*iter do temp2:=strings.substr(randstr,100,150);
    elapsed:=biostimer-elapsed;
    writeln(4*iter,' iterations of SUBSTR takes ',elapsed,' clock ticks.');
    if temp1=temp2 then writeln('Results agree.')
       else writeln('Results disagree!! what???');

{ compare INSERT and INSTR }

    writeln; writeln('Timing TP INSERT procedure:');
    temp1:=substr(randstr,1,100);
    temp2:=substr(randstr,101,50);
    elapsed:=biostimer;
    for ii:=1 to iter do insert(temp2,temp1,50);
    elapsed:=biostimer-elapsed;
    writeln(iter,' iterations of INSERT takes ',elapsed,' clock ticks.');
    temp3:=temp1;
    writeln('Timing INSTR function:');
    temp1:=substr(randstr,1,100);
    elapsed:=biostimer;
    for ii:=1 to iter do temp1:=strings.instr(temp2,temp1,50,' ');
    elapsed:=biostimer-elapsed;
    writeln(iter,' iterations of INSTR takes ',elapsed,' clock ticks.');
    if temp1=temp3 then writeln('Results agree.')
       else writeln('Results disagree!! what???');

{ compare DELETE and DELSTR }

    writeln; writeln('Timing TP DELETE procedure:');
    temp1:=substr(randstr,1,100);
    elapsed:=biostimer;
    for ii:=1 to 2*iter do begin
       temp2:=temp1;
       delete(temp2,40,40);
    end;
    elapsed:=biostimer-elapsed;
    writeln(2*iter,' iterations of DELETE takes ',elapsed,' timer ticks.');
    writeln('Timing DELSTR function:');
    elapsed:=biostimer;
    for ii:=1 to 2*iter do begin
       temp3:=temp1; { to keep things MORE than equal }
       temp3:=strings.delstr(temp1,40,40);
    end;
    elapsed:=biostimer-elapsed;
    writeln(2*iter,' iterations of DELSTR takes ',elapsed,' timer ticks.');
    if temp2=temp3 then writeln('Results agree.')
       else writeln('Results disagree!! what???');

end.
