;---------------------------------------------------------------------------
; Program Name:  Convert.Inc
;
; Author:        Steve Poulsen
;
; This procedure converts a byte in AL to a printable string at DI.
; I.E. if AL = 67d then '67' will be put at DI.  
;
; Before:
;       AL = Byte to convert
;       DI = Pointer to location to store string 'must be long enough'
; After:
;       Nothing
; Changes:
;       Nothing
;---------------------------------------------------------------------------

Convert_Num Proc    Far

            Push BX            
            Push CX
            Push DX
            Push DI
            
            Xor CX,CX               ; Clear CX, CX = number of digits
            Mov BX,0Ah              ; Use base 10 or decimal
Repeat_s:          
            Mov AH,0                ; Make sure only a byte
            Div BL                  ; Divide by 10.  Remainder is right digit
            Inc CX                  ; Add a digit to CX
            Add AH,30h              ; Add 30h for a printable character
            Push AX                 ; Push the character on the stack
            Cmp AL,0                ; Is there nothing left to divide?
            JNE Repeat_s            ; Divide again
Repeat_t:            
            Pop DX                  ; Get digit
            Dec CX                  ; CX tells us how many to pop off the stack
            Mov [DI],DH             ; Put this in the data area 
            Inc DI                  ; Move data area to next location
            Cmp CX,0                ; Is this all the digits?
            JNE Repeat_t            ; If not then get another
            
            Pop DI
            Pop DX
            Pop CX            
            Pop BX

            Ret
Convert_Num EndP
