;---------------------------------------------------------------------------
; Program Name: Screen.Asm
;
; Author:       Steve Poulsen
;
;---------------------------------------------------------------------------
Bios        Segment At 40h
            Org 17h
Shift       DB  ?
Bios        EndS
;---------------------------------------------------------------------------
Code        Segment
            Assume CS:Code,DS:Code
            Org 2Ch
Env_Ptr     DW ?            
            Org 80h
Command     DB ?
            Org 100h
Start:      Jmp Initial
Message     DB 'Screen Saver by Steve Poulsen$'
OldInt_15   DD ?
OldInt_08   DD ?
Attribute   DB 00h
Clear_Flag  DB 0
Next_Flag   DB 0
ShiftStatus DB 0
StkSz       EQU 128
Timer       DW  0
Mess_Timer  DW  0
Mess_Delay  DW  20
Off_Delay   DW  600
Delay       DW  1554h           ; 5 minutes
VGA         DB  0
;---------------------------------------------------------------------------
Include     Write.Inc
Include     SaveScr.Inc
Include     ClrScr.Inc
Include     RestScr.Inc
;---------------------------------------------------------------------------
; Interrupt 15h Replacement
;---------------------------------------------------------------------------
Int_15      Proc    Far
            Assume CS:Code,DS:Nothing,ES:Nothing
            
            PushF
            
            Cmp AH,4Fh
            JNE NoChange
            
            Mov CS:Timer,0
            Cmp CS:Clear_Flag,0
            JE NoRestore
            
            Cmp CS:VGA,0
            JE NoVGARestore

            Push AX
            Push BX
            Mov AX,1200h
            Mov BL,36h
            Int 10h
            Pop BX
            Pop AX
            Jmp Either
            
NoVGARestore:            
            Push CX
            Push DX
            Push SI
            Mov CX,0
            Mov DX,184Fh
            Mov SI,Offset CS:ScreenSave
            Call RestScr
            Pop SI
            Pop DX
            Pop CX
Either:            
            Dec CS:Clear_Flag
            Push AX
            Push ES
            Mov AX,Offset Bios
            Mov ES,AX
            Mov AL,CS:ShiftStatus
            Mov ES:Shift,AL
            Pop ES
            Pop AX
            PopF
            CLC
            Jmp NoNull
            
            
NoRestore:      
NoChange:
            PopF
            PushF
            Call DWord Ptr CS:[OldInt_15]
NoNull:
            Ret 2                   ; Flags intact
Int_15      EndP                
;---------------------------------------------------------------------------
; Interrupt 08h Replacement
;---------------------------------------------------------------------------
Int_08      Proc    Far
            Assume CS:Code,DS:Nothing,ES:Nothing
            Inc CS:Timer
            Push AX
            Mov AX,CS:Delay
            Cmp CS:Timer,AX
            JB NoCleara
            Cmp CS:Clear_Flag,0
            JNE Message_Flash
            Jmp ClearScreen
            
NoCleara:
            Jmp NoClear
            
ClearScreen:
            Inc CS:Clear_Flag

            Push AX
            Push ES
            Mov AX,Offset Bios
            Mov ES,AX
            Mov AL,ES:Shift
            Pop ES
            Mov CS:ShiftStatus,AL
            Push BX
            Mov AX,1201h
            Mov BL,36h
            Int 10h
            Cmp AL,12h
            Pop BX
            Pop AX
            JNE NotVGA
            Mov CS:VGA,01
            Jmp Message_Flash
            
NotVGA:
            Push CX
            Push DX
            Push SI
            Mov CX,0
            Mov DX,184Fh
            Mov SI,Offset CS:ScreenSave
            Call SaveScr
            Mov SI,Offset CS:Attribute
            Call ClrScr
            Pop SI
            Pop DX
            Pop CX
            
            
Message_Flash:
            Cmp CS:VGA,01
            JE NoClear
            Push AX
            Mov AX,CS:Mess_Delay
            Cmp CS:Mess_Timer,AX
            Pop AX
            JG NoMessage 
            Push SI
            Push BX
            Push CX
            Mov SI,Offset CS:Message            
            Mov BX,0A0Ah
            Mov CL,0Fh
            Call Write
            Pop CX
            Pop BX
            Pop SI
            Inc CS:Mess_Timer
            Jmp NoClear
NoMessage:
            Inc CS:Mess_Timer
            Push AX
            Mov AX,CS:Off_Delay
            Cmp CS:Mess_Timer,AX
            Pop AX
            JG Reset_Timer
            Push SI
            Push DX
            Push CX
            Mov CX,0
            Mov DX,184Fh
            Mov SI,Offset CS:Attribute
            Call ClrScr
            Pop CX
            Pop DX
            Pop SI
            Jmp NoClear
Reset_Timer:
            Mov CS:Mess_Timer,0
            
NoClear:            
            
            Pop AX

            PushF
            Call DWord Ptr CS:[OldInt_08]
            IRet
Int_08      EndP
;---------------------------------------------------------------------------
Setup1 = $
;---------------------------------------------------------------------------
ScreenSave  DW 2000 Dup (?)
;---------------------------------------------------------------------------
Setup2 = $
;---------------------------------------------------------------------------
Include Inst-Chk.Inc
Include Check.Inc
Include Remove.Inc
Include RestInt.Inc
Include Convert.Inc
;---------------------------------------------------------------------------
Any_Flag        DB  0
Activate_Flag   DB  0
Remove_Flag     DB  0
Help_Flag       DB  0
Copyright_Mess  DB  'Screen Saver (c) 1992 By Steve Poulsen',13,10,10,'$'
NoSupport_Mess  DB  'Interrupt 15h Mode 4Fh Not Supported by This Machine',13,10,'$'
Illegal_Mess    DB  'Illegal Switch',13,10,'$'    
Removed_Mess    DB  'Remove Successful',13,10,'$'
Error_R_Mess    DB  'Can',44,'t Remove.  Please Reboot.',13,10,'$'
Overlaid_Mess   DB  'Another TSR installed.  Shouldnt Remove',13,10,10,'$'
Installed_Mess  DB  'Screen Saver Installed For $'
Minutes_Mess    DB  ' Minute$'
Install_Mess2   DB  '.',13,10,'$'
NotInst_Mess    DB  'Not Installed',13,10,'$'
AlreadyInst_Mess DB 'Already Installed',13,10,'$'
BadTime_Mess    DB  'Illegal Time.',13,10,'$'
Help_Mess       DB  13
                DB  'A screen blanker to prevent burn in on monitors.',13,10
                DB  'Performs a clear screen after a certain time of inactivity'
                DB  ' and returns the',13,10,'screen on a keypress.  Future updates plan'
                DB  ' to work for graphics mode, monitor',13,10,'comm port, and '
                DB  'monitor mouse.  Auto detect VGA hardware blanking.',13,10,10
                DB  'Commands:',13,10,10
                DB  '  /a        Installs to memory at a default of 5 minutes',13,10
                DB  '  /d        Removes from memory',13,10
                DB  '  /t<time>  Allows changing of time.  Time should be between'
                DB  ' 1 and 60 minutes.',13,10
                DB  '              Should be used with the /a option.',13,10
                DB  '  /h        This Menu',13,10,10
                DB  'Screen Saver is Shareware and payment is expected.',13,10
                DB  'Mail 5 dollars [or whatever]  to me at:',13,10
                DB  '    1227 Devonshire Lane',13,10
                DB  '    Rolla, MO  65401',13,10,'$' 
NoComm_Mess     DB  13,10
                DB  '      ',0D6h,13 Dup (0C4h),0B7h,13,10
                DB  '      ',0BAh,'Steve Poulsen',0BAh,13,10
                DB  '      ',0D3h,13 Dup (0C4h),0BDh,13,10
                DB  '       1227 Devonshire Lane',13,10
                DB  '       Rolla, MO  65401',13,10,10
                DB  'Internet:  S105728@UMRVMA.UMR.EDU',13,10,10
                DB  '/a         Activate [default 5 minutes unless /t is used]'
                DB  13,10
                DB  '/d         Deactivate and remove from memory',13,10
                DB  '/t[1-60]   Set time until blank [in minutes]',13,10
                DB  '/h         Help [more extensive]',13,10,10
                DB  'If you like this please send 5 dollars. Use /h for address.'
                DB  13,10,'$'
Switches        DB  'dhat'
Switch_Addr     DW  Offset CS:Deactivate,Offset CS:Help,Offset CS:Activate
                DW  Offset CS:Time_Set
Minutes         DW  5
Minute_Convert  DB  '$$$$$$$$$$$$'
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
; Initial
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
Initial     Proc    Near
            Assume CS:Code,DS:Code,ES:Nothing
            Push CS
            Pop DS
            
            
            Push ES
            Mov AH,0C0h
            Int 15h
            Mov AX,ES:[BX+5]
            Pop ES
            Test AX,16h
            JZ NoSupport
            Jmp Support
            
Support:
            Mov BL,2
            Mov DI,Offset Command
            Mov CL,[DI]
            Cmp CL,0
            JE NoCommands
            Jmp Search
Search:     
            Mov AL,'/'
            Scasb
            Repne Scasb
            JNE NoCommands
            
            Mov AL,[DI]
            Or AL,20h
            
            Mov SI,Offset CS:Switches
CheckNext:            
            Cmp AL,[SI]
            JE CorrectSwitch
Continue:            
            Inc SI
            Cmp SI,Offset Switch_Addr
            JE IllegalSwitch
            Jmp CheckNext
CorrectSwitch:
            Sub SI,Offset Switches
            SHL SI,1
            Call [SI+Switch_Addr]
            Jmp Search             
IllegalSwitch:
            Mov SI,Offset Illegal_Mess
            Call WriteMess
            Jmp Exit            
            
NoCommands:
            Cmp CS:Any_Flag,0
            JNE Exit_x
            Call NoComm
Exit_x:            
            Jmp Exit
NoSupport:
            Mov SI,Offset CS:NoSupport_Mess
            Call WriteMess
            Jmp Exit
;---------------------------------------------------------------------------
WriteMess   Proc    Near
            Assume CS:Code,DS:Nothing,ES:Nothing
            Push BX
            Push DX
            Push AX
            Push DS
            Push CS
            Pop DS
            
            Mov CL,0    ;Leftmost position
	        Mov CH,0    ;Top of Screen
            Mov DL,79   ;Rightmost position
	        Mov DH,24   ;Bottom of Screen
	        Mov BH,0Fh  ;White on Black
	        Mov AL,0
	        Mov AH,6    ;Scroll up
	        Int 10h
	        Mov BH,00h  ;Set Page zero of screen
	        Mov DL,00   ;Set cursor horiz. position
	        Mov DH,00   ;Set cursor vert.  position
	        Mov AH,02h  ;Set cursor position
	        Int 10h

            Mov DX,Offset Copyright_Mess
            Mov AH,09h
            Int 21h
            
            Mov DX,SI
            Mov AH,09h
            Int 21h
            Pop DS
            Pop AX
            Pop DX
            Pop BX
            Ret
WriteMess   EndP            
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
Time_Set    Proc    Near
            Assume CS:Code,DS:Nothing,ES:Nothing
            Push AX
            Push BX
            Xor AX,AX
Repeat_Time:            
            Inc DI
            Dec CX
            Mov BL,[DI]
            Cmp BL,20h
            JE ValueDone
            Cmp BL,0Dh
            JE ValueDone
            Sub BL,30h
            Cmp BL,09h
            JG IllegalTime
            Push CX
            Mov CX,10
            Mul CL
            Pop CX
            Cmp AH,0
            JNE IllegalTime
            Mov BH,0
            Add AX,BX
            Jmp Repeat_Time
            
ValueDone:            
            Mov CS:Minutes,AX
            Push DX
            Mov BX,444h
            Mul BX
            Cmp DX,0
            Pop DX
            JNE IllegalTime
            Mov CS:Delay,AX
            Jmp ValueSet
IllegalTime:
            Pop BX
            Mov SI,Offset BadTime_Mess
            Call WriteMess            
            Mov CS:Minutes,0
            Push BX
            Inc CS:Any_Flag
            Inc CS:Activate_Flag

ValueSet:            
            Pop BX
            Pop AX
            Ret
Time_Set    EndP        
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
Activate    Proc    Near
            Assume CS:Code,DS:Nothing,ES:Nothing
            
            Inc CS:Any_Flag
            Cmp Activate_Flag,0
            JNE NoInstall

            Call Install_Check
            JC NotInstalled_A
            Mov SI,Offset CS:AlreadyInst_Mess
            Call WriteMess
            Jmp NoInstall
            
NotInstalled_A:            
            Inc CS:Activate_Flag
            
NoInstall:            
            Ret
Activate    EndP
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
Deactivate  Proc    Near
            Assume CS:Code,DS:Nothing,ES:Nothing
            
            Cmp CS:Remove_Flag,0
            JNE Already_Remove
            Call Install_Check
            JC NotInstalled_R
            Push AX
            Mov AL,15h
            Call Check
            Pop AX
            JC Overlaid
            Push AX
            Mov AL,08h
            Call Check
            Pop AX
            JC Overlaid
            Mov AL,15h
            LDS DX,ES:[OldInt_15]     
            Call RestInt
            Mov AL,08h
            LDS DX,ES:[OldInt_08]     
            Call RestInt
            Call Remove
            JC Error_R
            Mov SI,Offset CS:Removed_Mess
            Jmp Message_R
            
Error_R:
            Mov SI,Offset CS:Error_R_Mess
            Jmp Message_R
            
Overlaid:
            Mov SI,Offset CS:Overlaid_Mess
            Jmp Message_R

NotInstalled_R: 
            Mov SI,Offset CS:NotInst_Mess           
Message_R:  
            Call WriteMess          
            Inc Byte Ptr CS:Remove_Flag
            Inc Byte Ptr CS:Any_Flag
Already_Remove:            
            Ret
Deactivate  EndP            
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
Help        Proc    Near
            Assume CS:Code,DS:Nothing,ES:Nothing
            Cmp CS:Help_Flag,0
            JNE Exit_H
            Inc CS:Any_Flag
            Inc CS:Help_Flag
            Mov SI,Offset CS:Help_Mess
            Call WriteMess
Exit_H:                 
            Ret
Help        EndP            
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
NoComm      Proc    Near
            Assume CS:Code,DS:Nothing,ES:Nothing
            Mov SI,Offset CS:NoComm_Mess
            Call WriteMess
            Ret
NoComm      EndP            
;---------------------------------------------------------------------------
Exit:       
            Cmp CS:Minutes,0
            JE ExitNicea
            
            Cmp CS:Activate_Flag,Byte Ptr 0
            JNE NotExitNice
            
ExitNicea:
            Jmp ExitNice
            
NotExitNice:
            
            Mov AX,3515h
            Int 21h
            Mov Word Ptr CS:[OldInt_15],BX
            Mov Word Ptr CS:[OldInt_15+2],ES
            Mov DX,Offset CS:Int_15
            Mov AX,2515h
            Int 21h
            
            Mov AX,3508h
            Int 21h
            Mov Word Ptr CS:[OldInt_08],BX
            Mov Word Ptr CS:[OldInt_08+2],ES
            Mov DX,Offset CS:Int_08
            Mov AX,2508h
            Int 21h

            Push AX
            Push DI
            Mov AX,CS:Minutes
            Mov DI,Offset CS:Minute_Convert
            Call Convert_Num
            Pop DI
            Pop AX
            Mov SI,Offset CS:Installed_Mess
            Call WriteMess
            Mov DX,Offset CS:Minute_Convert
            Mov AH,09h
            Int 21h
            Mov DX,Offset CS:Minutes_Mess
            Mov AH,09h
            Int 21h
            Mov BX,CS:Minutes
            Cmp BX,1
            JE No_S
            Mov DL,'s'
            Mov AH,2
            Int 21h
No_S:            
            Mov DX,Offset CS:Install_Mess2
            Mov AH,09h
            Int 21h
            
            Mov DX,Offset Setup2-Offset Code+StkSz
            Mov AX,1201h
            Mov BL,36h
            Int 10h
            Mov BH,AL
            Mov AX,1200h
            Int 10h
            Cmp BH,12h
            JNE DontChange
            Mov DX,Offset Setup1-Offset Code+StkSz
DontChange:            
            Add DX,15
            Mov CL,4
            Shr DX,CL
            Mov AX,3102h
            Int 21h
            
ExitNice:
            Mov AX,4C01h              
            Int 21h

            
Initial     EndP
Code        EndS
            End Start            






