(*Simple example for ugraf unit*)
(*Shows mode switching, direct write/read to screeen via pixel oritented routines*)
program ex01;

uses ugraf;

const resolution_x  : word = 640;
      resolution_y  : word = 480;
      bits_per_pixel = 8;

begin
     if find_best_mode(resolution_x, resolution_y, bits_per_pixel)=-1
        then begin
             done_graf;
             writeln('Can''t find a mode !!!');
             halt(250);
        end;

     if not init_mode then begin
        writeln('Can''t switch to mode : ', mode);
        done_graf;
        halt(2);
     end;
     (*line from top left corner to bottom right one*)
     (*and other stuff*)
     line(screen, 0, 0, getmaxx, getmaxy, $8a0f);       (*Note that this strange color ($8a0f) will be interpreted as
                                                          . $f=15 in 256 colors mode
                                                          . $8a0f as it is in 32K and 64k colors mode
                                                          . as $8a of green and $0f of blue in 16m oclors mode*)
     circle(screen, getmaxx div 2, getmaxy div 2, 75, $4005);
     fillarea(screen, (getmaxx div 2)+3, getmaxy div 2, $3004);
     (*Waits until key pressed*)
     read_key;
     (*Close all*)
     done_graf;
end.