unit Vesa;

{ VESA support for GR, Copr. 1994 Matthias Kppe

  Simply link this unit to your program, and all VESA modes will
  be available with the graphic modules using GR. Don't care about
  the things in the interface.
}

interface

{ Vesa-specific map address function
}
const
  qVesaMapAddr = 40;

{ Vesa-specific init graphics function
}
const
  qInitVesaGraph = 40;

function InitVesaGraph: Boolean;

{ Vesa-specific close graphics function
}
const
  qCloseVesaGraph = 40;

procedure CloseVesaGraph;

{ Vesa-driver detection
}
function DetectVesa: Boolean;

{ Enable second screen page
}
function EnablePage1: Boolean;

implementation

uses Gr, VesaInt;

var
  SavedMapAddr: procedure;

function DetectVesa: Boolean;
var
  VesaInfo: TVesaInfo;
Begin
  DetectVesa := GetVesaInfo(VesaInfo)
End;

procedure SetStdMapAddr;
var
  ModeInfo: TVesaModeInfo;
Begin
  If qVesaMapAddr > qMapAddrProc then
  If GetVesaModeInfo($102, ModeInfo) then Begin
    qMapAddrProc := qVesaMapAddr;
    @MapAddrProc := ModeInfo.vmPositionProc
  End
End;

function ld(x: Word): ShortInt; near; external;
procedure DetermineEndSeg; near; external;
function CalcPageSize: Word; near; external;

{$L vesamem.obj (vesamem.asm) }

function InitVesaGraph: Boolean;
var
  Info: TVesaModeInfo;
  VesaMode: Word;
  m: LongInt;
  Res: Boolean;
Begin
  case GrMode of
    gr640x480x256:
      VesaMode := $101;
    grSvgaStd:
      VesaMode := $102;
    gr800x600x256:
      VesaMode := $103;
    gr1024x768x16:
      VesaMode := $104;
    gr1024x768x256:
      VesaMode := $105;
    else Begin
      Res := InitBiosGraph;
      If Res then DetermineEndSeg;
      InitVesaGraph := Res;
      Exit
    End;
  End;
  SaveTextMode;
  InitVesaGraph := false;
  If not GetVesaModeInfo(VesaMode, Info) then Exit;
  with Info do Begin
    If vmModeAttrib and vmaSupported = 0 then Exit;
    If vmAWindowAttrib and (vwaExists + vwaReadable + vwaWritable) <>
       (vwaExists + vwaReadable + vwaWritable) then Exit;
    MapGranRight 	:= ld(vmGranularity) + 10;
    MapGranLeft		:= 16 - MapGranRight;
    WindowSize 		:= vmWindowSize * 1024;
    OffsetMask 		:= WindowSize - 1;
    MapGranMask		:= vmGranularity * 1024 - 1;
    GransPerWindow 	:= vmWindowSize div vmGranularity;
    WindowAddr 		:= SelOfsZero(Ptr(vmAWindowSegment, 0));
    SavedMapAddr	:= MapAddrProc;
    @MapAddrProc	:= vmPositionProc;
    RealBytesPerLine	:= vmBytesPerLine;
    BytesPerLine	:= vmBytesPerLine;
    InitVesaGraph := SetVesaMode(VesaMode);
  End;
  DetermineEndSeg;
  Free1Seg := Page0Seg + CalcPageSize;
End;

procedure CloseVesaGraph;
Begin
  RestoreTextMode;
  MapAddrProc := SavedMapAddr
End;

function EnablePage1: Boolean;
var
  PageSize: Word;
Begin
  EnablePage1 := false;
  PageSize := Free1Seg - Page0Seg;
  If Free1Seg + PageSize <= EndSeg then Begin
    Page1Seg := Free1Seg;
    Free1Seg := Free1Seg + PageSize;
    EnablePage1 := true
  End
End;

begin
  If DetectVesa then Begin
    If qInitVesaGraph > qInitGraphProc then Begin
      qInitGraphProc := qInitVesaGraph;
       InitGraphProc :=  InitVesaGraph
    End;
    If qCloseVesaGraph > qCloseGraphProc then Begin
      qCloseGraphProc := qCloseVesaGraph;
       CloseGraphProc :=  CloseVesaGraph
    End;
    SetStdMapAddr
  End
end.
