PROGRAM WWinDemo;

{ Demo program for the unit WWin 2.0 }
{ Program and unit are Copyright (C) 1996 by Frank Heckenbach }
{ See accompanying files README.TXT and REGISTER.TXT for details }

{ Gives best effects if Windoze is set up to 256 or more colors }

USES WWin;

CONST
  max=10;
  width: ARRAY[1..max] OF Byte=(4, 5,6, 7,8, 8,10,12,16,16);
  height:ARRAY[1..max] OF Byte=(6,12,8,12,8,12,18,16, 8,12);
  gsize=85;

VAR FontNr,a,b:Word;

PROCEDURE Pal_F;
VAR k:Byte;
BEGIN
  FOR k:=0 TO 15 DO SetRGBPalette( 16+k,128+8*k,128+8*k,255-16*k);
  FOR k:=0 TO 15 DO SetRGBPalette( 32+k,255,255-16*k,0);
  FOR k:=0 TO 15 DO SetRGBPalette( 48+k,255,0,16*k);
  FOR k:=0 TO 63 DO SetRGBPalette( 64+k,255-4*k,4*k,255);
  FOR k:=0 TO 63 DO SetRGBPalette(128+k,0,255,255-4*k);
  FOR k:=0 TO 63 DO SetRGBPalette(192+k,0,255-4*k,0)
END;

BEGIN
  Randomize;
  REPEAT
    {$IFDEF WINDOWS}
    AutoCloseWin:=True;
    AutoTracking:=False;
    SetWWinTitle('WWin-Demo - Text mode');
    FontNr:=Random(max)+1;
    SetTextSizes(74,26,width[FontNr],height[FontNr]);
    {$ENDIF}
    Window(1,1,ScreenSize.x,ScreenSize.y);
    FrameWin('WWin Window',DoubleFrame,$10*Cyan+White,$10*Cyan+White);
    SetBlinking(False);
    TextAttr:=$10*Yellow+Black;
    ClrScr;
    Inc(WindMin,$404);
    Writeln;
    Writeln('WWin unit');
    Writeln;
    {$IFDEF WINDOWS}
    Writeln('OEM-Font...');
    Writeln;
    Writeln('Variable character and screen size...');
    Writeln;
    Writeln('Character width:  ',width[FontNr]);
    Writeln;
    Writeln('Character height: ',height[FontNr]);
    Writeln;
    Writeln('Window width:  ',ScreenSize.x);
    Writeln;
    Writeln('Window height: ',ScreenSize.y);
    Writeln;
    {$ENDIF}
    Writeln('Text mode colors:');
    Writeln;
    FOR b:=1 TO 4 DO
      BEGIN
        FOR a:=0 TO 15 DO
          BEGIN
            TextColor(a);
            Write('');
          END;
        Writeln
      END;
    TextAttr:=NormAttr;
    Writeln;
    Write('Press any key to continue or Esc to abort...');
    IF ReadKey=#27 THEN Break;
    {$IFDEF WINDOWS}
    SetGrSizes(gsize,gsize,Random(10)+1,Random(10)+1);
    SetWWinTitle('WWin-Demo - Graphics mode');
    {$ENDIF}
    InitGraph_V256;
    SetVisualPage(1);
    Pal_F;
    FOR a:=0 TO gsize-1 DO
      FOR b:=0 TO gsize-1 DO
        PutPixel(a,b,Lo(a+b+16));
    SetVisualPage(0);
    IF ReadKey=#27 THEN Break;
    CloseGraph_V256
  UNTIL False;
  CloseGraph_V256;
  SetBlinking(True)
END.
